/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.treeparser;

import org.prorefactor.treeparser.Block;
import org.prorefactor.treeparser.symbols.TableBuffer;

public class BufferScope {
    private Strength strength;
    private Block block;
    private TableBuffer symbol;

    public BufferScope(Block block, TableBuffer symbol, Strength strength) {
        this.block = block;
        this.symbol = symbol;
        this.strength = strength;
    }

    public Block getBlock() {
        return this.block;
    }

    Strength getStrength() {
        return this.strength;
    }

    public TableBuffer getSymbol() {
        return this.symbol;
    }

    public boolean isStrong() {
        return this.strength == Strength.STRONG;
    }

    public boolean isWeak() {
        return this.strength == Strength.WEAK;
    }

    public void setBlock(Block block) {
        this.block = block;
    }

    public void setStrength(Strength strength) {
        this.strength = strength;
    }

    static enum Strength {
        STRONG(1),
        WEAK(2),
        REFERENCE(3),
        HIDDEN_CURSOR(4);

        int value;

        private Strength(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

