/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.treeparser;

import antlr.ANTLRException;
import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import com.google.common.base.Strings;
import eu.rssw.pct.TypeInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.TokenSource;
import org.prorefactor.core.JPNodeMetrics;
import org.prorefactor.core.nodetypes.ProgramRootNode;
import org.prorefactor.macrolevel.IncludeRef;
import org.prorefactor.macrolevel.MacroLevel;
import org.prorefactor.macrolevel.MacroRef;
import org.prorefactor.macrolevel.PreprocessorEventListener;
import org.prorefactor.proparse.IntegerIndex;
import org.prorefactor.proparse.ParserSupport;
import org.prorefactor.proparse.ProParser;
import org.prorefactor.proparse.antlr4.ProgressLexer;
import org.prorefactor.refactor.RefactorSession;
import org.prorefactor.treeparser.IJPTreeParser;
import org.prorefactor.treeparser.TreeParserRootSymbolScope;
import org.prorefactor.treeparser01.ITreeParserAction;
import org.prorefactor.treeparser01.TP01Support;
import org.prorefactor.treeparser01.TreeParser01;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class ParseUnit {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParseUnit.class);
    private final RefactorSession session;
    private final File file;
    private final InputStream input;
    private final String relativeName;
    private IntegerIndex<String> fileNameList;
    private ProgramRootNode topNode;
    private IncludeRef macroGraph;
    private boolean appBuilderCode;
    private List<PreprocessorEventListener.EditableCodeSection> sections;
    private TreeParserRootSymbolScope rootScope;
    private JPNodeMetrics metrics;
    private Document xref = null;
    private TypeInfo typeInfo = null;
    private List<Integer> trxBlocks;
    private ParserSupport support;

    public ParseUnit(File file, RefactorSession session) {
        this(file, file.getPath(), session);
    }

    public ParseUnit(File file, String relativeName, RefactorSession session) {
        this.file = file;
        this.input = null;
        this.relativeName = relativeName;
        this.session = session;
    }

    public ParseUnit(InputStream input, String relativeName, RefactorSession session) {
        this.file = null;
        this.input = input;
        this.relativeName = relativeName;
        this.session = session;
    }

    public TreeParserRootSymbolScope getRootScope() {
        return this.rootScope;
    }

    public void setRootScope(TreeParserRootSymbolScope rootScope) {
        this.rootScope = rootScope;
    }

    public ProgramRootNode getTopNode() {
        return this.topNode;
    }

    public JPNodeMetrics getMetrics() {
        return this.metrics;
    }

    public String getIncludeFileName(int index) {
        if (this.fileNameList == null) {
            return "";
        }
        return Strings.nullToEmpty((String)this.fileNameList.getValue(index));
    }

    @Nullable
    public IncludeRef getMacroGraph() {
        return this.macroGraph;
    }

    @Nonnull
    public MacroRef[] getMacroSourceArray() {
        if (this.macroGraph == null) {
            return new MacroRef[0];
        }
        return MacroLevel.sourceArray(this.macroGraph);
    }

    public TokenSource lex4() {
        return new ProgressLexer(this.session, this.getInputStream(), this.relativeName, true);
    }

    public TokenSource preprocess4() {
        return new ProgressLexer(this.session, this.getInputStream(), this.relativeName, false);
    }

    public TokenStream lex() {
        ProgressLexer lexer = new ProgressLexer(this.session, this.getInputStream(), this.relativeName, true);
        return lexer.getANTLR2TokenStream(false);
    }

    public TokenStream preprocess() {
        ProgressLexer lexer = new ProgressLexer(this.session, this.getInputStream(), this.relativeName, false);
        return lexer.getANTLR2TokenStream(true);
    }

    public void lexAndGenerateMetrics() {
        LOGGER.trace("Entering ParseUnit#lexAndGenerateMetrics()");
        ProgressLexer lexer = new ProgressLexer(this.session, this.getInputStream(), this.relativeName, true);
        TokenStream stream = lexer.getANTLR2TokenStream(false);
        try {
            Token tok = stream.nextToken();
            while (tok.getType() != 1) {
                tok = stream.nextToken();
            }
        }
        catch (TokenStreamException tokenStreamException) {
            // empty catch block
        }
        this.metrics = lexer.getMetrics();
        LOGGER.trace("Exiting ParseUnit#lex()");
    }

    public void parse() throws ANTLRException {
        LOGGER.trace("Entering ParseUnit#parse()");
        ProgressLexer lexer = new ProgressLexer(this.session, this.getInputStream(), this.relativeName, false);
        ProParser parser = new ProParser(lexer.getANTLR2TokenStream(true));
        parser.initAntlr4(this.session, lexer.getFilenameList());
        parser.program();
        ((ProgramRootNode)parser.getAST()).backLinkAndFinalize();
        lexer.parseComplete();
        this.fileNameList = lexer.getFilenameList();
        this.macroGraph = lexer.getMacroGraph();
        this.appBuilderCode = ((PreprocessorEventListener)lexer.getLstListener()).isAppBuilderCode();
        this.sections = ((PreprocessorEventListener)lexer.getLstListener()).getEditableCodeSections();
        this.metrics = lexer.getMetrics();
        this.topNode = (ProgramRootNode)parser.getAST();
        this.support = parser.support;
        LOGGER.trace("Exiting ParseUnit#parse()");
    }

    public void treeParser(IJPTreeParser tp) throws ANTLRException {
        LOGGER.trace("Entering ParseUnit#treeParser()");
        if (this.getTopNode() == null) {
            this.parse();
        }
        tp.program(this.getTopNode());
        LOGGER.trace("Exiting ParseUnit#treeParser()");
    }

    public void treeParser01() throws ANTLRException {
        LOGGER.trace("Entering ParseUnit#treeParser01()");
        if (this.getTopNode() == null) {
            this.parse();
        }
        TP01Support action = new TP01Support(this.session, this);
        TreeParser01 tp = new TreeParser01(action);
        this.treeParser(tp);
        LOGGER.trace("Exiting ParseUnit#treeParser01()");
    }

    public void treeParser01(ITreeParserAction action) throws ANTLRException {
        if (this.getTopNode() == null) {
            this.parse();
        }
        TreeParser01 tp = new TreeParser01(action);
        this.treeParser(tp);
    }

    public void attachXref(Document xref) {
        this.xref = xref;
    }

    public void attachTypeInfo(TypeInfo unit) {
        this.typeInfo = unit;
    }

    public void attachTransactionBlocks(List<Integer> blocks) {
        this.trxBlocks = blocks;
    }

    @Nullable
    public Document getXref() {
        return this.xref;
    }

    @Nullable
    public TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public List<Integer> getTransactionBlocks() {
        return this.trxBlocks;
    }

    public ParserSupport getSupport() {
        return this.support;
    }

    public RefactorSession getSession() {
        return this.session;
    }

    public boolean isAppBuilderCode() {
        return this.appBuilderCode;
    }

    public boolean isInEditableSection(int file, int line) {
        if (!this.appBuilderCode || file > 0) {
            return true;
        }
        for (PreprocessorEventListener.EditableCodeSection range : this.sections) {
            if (range.getFileNum() != file || range.getStartLine() > line || range.getEndLine() < line) continue;
            return true;
        }
        return false;
    }

    private InputStream getInputStream() {
        try {
            if (this.input == null) {
                return new FileInputStream(this.file);
            }
            return this.input;
        }
        catch (IOException caught) {
            throw new UncheckedIOException(caught);
        }
    }
}

