/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.treeparser;

import org.prorefactor.treeparser.TreeParserSymbolScope;
import org.prorefactor.treeparser.symbols.Dataset;
import org.prorefactor.treeparser.symbols.Datasource;
import org.prorefactor.treeparser.symbols.Query;
import org.prorefactor.treeparser.symbols.Stream;
import org.prorefactor.treeparser.symbols.Symbol;
import org.prorefactor.treeparser.symbols.widgets.Browse;
import org.prorefactor.treeparser.symbols.widgets.Button;
import org.prorefactor.treeparser.symbols.widgets.Frame;
import org.prorefactor.treeparser.symbols.widgets.Image;
import org.prorefactor.treeparser.symbols.widgets.Menu;
import org.prorefactor.treeparser.symbols.widgets.MenuItem;
import org.prorefactor.treeparser.symbols.widgets.Rectangle;
import org.prorefactor.treeparser.symbols.widgets.Submenu;

public final class SymbolFactory {
    private SymbolFactory() {
    }

    public static Symbol create(int symbolType, String name, TreeParserSymbolScope scope) {
        switch (symbolType) {
            case 1014: {
                return new Dataset(name, scope);
            }
            case 1013: {
                return new Datasource(name, scope);
            }
            case 623: {
                return new Query(name, scope);
            }
            case 753: {
                return new Stream(name, scope);
            }
            case 75: {
                return new Browse(name, scope);
            }
            case 83: {
                return new Button(name, scope);
            }
            case 296: {
                return new Frame(name, scope);
            }
            case 360: {
                return new Image(name, scope);
            }
            case 457: {
                return new Menu(name, scope);
            }
            case 458: {
                return new MenuItem(name, scope);
            }
            case 645: {
                return new Rectangle(name, scope);
            }
            case 760: {
                return new Submenu(name, scope);
            }
        }
        assert (false) : "Unexpected values for SymbolFactory " + symbolType + " " + name;
        return null;
    }
}

