/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.treeparser;

import com.google.common.base.Strings;
import eu.rssw.pct.TypeInfo;
import eu.rssw.pct.elements.BufferElement;
import java.util.HashMap;
import java.util.Map;
import org.prorefactor.core.schema.Field;
import org.prorefactor.core.schema.IField;
import org.prorefactor.core.schema.ITable;
import org.prorefactor.core.schema.Table;
import org.prorefactor.refactor.RefactorSession;
import org.prorefactor.treeparser.TreeParserSymbolScope;
import org.prorefactor.treeparser.symbols.Dataset;
import org.prorefactor.treeparser.symbols.FieldBuffer;
import org.prorefactor.treeparser.symbols.Routine;
import org.prorefactor.treeparser.symbols.TableBuffer;
import org.prorefactor.treeparser.symbols.Variable;
import org.sonar.plugins.openedge.api.objects.RCodeTTWrapper;

public class TreeParserRootSymbolScope
extends TreeParserSymbolScope {
    private final RefactorSession refSession;
    private Map<String, ITable> tableMap = new HashMap<String, ITable>();
    private String className = null;
    private TypeInfo typeInfo = null;
    private boolean isInterface;
    private boolean abstractClass;
    private boolean serializableClass;
    private boolean finalClass;

    public TreeParserRootSymbolScope(RefactorSession session) {
        this.refSession = session;
    }

    public RefactorSession getRefactorSession() {
        return this.refSession;
    }

    public void addTableDefinitionIfNew(ITable table) {
        String lowerName = table.getName().toLowerCase();
        if (this.tableMap.get(lowerName) == null) {
            this.tableMap.put(lowerName, table);
        }
    }

    public TableBuffer defineTable(String name, int type) {
        Table table = new Table(name, type);
        this.tableMap.put(name.toLowerCase(), table);
        TableBuffer bufferSymbol = new TableBuffer("", (TreeParserSymbolScope)this, table);
        this.bufferMap.put(name.toLowerCase(), bufferSymbol);
        return bufferSymbol;
    }

    public FieldBuffer defineTableField(String name, TableBuffer buffer) {
        ITable table = buffer.getTable();
        Field field = new Field(name, table);
        return new FieldBuffer(this, buffer, field);
    }

    public FieldBuffer defineTableFieldDelayedAttach(String name, TableBuffer buffer) {
        Field field = new Field(name, null);
        return new FieldBuffer(this, buffer, field);
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isClass() {
        return this.className != null;
    }

    public void setInterface(boolean isInterface) {
        this.isInterface = isInterface;
    }

    public boolean isInterface() {
        return this.className != null && this.isInterface;
    }

    public void setAbstractClass(boolean abstractClass) {
        this.abstractClass = abstractClass;
    }

    public boolean isAbstractClass() {
        return this.abstractClass;
    }

    public void setFinalClass(boolean finalClass) {
        this.finalClass = finalClass;
    }

    public boolean isFinalClass() {
        return this.finalClass;
    }

    public void setSerializableClass(boolean serializableClass) {
        this.serializableClass = serializableClass;
    }

    public boolean isSerializableClass() {
        return this.serializableClass;
    }

    public TableBuffer getLocalTableBuffer(ITable table) {
        assert (table.getStoretype() != 1102);
        return (TableBuffer)this.bufferMap.get(table.getName().toLowerCase());
    }

    @Override
    public Variable lookupVariable(String name) {
        Variable var = super.lookupVariable(name);
        if (var != null) {
            return var;
        }
        TypeInfo info = this.typeInfo;
        while (info != null) {
            if (info.hasProperty(name)) {
                return new Variable(name, this);
            }
            info = this.refSession.getTypeInfo(info.getParentTypeName());
        }
        return null;
    }

    @Override
    public Dataset lookupDataset(String name) {
        Dataset ds = super.lookupDataset(name);
        if (ds != null) {
            return ds;
        }
        return null;
    }

    public ITable lookupTableDefinition(String name) {
        return this.tableMap.get(name.toLowerCase());
    }

    @Override
    public TableBuffer lookupBuffer(String name) {
        TableBuffer buff = super.lookupBuffer(name);
        if (buff != null) {
            return buff;
        }
        TypeInfo info = this.typeInfo;
        while (info != null) {
            if (info.hasBuffer(name)) {
                BufferElement elem = info.getBuffer(name);
                ITable tbl = null;
                tbl = !Strings.isNullOrEmpty((String)elem.getDatabaseName()) ? this.refSession.getSchema().lookupTable(elem.getDatabaseName(), elem.getTableName()) : this.lookupTempTable(elem.getTableName()).getTable();
                if (tbl == null) {
                    tbl = new Table(name, 1103);
                }
                return new TableBuffer(name, (TreeParserSymbolScope)this, tbl);
            }
            info = this.refSession.getTypeInfo(info.getParentTypeName());
        }
        return null;
    }

    @Override
    public TableBuffer lookupTempTable(String name) {
        TableBuffer buff = super.lookupTempTable(name);
        if (buff != null) {
            return buff;
        }
        TypeInfo info = this.typeInfo;
        while (info != null) {
            if (info.hasTempTable(name)) {
                return new TableBuffer(name, (TreeParserSymbolScope)this, new RCodeTTWrapper(info.getTempTable(name)));
            }
            info = this.refSession.getTypeInfo(info.getParentTypeName());
        }
        return null;
    }

    protected IField lookupUnqualifiedField(String name) {
        for (ITable table : this.tableMap.values()) {
            IField field = table.lookupField(name);
            if (field == null) continue;
            return field;
        }
        return null;
    }

    public Map<String, Routine> getRoutineMap() {
        return this.routineMap;
    }

    public void setClassName(String s) {
        this.className = s;
    }

    public void setTypeInfo(TypeInfo typeInfo) {
        this.typeInfo = typeInfo;
    }
}

