/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.treeparser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.prorefactor.core.schema.ITable;
import org.prorefactor.treeparser.Block;
import org.prorefactor.treeparser.Call;
import org.prorefactor.treeparser.TreeParserRootSymbolScope;
import org.prorefactor.treeparser.symbols.Dataset;
import org.prorefactor.treeparser.symbols.Datasource;
import org.prorefactor.treeparser.symbols.Query;
import org.prorefactor.treeparser.symbols.Routine;
import org.prorefactor.treeparser.symbols.Stream;
import org.prorefactor.treeparser.symbols.Symbol;
import org.prorefactor.treeparser.symbols.TableBuffer;
import org.prorefactor.treeparser.symbols.Variable;
import org.prorefactor.treeparser.symbols.Widget;
import org.prorefactor.treeparser.symbols.widgets.IFieldLevelWidget;

public class TreeParserSymbolScope {
    protected final TreeParserSymbolScope parentScope;
    protected List<Symbol> allSymbols = new ArrayList<Symbol>();
    protected List<Call> callList = new ArrayList<Call>();
    protected List<TreeParserSymbolScope> childScopes = new ArrayList<TreeParserSymbolScope>();
    protected Block rootBlock;
    protected Routine routine;
    protected Map<String, TableBuffer> bufferMap = new HashMap<String, TableBuffer>();
    protected Map<String, IFieldLevelWidget> fieldLevelWidgetMap = new HashMap<String, IFieldLevelWidget>();
    protected Map<String, Routine> routineMap = new HashMap<String, Routine>();
    protected Map<ITable, TableBuffer> unnamedBuffers = new HashMap<ITable, TableBuffer>();
    protected Map<Integer, Map<String, Symbol>> typeMap = new HashMap<Integer, Map<String, Symbol>>();
    protected Map<String, Variable> variableMap = new HashMap<String, Variable>();

    protected TreeParserSymbolScope() {
        this(null);
    }

    private TreeParserSymbolScope(TreeParserSymbolScope parentScope) {
        this.parentScope = parentScope;
        this.typeMap.put(841, Collections.checkedMap(this.variableMap, String.class, Symbol.class));
    }

    private void add(IFieldLevelWidget widget) {
        this.fieldLevelWidgetMap.put(widget.getName().toLowerCase(), widget);
    }

    public void setRoutine(Routine routine) {
        if (this.routine != null) {
            throw new IllegalStateException();
        }
        this.routine = routine;
    }

    public Routine getRoutine() {
        return this.routine;
    }

    private void add(Routine routine) {
        this.routineMap.put(routine.getName().toLowerCase(), routine);
    }

    private void add(TableBuffer tableBuffer) {
        ITable table = tableBuffer.getTable();
        this.addTableBuffer(tableBuffer.getName(), table, tableBuffer);
        this.getRootScope().addTableDefinitionIfNew(table);
    }

    private void add(Variable var) {
        this.variableMap.put(var.getName().toLowerCase(), var);
    }

    private void addTableBuffer(String name, ITable table, TableBuffer buffer) {
        if (name.length() == 0) {
            if (table.getStoretype() == 1102) {
                this.unnamedBuffers.put(table, buffer);
            } else {
                this.bufferMap.put(table.getName().toLowerCase(), buffer);
            }
        } else {
            this.bufferMap.put(name.toLowerCase(), buffer);
        }
    }

    public void add(Symbol symbol) {
        if (symbol instanceof IFieldLevelWidget) {
            this.add((IFieldLevelWidget)((Object)symbol));
        } else if (symbol instanceof Variable) {
            this.add((Variable)symbol);
        } else if (symbol instanceof Routine) {
            this.add((Routine)symbol);
        } else if (symbol instanceof TableBuffer) {
            this.add((TableBuffer)symbol);
        } else {
            Map<String, Symbol> map = this.typeMap.get(symbol.getProgressType());
            if (map == null) {
                map = new HashMap<String, Symbol>();
                this.typeMap.put(symbol.getProgressType(), map);
            }
            map.put(symbol.getName().toLowerCase(), symbol);
        }
    }

    public TreeParserSymbolScope addScope() {
        TreeParserSymbolScope newScope = new TreeParserSymbolScope(this);
        this.childScopes.add(newScope);
        return newScope;
    }

    public void addSymbol(Symbol symbol) {
        this.allSymbols.add(symbol);
    }

    public TableBuffer defineBuffer(String name, ITable table) {
        TableBuffer buffer = new TableBuffer(name, this, table);
        this.addTableBuffer(name, table, buffer);
        return buffer;
    }

    public int depth() {
        int depth = 0;
        TreeParserSymbolScope scope = this;
        while ((scope = scope.getParentScope()) != null) {
            ++depth;
        }
        return depth;
    }

    public List<Symbol> getAllSymbols() {
        return new ArrayList<Symbol>(this.allSymbols);
    }

    public <T extends Symbol> List<T> getAllSymbols(Class<T> klass) {
        ArrayList<Symbol> ret = new ArrayList<Symbol>();
        for (Symbol s : this.allSymbols) {
            if (!klass.isInstance(s)) continue;
            ret.add(s);
        }
        return ret;
    }

    public List<Symbol> getAllSymbolsDeep() {
        ArrayList<Symbol> ret = new ArrayList<Symbol>(this.allSymbols);
        for (TreeParserSymbolScope child : this.childScopes) {
            ret.addAll(child.getAllSymbolsDeep());
        }
        return ret;
    }

    public <T extends Symbol> List<T> getAllSymbolsDeep(Class<T> klass) {
        List<T> ret = this.getAllSymbols(klass);
        for (TreeParserSymbolScope child : this.childScopes) {
            ret.addAll(child.getAllSymbols(klass));
        }
        return ret;
    }

    public Set<Map.Entry<String, TableBuffer>> getBufferSet() {
        return this.bufferMap.entrySet();
    }

    public TableBuffer getBufferSymbol(String inName) {
        TableBuffer symbol = this.lookupBuffer(inName);
        if (symbol != null) {
            return symbol;
        }
        ITable table = this.getRootScope().getRefactorSession().getSchema().lookupTable(inName);
        if (table == null) {
            return null;
        }
        return this.getUnnamedBuffer(table);
    }

    public List<Call> getCallList() {
        return this.callList;
    }

    public List<TreeParserSymbolScope> getChildScopes() {
        return new ArrayList<TreeParserSymbolScope>(this.childScopes);
    }

    public List<TreeParserSymbolScope> getChildScopesDeep() {
        ArrayList<TreeParserSymbolScope> ret = new ArrayList<TreeParserSymbolScope>();
        for (TreeParserSymbolScope child : this.childScopes) {
            ret.add(child);
            ret.addAll(child.getChildScopesDeep());
        }
        return ret;
    }

    public TreeParserSymbolScope getParentScope() {
        return this.parentScope;
    }

    public Block getRootBlock() {
        return this.rootBlock;
    }

    public TreeParserRootSymbolScope getRootScope() {
        if (this.parentScope == null) {
            return (TreeParserRootSymbolScope)this;
        }
        return this.parentScope.getRootScope();
    }

    public TableBuffer getUnnamedBuffer(ITable table) {
        assert (table.getStoretype() == 1102);
        TreeParserSymbolScope nextScope = this;
        while (nextScope != null) {
            TableBuffer buffer = nextScope.unnamedBuffers.get(table);
            if (buffer != null) {
                return buffer;
            }
            nextScope = nextScope.parentScope;
        }
        return this.getRootScope().defineBuffer("", table);
    }

    public Collection<Variable> getVariables() {
        return this.variableMap.values();
    }

    public Variable getVariable(String name) {
        return this.variableMap.get(name.toLowerCase());
    }

    public boolean hasRoutine(String name) {
        if (name == null) {
            return false;
        }
        return this.routineMap.containsKey(name.toLowerCase());
    }

    public boolean isActiveIn(TreeParserSymbolScope theScope) {
        while (theScope != null) {
            if (this == theScope) {
                return true;
            }
            theScope = theScope.parentScope;
        }
        return false;
    }

    public TableBuffer lookupBuffer(String inName) {
        String bufferPart;
        String[] parts = inName.split("\\.");
        String dbPart = "";
        if (parts.length == 1) {
            bufferPart = inName;
        } else {
            dbPart = parts[0];
            bufferPart = parts[1];
        }
        TableBuffer symbol = this.bufferMap.get(bufferPart.toLowerCase());
        if (symbol == null || !dbPart.isEmpty() && !dbPart.equalsIgnoreCase(symbol.getTable().getDatabase().getName()) || !dbPart.isEmpty() && symbol.getTable().getStoretype() == 1103) {
            TableBuffer tb;
            if (this.parentScope != null && (tb = this.parentScope.lookupBuffer(inName)) != null) {
                return tb;
            }
            return null;
        }
        return symbol;
    }

    public Dataset lookupDataset(String name) {
        return (Dataset)this.lookupSymbolLocally(1014, name);
    }

    public Datasource lookupDatasource(String name) {
        return (Datasource)this.lookupSymbolLocally(1013, name);
    }

    public IFieldLevelWidget lookupFieldLevelWidget(String inName) {
        IFieldLevelWidget wid = this.fieldLevelWidgetMap.get(inName.toLowerCase());
        if (wid == null && this.parentScope != null) {
            return this.parentScope.lookupFieldLevelWidget(inName);
        }
        return wid;
    }

    public Query lookupQuery(String name) {
        return (Query)this.lookupSymbolLocally(623, name);
    }

    public Routine lookupRoutine(String name) {
        return this.routineMap.get(name.toLowerCase());
    }

    public Stream lookupStream(String name) {
        return (Stream)this.lookupSymbolLocally(753, name);
    }

    public Symbol lookupSymbol(Integer symbolType, String name) {
        Symbol symbol = this.lookupSymbolLocally(symbolType, name);
        if (symbol != null) {
            return symbol;
        }
        if (this.parentScope != null) {
            return this.parentScope.lookupSymbol(symbolType, name);
        }
        return null;
    }

    public Symbol lookupSymbolLocally(Integer symbolType, String name) {
        Map<String, Symbol> map = this.typeMap.get(symbolType);
        if (map == null) {
            return null;
        }
        return map.get(name.toLowerCase());
    }

    public TableBuffer lookupTableOrBufferSymbol(String inName) {
        String tblName = inName.indexOf(46) == -1 ? inName : inName.substring(inName.indexOf(46) + 1);
        ITable table = this.getRootScope().getRefactorSession().getSchema().lookupTable(tblName);
        if (table != null && tblName.equalsIgnoreCase(table.getName())) {
            return this.getUnnamedBuffer(table);
        }
        TableBuffer ret2 = this.lookupBuffer(tblName);
        if (ret2 != null) {
            return ret2;
        }
        if (table != null) {
            return this.getUnnamedBuffer(table);
        }
        if (this.parentScope == null) {
            return null;
        }
        return this.parentScope.lookupTableOrBufferSymbol(inName);
    }

    public TableBuffer lookupTempTable(String name) {
        TableBuffer buff = this.bufferMap.get(name.toLowerCase());
        if (buff != null) {
            return buff;
        }
        if (this.parentScope == null) {
            return null;
        }
        return this.parentScope.lookupTempTable(name);
    }

    public Variable lookupVariable(String inName) {
        Variable var = this.variableMap.get(inName.toLowerCase());
        if (var == null && this.parentScope != null) {
            return this.parentScope.lookupVariable(inName);
        }
        return var;
    }

    public Widget lookupWidget(int widgetType, String name) {
        Widget ret = (Widget)this.lookupSymbolLocally(widgetType, name);
        if (ret == null && this.parentScope != null) {
            return this.parentScope.lookupWidget(widgetType, name);
        }
        return ret;
    }

    public void registerCall(Call call) {
        this.callList.add(call);
    }

    public void setRootBlock(Block block) {
        this.rootBlock = block;
    }

    public String toString() {
        return "SymbolScope associated with " + this.rootBlock.toString();
    }
}

