/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.treeparser.symbols;

import org.prorefactor.core.JPNode;
import org.prorefactor.core.schema.Field;
import org.prorefactor.core.schema.IField;
import org.prorefactor.core.schema.ISchema;
import org.prorefactor.treeparser.DataType;
import org.prorefactor.treeparser.Primative;
import org.prorefactor.treeparser.TreeParserSymbolScope;
import org.prorefactor.treeparser.symbols.Symbol;
import org.prorefactor.treeparser.symbols.TableBuffer;

public class FieldBuffer
extends Symbol
implements Primative {
    private final TableBuffer buffer;
    private final IField field;

    public FieldBuffer(TreeParserSymbolScope scope, TableBuffer buffer, IField field) {
        super("", scope);
        this.buffer = buffer;
        this.field = field;
        buffer.addFieldBuffer(this);
    }

    @Override
    public void assignAttributesLike(Primative likePrim) {
        this.field.assignAttributesLike(likePrim);
    }

    public boolean canMatch(Field.Name input) {
        assert (input.generateName().equalsIgnoreCase(input.generateName()));
        Field.Name self = new Field.Name(this.fullName().toLowerCase());
        if (input.getDb() != null) {
            ISchema schema = this.getScope().getRootScope().getRefactorSession().getSchema();
            if (this.buffer.getTable().getDatabase() != schema.lookupDatabase(input.getDb())) {
                return false;
            }
        }
        if (input.getTable() != null && (this.buffer.isDefaultSchema() ? !self.getTable().startsWith(input.getTable()) : !self.getTable().equals(input.getTable()))) {
            return false;
        }
        return self.getField().startsWith(input.getField());
    }

    @Override
    public String fullName() {
        StringBuilder buff = new StringBuilder(this.buffer.fullName());
        buff.append(".");
        buff.append(this.field.getName());
        return buff.toString();
    }

    public TableBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public String getClassName() {
        return this.field.getClassName();
    }

    @Override
    public DataType getDataType() {
        return this.field.getDataType();
    }

    @Override
    public int getExtent() {
        return this.field.getExtent();
    }

    public IField getField() {
        return this.field;
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public int getProgressType() {
        return 265;
    }

    @Override
    public Primative setClassName(String className) {
        this.field.setClassName(className);
        return this;
    }

    @Override
    public Primative setClassName(JPNode typeNameNode) {
        this.field.setClassName(typeNameNode);
        return this;
    }

    @Override
    public Primative setDataType(DataType dataType) {
        this.field.setDataType(dataType);
        return this;
    }

    @Override
    public Primative setExtent(int extent) {
        this.field.setExtent(extent);
        return this;
    }
}

