/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.treeparser.symbols;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.prorefactor.core.JPNode;
import org.prorefactor.core.schema.Field;
import org.prorefactor.treeparser.TreeParserSymbolScope;
import org.prorefactor.treeparser.symbols.FieldBuffer;
import org.prorefactor.treeparser.symbols.Symbol;
import org.prorefactor.treeparser.symbols.Variable;
import org.prorefactor.treeparser.symbols.Widget;

public abstract class FieldContainer
extends Widget {
    private List<JPNode> statementList = new ArrayList<JPNode>();
    private Set<FieldBuffer> fieldSet = new HashSet<FieldBuffer>();
    private Set<Symbol> enabledFields = new HashSet<Symbol>();
    private Set<Symbol> otherSymbols = new HashSet<Symbol>();
    private Set<Variable> variableSet = new HashSet<Variable>();

    public FieldContainer(String name, TreeParserSymbolScope scope) {
        super(name, scope);
    }

    public void addStatement(JPNode node) {
        this.statementList.add(node);
    }

    public void addSymbol(Symbol symbol, boolean statementIsEnabler) {
        if (symbol instanceof FieldBuffer) {
            this.fieldSet.add((FieldBuffer)symbol);
        } else if (symbol instanceof Variable) {
            ((Variable)symbol).referencedInFrame();
            this.variableSet.add((Variable)symbol);
        } else {
            this.otherSymbols.add(symbol);
        }
        if (statementIsEnabler) {
            this.enabledFields.add(symbol);
        }
    }

    public List<Symbol> getAllFields() {
        ArrayList<Symbol> ret = new ArrayList<Symbol>();
        ret.addAll(this.variableSet);
        ret.addAll(this.fieldSet);
        return ret;
    }

    public List<Symbol> getAllFieldsAndWidgets() {
        List<Symbol> ret = this.getAllFields();
        ret.addAll(this.otherSymbols);
        return ret;
    }

    public List<Symbol> getEnabledFields() {
        ArrayList<Symbol> ret = new ArrayList<Symbol>();
        ret.addAll(this.enabledFields);
        return ret;
    }

    public List<JPNode> getStatementList() {
        return this.statementList;
    }

    public Symbol lookupFieldOrVar(Field.Name name) {
        if (name.getTable() == null) {
            for (Variable var : this.variableSet) {
                if (!var.getName().equalsIgnoreCase(name.getField())) continue;
                return var;
            }
        }
        for (FieldBuffer fieldBuffer : this.fieldSet) {
            if (!fieldBuffer.canMatch(name)) continue;
            return fieldBuffer;
        }
        for (Symbol symbol : this.otherSymbols) {
            Symbol s;
            if (!(symbol instanceof FieldContainer) || (s = ((FieldContainer)symbol).lookupFieldOrVar(name)) == null) continue;
            return s;
        }
        return null;
    }
}

