/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.treeparser.symbols;

import org.prorefactor.core.JPNode;
import org.prorefactor.treeparser.ContextQualifier;
import org.prorefactor.treeparser.TreeParserSymbolScope;
import org.prorefactor.treeparser.symbols.ISymbol;

public abstract class Symbol
implements ISymbol {
    private int allRefsCount = 0;
    private int numReads = 0;
    private int numWrites = 0;
    private int numRefd = 0;
    private JPNode asNode;
    private boolean parameter = false;
    private JPNode defNode;
    private JPNode likeNode;
    private TreeParserSymbolScope scope;
    private final String name;

    public Symbol(String name, TreeParserSymbolScope scope) {
        this(name, scope, false);
    }

    public Symbol(String name, TreeParserSymbolScope scope, boolean parameter) {
        this.name = name;
        this.scope = scope;
        this.parameter = parameter;
        scope.addSymbol(this);
    }

    @Override
    public void setAsNode(JPNode asNode) {
        this.asNode = asNode;
    }

    @Override
    public void setDefOrIdNode(JPNode node) {
        this.defNode = node;
    }

    @Override
    public void setLikeNode(JPNode likeNode) {
        this.likeNode = likeNode;
    }

    @Override
    public int getAllRefsCount() {
        return this.allRefsCount;
    }

    @Override
    public int getNumReads() {
        return this.numReads;
    }

    @Override
    public int getNumWrites() {
        return this.numWrites;
    }

    @Override
    public int getNumReferenced() {
        return this.numRefd;
    }

    @Override
    public JPNode getAsNode() {
        return this.asNode;
    }

    @Override
    public JPNode getDefineNode() {
        if (this.defNode != null && this.defNode.getType() != 913) {
            return this.defNode;
        }
        return null;
    }

    @Override
    public JPNode getIndirectDefineIdNode() {
        if (this.defNode != null && this.defNode.getType() == 913) {
            return this.defNode;
        }
        return null;
    }

    @Override
    public JPNode getLikeNode() {
        return this.likeNode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TreeParserSymbolScope getScope() {
        return this.scope;
    }

    @Override
    public void noteReference(ContextQualifier contextQualifier) {
        ++this.allRefsCount;
        if (ContextQualifier.isRead(contextQualifier)) {
            ++this.numReads;
        }
        if (ContextQualifier.isWrite(contextQualifier)) {
            ++this.numWrites;
        }
        if (ContextQualifier.isReference(contextQualifier)) {
            ++this.numRefd;
        }
    }

    public String toString() {
        return this.fullName();
    }

    public void setParameter(boolean parameter) {
        this.parameter = parameter;
    }

    public boolean isParameter() {
        return this.parameter;
    }
}

