/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.treeparser.symbols;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.prorefactor.core.schema.IField;
import org.prorefactor.core.schema.ITable;
import org.prorefactor.treeparser.TreeParserSymbolScope;
import org.prorefactor.treeparser.symbols.FieldBuffer;
import org.prorefactor.treeparser.symbols.Symbol;

public class TableBuffer
extends Symbol {
    private final ITable table;
    private final boolean isDefault;
    private final Map<IField, FieldBuffer> fieldBuffers = new HashMap<IField, FieldBuffer>();

    public TableBuffer(String name, TreeParserSymbolScope scope, ITable table) {
        super(name, scope);
        this.table = table;
        this.isDefault = name.isEmpty();
    }

    void addFieldBuffer(FieldBuffer fieldBuffer) {
        this.fieldBuffers.put(fieldBuffer.getField(), fieldBuffer);
    }

    @Override
    public String fullName() {
        if (this.table.getStoretype() != 1102) {
            return this.getName();
        }
        return this.table.getDatabase().getName() + "." + this.getName();
    }

    public Collection<FieldBuffer> getFieldBufferList() {
        return this.fieldBuffers.values();
    }

    @Override
    public int getProgressType() {
        return 77;
    }

    public FieldBuffer getFieldBuffer(IField field) {
        assert (field.getTable() == this.table);
        FieldBuffer ret = this.fieldBuffers.get(field);
        if (ret != null) {
            return ret;
        }
        ret = new FieldBuffer(this.getScope(), this, field);
        this.fieldBuffers.put(field, ret);
        return ret;
    }

    @Override
    public String getName() {
        if (super.getName().isEmpty()) {
            return this.table.getName();
        }
        return super.getName();
    }

    public ITable getTable() {
        return this.table;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isDefaultSchema() {
        return this.isDefault && this.table.getStoretype() == 1102;
    }
}

