/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.treeparser.symbols;

import org.prorefactor.core.JPNode;
import org.prorefactor.treeparser.ClassSupport;
import org.prorefactor.treeparser.DataType;
import org.prorefactor.treeparser.Primative;
import org.prorefactor.treeparser.TreeParserSymbolScope;
import org.prorefactor.treeparser.Value;
import org.prorefactor.treeparser.symbols.Symbol;

public class Variable
extends Symbol
implements Primative,
Value {
    private int extent;
    private DataType dataType;
    private Object value;
    private String className = null;
    private boolean refInFrame = false;

    public Variable(String name, TreeParserSymbolScope scope) {
        super(name, scope);
    }

    public Variable(String name, TreeParserSymbolScope scope, boolean parameter) {
        super(name, scope, parameter);
    }

    @Override
    public void assignAttributesLike(Primative likePrim) {
        this.dataType = likePrim.getDataType();
        this.className = likePrim.getClassName();
        this.extent = likePrim.getExtent();
    }

    @Override
    public String fullName() {
        return this.getName();
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public int getExtent() {
        return this.extent;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public int getProgressType() {
        return 841;
    }

    @Override
    public Primative setClassName(String s) {
        this.className = s;
        return this;
    }

    @Override
    public Primative setClassName(JPNode typeNameNode) {
        this.className = ClassSupport.qualifiedClassName(typeNameNode);
        return this;
    }

    @Override
    public Primative setDataType(DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    @Override
    public Primative setExtent(int extent) {
        this.extent = extent;
        return this;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    public void referencedInFrame() {
        this.refInFrame = true;
    }

    public boolean isReferencedInFrame() {
        return this.refInFrame;
    }
}

