/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.treeparser01;

import antlr.SemanticException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.prorefactor.core.ABLNodeType;
import org.prorefactor.core.JPNode;
import org.prorefactor.core.nodetypes.BlockNode;
import org.prorefactor.core.nodetypes.FieldRefNode;
import org.prorefactor.core.nodetypes.RecordNameNode;
import org.prorefactor.core.schema.IField;
import org.prorefactor.core.schema.IIndex;
import org.prorefactor.core.schema.ITable;
import org.prorefactor.core.schema.Index;
import org.prorefactor.refactor.RefactorSession;
import org.prorefactor.treeparser.Block;
import org.prorefactor.treeparser.BufferScope;
import org.prorefactor.treeparser.Call;
import org.prorefactor.treeparser.ContextQualifier;
import org.prorefactor.treeparser.DataType;
import org.prorefactor.treeparser.Expression;
import org.prorefactor.treeparser.FieldLookupResult;
import org.prorefactor.treeparser.Parameter;
import org.prorefactor.treeparser.ParseUnit;
import org.prorefactor.treeparser.Primative;
import org.prorefactor.treeparser.SymbolFactory;
import org.prorefactor.treeparser.TreeParserException;
import org.prorefactor.treeparser.TreeParserRootSymbolScope;
import org.prorefactor.treeparser.TreeParserSymbolScope;
import org.prorefactor.treeparser.symbols.Dataset;
import org.prorefactor.treeparser.symbols.Event;
import org.prorefactor.treeparser.symbols.FieldBuffer;
import org.prorefactor.treeparser.symbols.Routine;
import org.prorefactor.treeparser.symbols.Symbol;
import org.prorefactor.treeparser.symbols.TableBuffer;
import org.prorefactor.treeparser.symbols.Variable;
import org.prorefactor.treeparser.symbols.widgets.Browse;
import org.prorefactor.treeparser01.FrameStack;
import org.prorefactor.treeparser01.ITreeParserAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TP01Support
implements ITreeParserAction {
    private static final Logger LOG = LoggerFactory.getLogger(TP01Support.class);
    private List<Block> blockStack = new ArrayList<Block>();
    private Block currentBlock;
    private Expression wipExpression;
    private FrameStack frameStack = new FrameStack();
    private Map<String, TreeParserSymbolScope> funcForwards = new HashMap<String, TreeParserSymbolScope>();
    private Deque<Call> wipCalls = new LinkedList<Call>();
    private Deque<Parameter> wipParameters = new LinkedList<Parameter>();
    private Routine currentRoutine;
    private Routine rootRoutine;
    private final RefactorSession refSession;
    private final ParseUnit unit;
    private final TreeParserRootSymbolScope rootScope;
    private Symbol currSymbol;
    private TreeParserSymbolScope currentScope;
    private TableBuffer lastTableReferenced;
    private TableBuffer prevTableReferenced;
    private TableBuffer currDefTable;
    private Index currDefIndex;
    private boolean currDefTableUseIndex = false;
    private ITable currDefTableLike = null;
    private boolean inDefineEvent = false;

    public TP01Support(RefactorSession session, ParseUnit unit) {
        this.refSession = session;
        this.unit = unit;
        this.rootScope = new TreeParserRootSymbolScope(this.refSession);
        this.currentScope = this.rootScope;
    }

    @Override
    public ParseUnit getParseUnit() {
        return this.unit;
    }

    @Override
    public void addToSymbolScope(Object o) {
        LOG.trace("addToSymbolScope - Adding {} to {}", o, (Object)this.currentScope);
        if (this.inDefineEvent) {
            return;
        }
        this.currentScope.add((Symbol)o);
    }

    @Override
    public void blockBegin(JPNode blockAST) {
        LOG.trace("Entering blockBegin {}", (Object)blockAST);
        BlockNode blockNode = (BlockNode)blockAST;
        this.currentBlock = this.pushBlock(new Block(this.currentBlock, (JPNode)blockNode));
        blockNode.setBlock(this.currentBlock);
    }

    @Override
    public void blockEnd() {
        LOG.trace("Entering blockEnd");
        this.currentBlock = this.popBlock();
    }

    @Override
    public void browseRef(JPNode idAST) {
        LOG.trace("Entering browseRef {}", (Object)idAST);
        this.frameStack.browseRefNode(idAST, this.currentScope);
    }

    @Override
    public void bufferRef(JPNode idAST) {
        LOG.trace("Entering bufferRef {}", (Object)idAST);
        TableBuffer tableBuffer = this.currentScope.lookupBuffer(idAST.getText());
        if (tableBuffer != null) {
            tableBuffer.noteReference(ContextQualifier.SYMBOL);
        }
    }

    @Override
    public void callBegin(JPNode callNode) {
        LOG.trace("Entering callBegin {}", (Object)callNode);
        Call call = new Call(callNode);
        callNode.setCall(call);
        this.wipCalls.addFirst(call);
    }

    @Override
    public void callEnd() {
        LOG.trace("Entering callEnd");
        this.currentScope.registerCall(this.wipCalls.getFirst());
        this.wipCalls.removeFirst();
    }

    @Override
    public void callConstructorBegin(JPNode callNode) {
        LOG.trace("Entering callConstructorBegin {}", (Object)callNode);
        Call call = new Call(callNode);
        callNode.setCall(call);
        this.wipCalls.addFirst(call);
    }

    @Override
    public void callConstructorEnd() {
        LOG.trace("Entering callConstructorEnd");
        this.currentScope.registerCall(this.wipCalls.getFirst());
        this.wipCalls.removeFirst();
    }

    @Override
    public void callMethodBegin(JPNode callNode) {
        LOG.trace("Entering callMethodBegin {}", (Object)callNode);
        Call call = new Call(callNode);
        callNode.setCall(call);
        this.wipCalls.addFirst(call);
    }

    @Override
    public void callMethodEnd() {
        LOG.trace("Entering callMethodEnd");
        this.currentScope.registerCall(this.wipCalls.getFirst());
        this.wipCalls.removeFirst();
    }

    @Override
    public void canFindBegin(JPNode canfindAST, JPNode recordAST) {
        boolean isDefault;
        ITable table;
        LOG.trace("Entering canFindBegin {} - {}", (Object)canfindAST, (Object)recordAST);
        RecordNameNode recordNode = (RecordNameNode)recordAST;
        Block b = this.currentBlock;
        this.scopeAdd(canfindAST);
        this.currentBlock.setParent(b);
        String buffName = recordAST.getText();
        TableBuffer tableBuffer = this.currentScope.lookupBuffer(buffName);
        if (tableBuffer != null) {
            table = tableBuffer.getTable();
            isDefault = tableBuffer.isDefault();
            tableBuffer.noteReference(ContextQualifier.INIT);
        } else {
            table = this.refSession.getSchema().lookupTable(buffName);
            isDefault = true;
        }
        TableBuffer newBuff = this.currentScope.defineBuffer(isDefault ? "" : buffName, table);
        recordNode.setTableBuffer(newBuff);
        this.currentBlock.addHiddenCursor(recordNode);
    }

    @Override
    public void canFindEnd(JPNode canfindAST) {
        LOG.trace("Entering canFindEnd {}", (Object)canfindAST);
        this.scopeClose(canfindAST);
    }

    @Override
    public void classState(JPNode classNode, JPNode abstractKw, JPNode finalKw, JPNode serializableKw) {
        LOG.trace("Entering classState {}", (Object)classNode);
        JPNode idNode = classNode.getFirstChild();
        this.rootScope.setClassName(idNode.getText());
        this.rootScope.setTypeInfo(this.refSession.getTypeInfo(idNode.getText()));
        this.rootScope.setAbstractClass(abstractKw != null);
        this.rootScope.setFinalClass(finalKw != null);
        this.rootScope.setSerializableClass(serializableKw != null);
    }

    @Override
    public void interfaceState(JPNode classNode) {
        LOG.trace("Entering interfaceState {}", (Object)classNode);
        JPNode idNode = classNode.getFirstChild();
        this.rootScope.setClassName(idNode.getText());
        this.rootScope.setTypeInfo(this.refSession.getTypeInfo(idNode.getText()));
        this.rootScope.setInterface(true);
    }

    @Override
    public void clearState(JPNode headNode) {
        LOG.trace("Entering clearState {}", (Object)headNode);
        JPNode firstChild = headNode.getFirstChild();
        if (firstChild.getType() == 296) {
            this.frameStack.simpleFrameInitStatement(headNode, firstChild.nextNode(), this.currentBlock);
        }
    }

    @Override
    public void datasetTable(JPNode tableAST) {
        LOG.trace("Entering datasetTable {}", (Object)tableAST);
        RecordNameNode tableNode = (RecordNameNode)tableAST;
        Dataset dataset = (Dataset)this.currSymbol;
        dataset.addBuffer(tableNode.getTableBuffer());
    }

    @Override
    public void defAs(JPNode asNode) {
        LOG.trace("Entering defAs {}", (Object)asNode);
        this.currSymbol.setAsNode(asNode);
        Primative primative = (Primative)((Object)this.currSymbol);
        JPNode typeNode = asNode.nextNode();
        if (typeNode.getType() == 1101) {
            typeNode = typeNode.nextNode();
        }
        if (typeNode.getType() == 1125) {
            primative.setDataType(DataType.getDataType(1101));
            primative.setClassName(typeNode);
        } else {
            primative.setDataType(DataType.getDataType(typeNode.getType()));
        }
        assert (primative.getDataType() != null) : "Failed to set datatype at " + asNode.getFilename() + " line " + asNode.getLine();
    }

    @Override
    public void defExtent(JPNode extentNode) {
        LOG.trace("Entering defExtent {}", (Object)extentNode);
        Primative primative = (Primative)((Object)this.currSymbol);
        JPNode exprNode = extentNode.getFirstChild();
        if (exprNode == null || exprNode.getType() != 6) {
            primative.setExtent(-1);
        } else {
            primative.setExtent(Integer.parseInt(exprNode.getText()));
        }
    }

    @Override
    public void defLike(JPNode likeNode) {
        LOG.trace("Entering defLike {}", (Object)likeNode);
        this.currSymbol.setLikeNode(likeNode);
        Primative likePrim = (Primative)((Object)likeNode.nextNode().getSymbol());
        Primative newPrim = (Primative)((Object)this.currSymbol);
        if (likePrim != null) {
            newPrim.assignAttributesLike(likePrim);
            assert (newPrim.getDataType() != null) : "Failed to set datatype at " + likeNode.getFilename() + " line " + likeNode.getLine();
        } else {
            LOG.error("Failed to find LIKE datatype at {} line {}", (Object)likeNode.getFilename(), (Object)likeNode.getLine());
        }
    }

    @Override
    public Browse defineBrowse(JPNode defAST, JPNode idAST) {
        LOG.trace("Entering defineBrowse {} - {}", (Object)defAST, (Object)idAST);
        Browse browse = (Browse)this.defineSymbol(75, defAST, idAST);
        this.frameStack.nodeOfDefineBrowse(browse, defAST);
        return browse;
    }

    @Override
    public void defineBuffer(JPNode defAST, JPNode idNode, JPNode tableAST, boolean init) {
        LOG.trace("Entering defineBuffer {} {} {} {}", new Object[]{defAST, idNode, tableAST, init});
        ITable table = this.astTableLink(tableAST);
        TableBuffer bufSymbol = this.currentScope.defineBuffer(idNode.getText(), table);
        this.currSymbol = bufSymbol;
        bufSymbol.setDefOrIdNode(defAST);
        idNode.setLink(-210, bufSymbol);
        if (init) {
            BufferScope bufScope = this.currentBlock.getBufferForReference(bufSymbol);
            idNode.setLink(-212, bufScope);
        }
    }

    @Override
    public void defineBufferForTrigger(JPNode tableAST) {
        LOG.trace("Entering defineBufferForTrigger {}", (Object)tableAST);
        ITable table = this.astTableLink(tableAST);
        TableBuffer bufSymbol = this.currentScope.defineBuffer("", table);
        this.currentBlock.getBufferForReference(bufSymbol);
        this.currSymbol = bufSymbol;
    }

    @Override
    public Event defineEvent(JPNode defNode, JPNode idNode) {
        LOG.trace("Entering defineEvent {} - {}", (Object)defNode, (Object)idNode);
        String name = idNode.getText();
        if (name == null || name.length() == 0) {
            name = idNode.getNodeType().name();
        }
        Event event = new Event(name, this.currentScope);
        event.setDefOrIdNode(defNode);
        this.currSymbol = event;
        idNode.setLink(-210, event);
        return event;
    }

    @Override
    public Symbol defineSymbol(int symbolType, JPNode defNode, JPNode idNode) {
        LOG.trace("Entering defineSymbol {} - {} - {}", new Object[]{symbolType, defNode, idNode});
        Symbol symbol = SymbolFactory.create(symbolType, idNode.getText(), this.currentScope);
        symbol.setDefOrIdNode(defNode);
        this.currSymbol = symbol;
        idNode.setLink(-210, symbol);
        return symbol;
    }

    @Override
    public Symbol defineTableFieldInitialize(JPNode idNode) {
        LOG.trace("Entering defineTableFieldInitialize {}", (Object)idNode);
        FieldBuffer fieldBuff = this.rootScope.defineTableFieldDelayedAttach(idNode.getText(), this.currDefTable);
        this.currSymbol = fieldBuff;
        fieldBuff.setDefOrIdNode(idNode);
        idNode.setLink(-210, fieldBuff);
        return fieldBuff;
    }

    @Override
    public void defineTableFieldFinalize(Object obj) {
        LOG.trace("Entering defineTableFieldFinalize {}", obj);
        ((FieldBuffer)obj).getField().setTable(this.currDefTable.getTable());
    }

    @Override
    public void defineTableLike(JPNode tableAST) {
        ITable table;
        LOG.trace("Entering defineTableLike {}", (Object)tableAST);
        this.currDefTableLike = table = this.astTableLink(tableAST);
        for (IField field : table.getFieldPosOrder()) {
            this.rootScope.defineTableField(field.getName(), this.currDefTable).assignAttributesLike(field);
        }
    }

    @Override
    public void defineUseIndex(JPNode recNode, JPNode idNode) throws SemanticException {
        LOG.trace("Entering defineUseIndex {}", (Object)idNode);
        ITable table = this.astTableLink(recNode);
        IIndex idx = table.lookupIndex(idNode.getText());
        this.currDefTable.getTable().add(new Index(this.currDefTable.getTable(), idx.getName(), idx.isUnique(), idx.isPrimary()));
        this.currDefTableUseIndex = true;
    }

    @Override
    public void defineIndexInitialize(JPNode idNode, JPNode unique, JPNode primary, JPNode word) throws SemanticException {
        LOG.trace("Entering defineIndexInitialize {} - {} - {} - {}", new Object[]{idNode, unique, primary, word});
        this.currDefIndex = new Index(this.currDefTable.getTable(), idNode.getText(), unique != null, primary != null);
        this.currDefTable.getTable().add(this.currDefIndex);
    }

    @Override
    public void defineIndexField(JPNode idNode) throws SemanticException {
        LOG.trace("Entering defineIndexField{}", (Object)idNode);
        IField fld = this.currDefTable.getTable().lookupField(idNode.getText());
        if (fld != null) {
            this.currDefIndex.addField(fld);
        }
    }

    public void defineTable(JPNode defNode, JPNode idNode, int storeType) {
        LOG.trace("Entering defineTable {} {} {}", new Object[]{defNode, idNode, storeType});
        TableBuffer buffer = this.rootScope.defineTable(idNode.getText(), storeType);
        buffer.setDefOrIdNode(defNode);
        this.currSymbol = buffer;
        this.currDefTable = buffer;
        this.currDefTableLike = null;
        this.currDefTableUseIndex = false;
        idNode.setLink(-210, buffer);
    }

    @Override
    public void postDefineTempTable(JPNode defAST, JPNode idNode) throws SemanticException {
        LOG.trace("Entering postDefineTempTable {} {}", (Object)defAST, (Object)idNode);
        if (this.currDefTableLike != null && !this.currDefTableUseIndex && this.currDefTable.getTable().getIndexes().isEmpty()) {
            LOG.trace("Copying all indexes from {}", (Object)this.currDefTableLike.getName());
            for (IIndex idx : this.currDefTableLike.getIndexes()) {
                Index newIdx = new Index(this.currDefTable.getTable(), idx.getName(), idx.isUnique(), idx.isPrimary());
                for (IField fld : idx.getFields()) {
                    IField ifld = newIdx.getTable().lookupField(fld.getName());
                    if (ifld == null) {
                        LOG.info("Unable to find field name {} in table {}", (Object)fld.getName(), (Object)this.currDefTable.getTable().getName());
                        continue;
                    }
                    newIdx.addField(ifld);
                }
                this.currDefTable.getTable().add(newIdx);
            }
        }
    }

    @Override
    public void defineTempTable(JPNode defAST, JPNode idAST) {
        this.defineTable(defAST, idAST, 1103);
    }

    @Override
    public Variable defineVariable(JPNode defAST, JPNode idAST) {
        return this.defineVariable(defAST, idAST, false);
    }

    @Override
    public Variable defineVariable(JPNode defNode, JPNode idNode, boolean parameter) {
        LOG.trace("Entering defineVariable {} {} {}", new Object[]{defNode, idNode, parameter});
        String name = idNode.getText();
        if (name == null || name.length() == 0) {
            name = idNode.getNodeType().name();
        }
        Variable variable = new Variable(name, this.currentScope, parameter);
        variable.setDefOrIdNode(defNode);
        this.currSymbol = variable;
        idNode.setLink(-210, variable);
        return variable;
    }

    @Override
    public Variable defineVariable(JPNode defAST, JPNode idAST, int dataType) {
        return this.defineVariable(defAST, idAST, dataType, false);
    }

    @Override
    public Variable defineVariable(JPNode defAST, JPNode idAST, int dataType, boolean parameter) {
        assert (dataType != 1101);
        Variable v = this.defineVariable(defAST, idAST, parameter);
        v.setDataType(DataType.getDataType(dataType));
        return v;
    }

    @Override
    public Variable defineVariable(JPNode defAST, JPNode idAST, JPNode likeAST) {
        return this.defineVariable(defAST, idAST, likeAST, false);
    }

    @Override
    public Variable defineVariable(JPNode defAST, JPNode idAST, JPNode likeAST, boolean parameter) {
        Variable v = this.defineVariable(defAST, idAST, parameter);
        FieldRefNode likeRefNode = (FieldRefNode)likeAST;
        v.setDataType(likeRefNode.getDataType());
        v.setClassName(likeRefNode.getClassName());
        return v;
    }

    @Override
    public void defineWorktable(JPNode defAST, JPNode idAST) {
        this.defineTable(defAST, idAST, 1104);
    }

    @Override
    public void widattr(JPNode widAST, JPNode idNode, ContextQualifier cq) {
        LOG.trace("Entering {} mode {}", (Object)idNode, (Object)cq);
        if (idNode.getType() == 1120) {
            JPNode tok = idNode.getNextSibling();
            if (tok.getType() == 7) {
                JPNode fld = tok.getNextSibling();
                String name = fld.getText();
                FieldLookupResult result = this.currentBlock.lookupField(name, true);
                if (result == null) {
                    return;
                }
                if (result.variable != null) {
                    result.variable.noteReference(cq);
                }
            }
        } else if (idNode.getType() == 969 && idNode.getFirstChild().getType() == 913 && idNode.getNextSibling() != null && idNode.getNextSibling().getType() == 7) {
            String clsRef = idNode.getFirstChild().getText();
            String clsName = this.rootScope.getClassName();
            if (clsRef != null && clsName != null && clsRef.indexOf(46) == -1 && clsName.indexOf(46) != -1) {
                clsName = clsName.substring(clsName.indexOf(46) + 1);
            }
            if (clsRef != null && clsName != null && clsRef.equalsIgnoreCase(clsName)) {
                String right = idNode.getNextSibling().getNextSibling().getText();
                FieldLookupResult result = this.currentBlock.lookupField(right, true);
                if (result == null) {
                    return;
                }
                if (result.variable != null) {
                    result.variable.noteReference(cq);
                }
            }
        }
    }

    @Override
    public void field(JPNode refAST, JPNode idNode, ContextQualifier cq, ITreeParserAction.TableNameResolution resolution) throws SemanticException {
        LOG.trace("Entering field {} {} {} {}", new Object[]{refAST, idNode, cq, resolution});
        FieldRefNode refNode = (FieldRefNode)refAST;
        String name = idNode.getText();
        FieldLookupResult result = null;
        refNode.attrSet(10160, cq.toString());
        if (refNode.attrGet(2000) == 1) {
            this.addToSymbolScope(this.defineVariable(idNode, idNode));
        }
        if (refNode.getParent().getType() == 833 && refNode.getParent().getParent().getType() == 996 || refNode.getFirstChild().getType() == 382 && (refNode.getNextSibling() == null || refNode.getNextSibling().getType() != 7)) {
            result = this.frameStack.inputFieldLookup(refNode, this.currentScope);
        } else if (resolution == ITreeParserAction.TableNameResolution.ANY) {
            boolean getBufferScope = cq != ContextQualifier.SYMBOL;
            result = this.currentBlock.lookupField(name, getBufferScope);
        } else {
            String[] parts = name.split("\\.");
            String fieldPart = parts[parts.length - 1];
            TableBuffer ourBuffer = resolution == ITreeParserAction.TableNameResolution.PREVIOUS ? this.prevTableReferenced : this.lastTableReferenced;
            IField field = ourBuffer.getTable().lookupField(fieldPart);
            if (field == null) {
                int parentType = refNode.getParent().getType();
                if (parentType == 266 || parentType == 248) {
                    return;
                }
                throw new TreeParserException(idNode.getFilename() + ":" + idNode.getLine() + " Unknown field or variable name: " + fieldPart);
            }
            FieldBuffer fieldBuffer = ourBuffer.getFieldBuffer(field);
            result = new FieldLookupResult();
            result.field = fieldBuffer;
        }
        if (result == null) {
            return;
        }
        if (result.isUnqualified) {
            refNode.attrSet((Integer)10150, 1);
        }
        if (result.isAbbreviated) {
            refNode.attrSet((Integer)1700, 1);
        }
        if (result.variable != null) {
            refNode.setSymbol(result.variable);
            refNode.attrSet((Integer)1100, 1105);
            result.variable.noteReference(cq);
        }
        if (result.fieldLevelWidget != null) {
            refNode.setSymbol(result.fieldLevelWidget);
            refNode.attrSet((Integer)1100, 1105);
            result.fieldLevelWidget.noteReference(cq);
        }
        if (result.bufferScope != null) {
            refNode.setBufferScope(result.bufferScope);
        }
        if (result.field != null) {
            refNode.setSymbol(result.field);
            refNode.attrSet((Integer)1100, result.field.getField().getTable().getStoretype());
            result.field.noteReference(cq);
            if (result.field.getBuffer() != null) {
                result.field.getBuffer().noteReference(cq);
            }
        }
        if (result.event != null) {
            refNode.setSymbol(result.event);
            refNode.attrSet((Integer)1100, 1105);
            result.event.noteReference(cq);
        }
    }

    @Override
    public void fnvExpression(JPNode node) {
        LOG.trace("fnvExpression  {}", (Object)node);
        this.wipExpression = new Expression(node);
    }

    @Override
    public void fnvFilename(JPNode node) {
        LOG.trace("Entering fnvFilename {}", (Object)node);
        Expression exp = new Expression(node);
        exp.setValue(node.getText());
        this.wipExpression = exp;
    }

    @Override
    public void formItem(JPNode ast) {
        LOG.trace("Entering formItem {}", (Object)ast);
        this.frameStack.formItem(ast);
    }

    @Override
    public void frameBlockCheck(JPNode ast) {
        LOG.trace("Entering frameBlockCheck {}", (Object)ast);
        this.frameStack.nodeOfBlock(ast, this.currentBlock);
    }

    @Override
    public void frameDef(JPNode defAST, JPNode idAST) {
        LOG.trace("Entering frameDef {} {}", (Object)defAST, (Object)idAST);
        this.frameStack.nodeOfDefineFrame(defAST, idAST, this.currentScope);
    }

    @Override
    public void frameEnablingStatement(JPNode ast) {
        LOG.trace("Entering frameEnablingStatement {}", (Object)ast);
        this.frameStack.statementIsEnabler();
        this.frameStack.nodeOfInitializingStatement(ast, this.currentBlock);
    }

    @Override
    public void frameInitializingStatement(JPNode ast) {
        this.frameStack.nodeOfInitializingStatement(ast, this.currentBlock);
    }

    @Override
    public void frameStatementEnd() {
        this.frameStack.statementEnd();
    }

    @Override
    public void frameRef(JPNode idAST) {
        this.frameStack.frameRefNode(idAST, this.currentScope);
    }

    @Override
    public void funcBegin(JPNode funcAST, JPNode idNode) {
        LOG.trace("Entering funcBegin {} {}", (Object)funcAST, (Object)idNode);
        this.scopeAdd(funcAST);
        BlockNode blockNode = (BlockNode)idNode.getParent();
        TreeParserSymbolScope definingScope = this.currentScope.getParentScope();
        Routine r = new Routine(idNode.getText(), definingScope, this.currentScope);
        r.setProgressType(310);
        r.setDefOrIdNode(blockNode);
        blockNode.setSymbol(r);
        definingScope.add((Symbol)r);
        this.currentRoutine = r;
    }

    @Override
    public void funcDef(JPNode funcAST, JPNode idAST) {
        LOG.trace("Entering funcDef {} {}", (Object)funcAST, (Object)idAST);
        if (!this.currentRoutine.getParameters().isEmpty()) {
            return;
        }
        TreeParserSymbolScope forwardScope = this.funcForwards.get(idAST.getText());
        if (forwardScope != null) {
            Routine routine = (Routine)forwardScope.getRootBlock().getNode().getSymbol();
            this.scopeSwap(forwardScope);
            BlockNode blocknode = (BlockNode)funcAST;
            blocknode.setBlock(this.currentBlock);
            blocknode.setSymbol(routine);
            routine.setDefOrIdNode(blocknode);
            this.currentRoutine = routine;
        }
    }

    @Override
    public void funcEnd(JPNode funcAST) {
        LOG.trace("Entering funcEnd {}", (Object)funcAST);
        this.scopeClose(funcAST);
        this.currentRoutine = this.rootRoutine;
    }

    @Override
    public void funcForward(JPNode idAST) {
        LOG.trace("Entering funcForward {}", (Object)idAST);
        this.funcForwards.put(idAST.getText(), this.currentScope);
    }

    @Override
    public void lexat(JPNode fieldRefAST) {
        LOG.trace("Entering lexAt {}", (Object)fieldRefAST);
        this.frameStack.lexAt(fieldRefAST);
    }

    @Override
    public void methodBegin(JPNode blockAST, JPNode idNode) {
        LOG.trace("Entering methodBegin {} - {}", (Object)blockAST, (Object)idNode);
        this.scopeAdd(blockAST);
        BlockNode blockNode = (BlockNode)idNode.getParent();
        TreeParserSymbolScope definingScope = this.currentScope.getParentScope();
        Routine r = new Routine(idNode.getText(), definingScope, this.currentScope);
        r.setProgressType(1112);
        r.setDefOrIdNode(blockNode);
        blockNode.setSymbol(r);
        definingScope.add((Symbol)r);
        this.currentRoutine = r;
    }

    @Override
    public void methodEnd(JPNode blockAST) {
        LOG.trace("Entering methodEnd {}", (Object)blockAST);
        this.scopeClose(blockAST);
        this.currentRoutine = this.rootRoutine;
    }

    @Override
    public void propGetSetBegin(JPNode propAST) {
        LOG.trace("Entering propGetSetBegin {}", (Object)propAST);
        this.scopeAdd(propAST);
        BlockNode blockNode = (BlockNode)propAST;
        TreeParserSymbolScope definingScope = this.currentScope.getParentScope();
        Routine r = new Routine(propAST.getText(), definingScope, this.currentScope);
        r.setProgressType(propAST.getType());
        r.setDefOrIdNode(blockNode);
        blockNode.setSymbol(r);
        definingScope.add((Symbol)r);
        this.currentRoutine = r;
    }

    @Override
    public void propGetSetEnd(JPNode propAST) {
        LOG.trace("Entering propGetSetEnd {}", (Object)propAST);
        this.scopeClose(propAST);
        this.currentRoutine = this.rootRoutine;
    }

    @Override
    public void eventBegin(JPNode eventAST, JPNode idAST) {
        this.inDefineEvent = true;
    }

    @Override
    public void eventEnd(JPNode eventAST) {
        this.inDefineEvent = false;
    }

    @Override
    public void paramBind() {
        this.wipParameters.getFirst().setBind(true);
    }

    @Override
    public void paramEnd() {
        this.wipParameters.removeFirst();
    }

    @Override
    public void paramExpression(JPNode exprNode, ContextQualifier cq) {
        LOG.trace("Entering paramExpression {}", (Object)exprNode);
        this.wipParameters.getFirst().setSymbol(exprNode.getSymbol());
        if (exprNode.getSymbol() != null) {
            exprNode.getSymbol().noteReference(cq);
        }
    }

    @Override
    public void paramForCall(JPNode directionAST) {
        LOG.trace("Entering paramForCall {}", (Object)directionAST);
        Parameter param = new Parameter();
        param.setDirectionNode(directionAST);
        this.wipParameters.addFirst(param);
        this.wipCalls.getFirst().addParameter(param);
    }

    @Override
    public void paramForRoutine(JPNode directionAST) {
        LOG.trace("Entering paramForRoutine '{}' -- '{}'", (Object)directionAST.getText(), (Object)this.currentRoutine.fullName());
        Parameter param = new Parameter();
        param.setDirectionNode(directionAST);
        this.wipParameters.addFirst(param);
        this.currentRoutine.addParameter(param);
    }

    @Override
    public void paramNoName(JPNode typeNode) {
        LOG.trace("Entering paramNoName {}", (Object)typeNode);
        Variable variable = new Variable("", this.currentScope);
        this.currSymbol = variable;
        if (typeNode.getType() == 1101) {
            typeNode = typeNode.nextNode();
        }
        if (typeNode.getType() == 1125) {
            variable.setDataType(DataType.getDataType(1101));
            variable.setClassName(typeNode);
        } else {
            variable.setDataType(DataType.getDataType(typeNode.getType()));
        }
    }

    @Override
    public void paramProgressType(int progressType) {
        this.wipParameters.getFirst().setProgressType(progressType);
    }

    @Override
    public void paramSymbol(JPNode symbolAST) {
        this.wipParameters.getFirst().setSymbol(symbolAST.getSymbol());
    }

    @Override
    public void procedureBegin(JPNode procAST, JPNode idAST) {
        LOG.trace("Entering procedureBegin {} - {}", (Object)procAST, (Object)idAST);
        BlockNode blockNode = (BlockNode)procAST;
        TreeParserSymbolScope definingScope = this.currentScope;
        this.scopeAdd(blockNode);
        Routine r = new Routine(idAST.getText(), definingScope, this.currentScope);
        r.setProgressType(600);
        r.setDefOrIdNode(blockNode);
        blockNode.setSymbol(r);
        definingScope.add((Symbol)r);
        this.currentRoutine = r;
    }

    @Override
    public void procedureEnd(JPNode node) {
        this.scopeClose(node);
        this.currentRoutine = this.rootRoutine;
    }

    @Override
    public void programRoot(JPNode rootAST) {
        LOG.trace("Entering programRoot {}", (Object)rootAST);
        BlockNode blockNode = (BlockNode)rootAST;
        this.currentBlock = this.pushBlock(new Block(this.rootScope, (JPNode)blockNode));
        this.rootScope.setRootBlock(this.currentBlock);
        blockNode.setBlock(this.currentBlock);
        this.getParseUnit().setRootScope(this.rootScope);
        Routine r = new Routine("", (TreeParserSymbolScope)this.rootScope, this.rootScope);
        r.setProgressType(979);
        r.setDefOrIdNode(blockNode);
        blockNode.setSymbol(r);
        this.rootScope.add(r);
        this.currentRoutine = r;
        this.rootRoutine = r;
    }

    @Override
    public void programTail() throws SemanticException {
        LOG.trace("Entering programTail");
        ArrayList<TreeParserSymbolScope> allScopes = new ArrayList<TreeParserSymbolScope>();
        allScopes.add(this.rootScope);
        allScopes.addAll(this.rootScope.getChildScopesDeep());
        LinkedList<Call> calls = new LinkedList<Call>();
        for (TreeParserSymbolScope scope : allScopes) {
            for (Call call : scope.getCallList()) {
                if (call.isInHandle()) {
                    calls.addLast(call);
                    continue;
                }
                calls.addFirst(call);
            }
        }
        for (Call call : calls) {
            String routineId = call.getRunArgument();
            call.wrapUp(this.rootScope.hasRoutine(routineId));
        }
    }

    private void recordNodeSymbol(JPNode node, TableBuffer buffer) throws SemanticException {
        String nodeText = node.getText();
        if (buffer == null) {
            throw new TreeParserException("Could not resolve table '" + nodeText + "'", node.getFilename(), node.getLine(), node.getColumn());
        }
        ITable table = buffer.getTable();
        this.prevTableReferenced = this.lastTableReferenced;
        this.lastTableReferenced = buffer;
        if (buffer.isDefault() && table.getStoretype() == 1102) {
            String[] nameParts = nodeText.split("\\.");
            int tableNameLen = nameParts[nameParts.length - 1].length();
            if (table.getName().length() > tableNameLen) {
                node.attrSet((Integer)1700, 1);
            }
        }
    }

    @Override
    public void recordNameNode(JPNode anode, ContextQualifier contextQualifier) throws SemanticException {
        LOG.trace("Entering recordNameNode {} {}", (Object)anode, (Object)contextQualifier);
        RecordNameNode recordNode = (RecordNameNode)anode;
        recordNode.attrSet(10160, contextQualifier.toString());
        TableBuffer buffer = null;
        switch (contextQualifier) {
            case INIT: 
            case INITWEAK: 
            case REF: 
            case REFUP: 
            case UPDATING: 
            case BUFFERSYMBOL: {
                buffer = this.currentScope.getBufferSymbol(recordNode.getText());
                break;
            }
            case SYMBOL: {
                buffer = this.currentScope.lookupTableOrBufferSymbol(anode.getText());
                break;
            }
            case TEMPTABLESYMBOL: {
                buffer = this.currentScope.lookupTempTable(anode.getText());
                break;
            }
            case SCHEMATABLESYMBOL: {
                ITable table = this.refSession.getSchema().lookupTable(anode.getText());
                if (table == null) break;
                buffer = this.currentScope.getUnnamedBuffer(table);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.recordNodeSymbol(recordNode, buffer);
        recordNode.setTableBuffer(buffer);
        switch (contextQualifier) {
            case INIT: 
            case REF: 
            case REFUP: 
            case UPDATING: {
                recordNode.setBufferScope(this.currentBlock.getBufferForReference(buffer));
                break;
            }
            case INITWEAK: {
                recordNode.setBufferScope(this.currentBlock.addWeakBufferScope(buffer));
                break;
            }
        }
        buffer.noteReference(contextQualifier);
    }

    @Override
    public void routineReturnDatatype(JPNode datatypeNode) {
        if (datatypeNode.getType() == 1101) {
            datatypeNode = datatypeNode.nextNode();
        }
        this.currentRoutine.setReturnDatatypeNode(datatypeNode);
    }

    @Override
    public void runBegin(JPNode runNode) {
        LOG.trace("Entering runBegin {}", (Object)runNode);
        String fileName = (String)this.wipExpression.getValue();
        Call call = new Call(runNode);
        call.setRunArgument(fileName);
        runNode.setCall(call);
        this.wipCalls.addFirst(call);
    }

    @Override
    public void runEnd(JPNode node) {
        this.currentScope.registerCall(this.wipCalls.getFirst());
        this.wipCalls.removeFirst();
    }

    @Override
    public void runInHandle(JPNode exprNode) {
        this.wipCalls.getFirst().setRunHandleNode(exprNode);
    }

    @Override
    public void runPersistentSet(JPNode fld) {
        this.wipCalls.getFirst().setPersistentHandleNode(fld);
    }

    @Override
    public void scopeAdd(JPNode anode) {
        LOG.trace("Entering scopeAdd {}", (Object)anode);
        BlockNode blockNode = (BlockNode)anode;
        this.currentScope = this.currentScope.addScope();
        this.currentBlock = this.pushBlock(new Block(this.currentScope, (JPNode)blockNode));
        this.currentScope.setRootBlock(this.currentBlock);
        blockNode.setBlock(this.currentBlock);
    }

    @Override
    public void scopeClose(JPNode scopeRootNode) {
        LOG.trace("Entering scopeClose {}", (Object)scopeRootNode);
        this.currentScope = this.currentScope.getParentScope();
        this.blockEnd();
    }

    private void scopeSwap(TreeParserSymbolScope scope) {
        this.currentScope = scope;
        this.blockEnd();
        this.currentBlock = this.pushBlock(scope.getRootBlock());
    }

    @Override
    public void setSymbol(int symbolType, JPNode idNode) {
        idNode.setSymbol(this.currentScope.lookupSymbol(symbolType, idNode.getText()));
    }

    @Override
    public void noteReference(JPNode node, ContextQualifier cq) throws SemanticException {
        if (node.getSymbol() != null && (cq == ContextQualifier.UPDATING || cq == ContextQualifier.REFUP)) {
            node.getSymbol().noteReference(cq);
        }
    }

    @Override
    public void strongScope(JPNode anode) {
        this.currentBlock.addStrongBufferScope((RecordNameNode)anode);
    }

    @Override
    public void structorBegin(JPNode blockAST) {
        this.scopeAdd(blockAST);
        BlockNode blockNode = (BlockNode)blockAST;
        TreeParserSymbolScope definingScope = this.currentScope.getParentScope();
        Routine r = new Routine("", definingScope, this.currentScope);
        r.setProgressType(blockNode.getType());
        r.setDefOrIdNode(blockNode);
        blockNode.setSymbol(r);
        this.currentRoutine = r;
    }

    @Override
    public void structorEnd(JPNode blockAST) {
        this.scopeClose(blockAST);
        this.currentRoutine = this.rootRoutine;
    }

    @Override
    public void viewState(JPNode headAST) {
        JPNode headNode = headAST;
        for (JPNode frameNode : headNode.query(ABLNodeType.FRAME, new ABLNodeType[0])) {
            int parentType = frameNode.getParent().getType();
            if (parentType != 988 && parentType != 368) continue;
            this.frameStack.simpleFrameInitStatement(headNode, frameNode.nextNode(), this.currentBlock);
            return;
        }
    }

    private Block popBlock() {
        this.blockStack.remove(this.blockStack.size() - 1);
        return this.blockStack.get(this.blockStack.size() - 1);
    }

    private Block pushBlock(Block block) {
        this.blockStack.add(block);
        return block;
    }

    public TreeParserSymbolScope getCurrentScope() {
        return this.currentScope;
    }

    public TreeParserRootSymbolScope getRootScope() {
        return this.rootScope;
    }

    private ITable astTableLink(JPNode tableAST) {
        LOG.trace("Entering astTableLink {}", (Object)tableAST);
        TableBuffer buffer = (TableBuffer)tableAST.getLink(-210);
        assert (buffer != null);
        return buffer.getTable();
    }
}

