/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.openedge.api.objects;

import eu.rssw.pct.elements.IndexElement;
import eu.rssw.pct.elements.TableElement;
import eu.rssw.pct.elements.VariableElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.prorefactor.core.schema.Constants;
import org.prorefactor.core.schema.IDatabase;
import org.prorefactor.core.schema.IField;
import org.prorefactor.core.schema.IIndex;
import org.prorefactor.core.schema.ITable;
import org.sonar.plugins.openedge.api.objects.RCodeTTFieldWrapper;
import org.sonar.plugins.openedge.api.objects.RCodeTTIndexWrapper;

public class RCodeTTWrapper
implements ITable {
    private final TableElement table;
    private final List<IField> fields = new ArrayList<IField>();
    private final List<IIndex> indexes = new ArrayList<IIndex>();
    private final SortedSet<IField> sortedFields = new TreeSet<IField>(Constants.FIELD_NAME_ORDER);

    public RCodeTTWrapper(TableElement t) {
        this.table = t;
        for (VariableElement variableElement : this.table.getFields()) {
            RCodeTTFieldWrapper iFld = new RCodeTTFieldWrapper(this, variableElement);
            this.fields.add(iFld);
            this.sortedFields.add(iFld);
        }
        for (VariableElement variableElement : this.table.getIndexes()) {
            RCodeTTIndexWrapper iIdx = new RCodeTTIndexWrapper(this, (IndexElement)variableElement);
            this.indexes.add(iIdx);
        }
    }

    public TableElement getBackingObject() {
        return this.table;
    }

    @Override
    public IDatabase getDatabase() {
        return Constants.nullDatabase;
    }

    @Override
    public String getName() {
        return this.table.getName();
    }

    @Override
    public void add(IField field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(IIndex index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IField lookupField(String lookupName) {
        for (IField fld : this.fields) {
            if (!fld.getName().toLowerCase().startsWith(lookupName.toLowerCase())) continue;
            return fld;
        }
        return null;
    }

    @Override
    public SortedSet<IField> getFieldSet() {
        return Collections.unmodifiableSortedSet(this.sortedFields);
    }

    @Override
    public List<IField> getFieldPosOrder() {
        return Collections.unmodifiableList(this.fields);
    }

    @Override
    public List<IIndex> getIndexes() {
        return Collections.unmodifiableList(this.indexes);
    }

    @Override
    public IIndex lookupIndex(String name) {
        for (IIndex idx : this.indexes) {
            if (!idx.getName().equalsIgnoreCase(name)) continue;
            return idx;
        }
        return null;
    }

    @Override
    public int getStoretype() {
        return 1103;
    }

    public String toString() {
        return "TT Wrapper for " + this.getName() + " - " + this.getFieldSet().size() + " fields - " + this.getIndexes().size() + " indexes";
    }
}

