/*
 * Decompiled with CFR 0.152.
 */
package eu.rssw.pct;

import java.text.MessageFormat;
import java.util.Date;

public class FileEntry
implements Comparable<FileEntry> {
    private final boolean valid;
    private final String fileName;
    private final long modDate;
    private final long addDate;
    private final int offset;
    private final int size;
    private final int tocSize;

    public FileEntry(int tocSize) {
        this.tocSize = tocSize;
        this.valid = false;
        this.fileName = "";
        this.offset = 0;
        this.modDate = this.addDate = (long)0;
        this.size = 0;
    }

    public FileEntry(String fileName, long modDate, long addDate, int offSet, int size, int tocSize) {
        this.valid = true;
        this.fileName = fileName;
        this.modDate = modDate;
        this.addDate = addDate;
        this.offset = offSet;
        this.size = size;
        this.tocSize = tocSize;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getSize() {
        return this.size;
    }

    public long getModDate() {
        return this.modDate;
    }

    public long getAddDate() {
        return this.addDate;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getTocSize() {
        return this.tocSize;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String toString() {
        return MessageFormat.format("File {0} [{1} bytes] Added {2,date} Modified {3,date} [Offset : {4}]", this.fileName, this.size, new Date(this.addDate), new Date(this.modDate), this.offset);
    }

    @Override
    public int compareTo(FileEntry o) {
        return this.fileName.compareTo(o.getFileName());
    }

    public int hashCode() {
        return this.fileName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() == obj.getClass()) {
            return ((FileEntry)obj).fileName.equalsIgnoreCase(this.fileName);
        }
        return false;
    }
}

