/*
 * Decompiled with CFR 0.152.
 */
package eu.rssw.pct;

import eu.rssw.pct.FileEntry;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class PLReader {
    private static final int MAGIC_V11 = 55051;
    private static final int ENCODING_OFFSET = 2;
    private static final int ENCODING_SIZE = 20;
    private static final int FILE_LIST_OFFSET_V11 = 34;
    private File pl;
    private List<FileEntry> files = null;

    public PLReader(File file) {
        String name = file.getPath();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkRead(name);
        }
        this.pl = file;
    }

    public List<FileEntry> getFileList() {
        if (this.files == null) {
            this.readFileList();
        }
        return this.files;
    }

    public FileEntry getEntry(String name) {
        for (FileEntry entry : this.getFileList()) {
            if (!entry.getFileName().equals(name)) continue;
            return entry;
        }
        return null;
    }

    private void readFileList() {
        try (RandomAccessFile raf = new RandomAccessFile(this.pl, "r");){
            FileChannel fc = raf.getChannel();
            ByteBuffer magic = ByteBuffer.allocate(2);
            fc.read(magic);
            if ((magic.getShort(0) & 0xFFFF) != 55051) {
                throw new RuntimeException("Not a valid PL file");
            }
            Charset charset = this.getCharset(fc);
            int offset = this.getTOCOffset(fc);
            this.files = new ArrayList<FileEntry>();
            FileEntry fe = null;
            while ((fe = this.readEntry(fc, offset, charset)) != null) {
                if (fe.isValid()) {
                    this.files.add(fe);
                }
                offset += fe.getTocSize();
            }
        }
        catch (IOException caught) {
            throw new RuntimeException(caught);
        }
    }

    public InputStream getInputStream(FileEntry fe) throws IOException {
        ByteBuffer bb = null;
        try (RandomAccessFile raf = new RandomAccessFile(this.pl, "r");){
            FileChannel fc = raf.getChannel();
            bb = ByteBuffer.allocate(fe.getSize());
            fc.read(bb, fe.getOffset());
        }
        return new ByteArrayInputStream(bb.array());
    }

    private Charset getCharset(FileChannel fc) throws IOException {
        ByteBuffer bEncoding = ByteBuffer.allocate(20);
        if (fc.read(bEncoding, 2L) != 20) {
            throw new RuntimeException("Invalid PL file");
        }
        bEncoding.position(0);
        StringBuilder sbEncoding = new StringBuilder();
        int zz = 0;
        while (zz < 20 && bEncoding.get(zz) != 0) {
            sbEncoding.append((char)bEncoding.get(zz++));
        }
        try {
            return Charset.forName(sbEncoding.toString());
        }
        catch (IllegalArgumentException iae) {
            return Charset.forName("US-ASCII");
        }
    }

    private int getTOCOffset(FileChannel fc) throws IOException {
        ByteBuffer bTOC = ByteBuffer.allocate(4);
        if (fc.read(bTOC, 34L) != 4) {
            throw new RuntimeException("Invalid PL file");
        }
        return bTOC.getInt(0);
    }

    private FileEntry readEntry(FileChannel fc, int offset, Charset charset) throws IOException {
        ByteBuffer b1 = ByteBuffer.allocate(1);
        fc.read(b1, offset);
        if (b1.get(0) == -2) {
            boolean stop = false;
            int zz = 0;
            while (!stop) {
                b1.position(0);
                int kk = fc.read(b1, (long)offset + (long)(++zz));
                stop = kk == -1 || b1.get(0) == -1;
            }
            return new FileEntry(zz);
        }
        if (b1.get(0) == -1) {
            b1.position(0);
            fc.read(b1, (long)offset + 1L);
            int fNameSize = b1.get(0) & 0xFF;
            if (fNameSize == 0) {
                return new FileEntry(29);
            }
            ByteBuffer b2 = ByteBuffer.allocate(fNameSize);
            fc.read(b2, (long)offset + 2L);
            b2.position(0);
            String fName = charset.decode(b2).toString();
            ByteBuffer b3 = ByteBuffer.allocate(48);
            fc.read(b3, (long)offset + 2L + (long)fNameSize);
            int fileOffset = b3.getInt(6);
            int fileSize = b3.getInt(11);
            long added = (long)b3.getInt(15) * 1000L;
            long modified = (long)b3.getInt(19) * 1000L;
            int tocSize = (b3.get(47) == 0 ? 50 : 49) + fNameSize;
            return new FileEntry(fName, modified, added, fileOffset, fileSize, tocSize);
        }
        return null;
    }
}

