/*
 * Decompiled with CFR 0.152.
 */
package eu.rssw.pct;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import eu.rssw.pct.elements.DataType;
import eu.rssw.pct.elements.ITypeInfo;
import eu.rssw.pct.elements.v11.TypeInfoV11;
import eu.rssw.pct.elements.v12.TypeInfoV12;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RCodeInfo {
    private static final int MAGIC1 = 1456395017;
    private static final int MAGIC2 = 164875862;
    private static final int HEADER_SIZE = 68;
    private static final int HEADER_OFFSET_MAGIC = 0;
    private static final int HEADER_OFFSET_TIMESTAMP = 4;
    private static final int HEADER_OFFSET_DIGEST = 10;
    private static final int HEADER_OFFSET_DIGEST_V12 = 22;
    private static final int HEADER_OFFSET_RCODE_VERSION = 14;
    private static final int HEADER_OFFSET_SEGMENT_TABLE_SIZE = 30;
    private static final int HEADER_OFFSET_SIGNATURE_SIZE = 56;
    private static final int HEADER_OFFSET_TYPEBLOCK_SIZE = 60;
    private static final int HEADER_OFFSET_RCODE_SIZE = 64;
    private static final int SEGMENT_TABLE_OFFSET_INITIAL_VALUE_SEGMENT_OFFSET = 0;
    private static final int SEGMENT_TABLE_OFFSET_ACTION_SEGMENT_OFFSET = 4;
    private static final int SEGMENT_TABLE_OFFSET_ECODE_SEGMENT_OFFSET = 8;
    private static final int SEGMENT_TABLE_OFFSET_DEBUG_SEGMENT_OFFSET = 12;
    private static final int SEGMENT_TABLE_OFFSET_INITIAL_VALUE_SEGMENT_SIZE = 16;
    private static final int SEGMENT_TABLE_OFFSET_ACTION_SEGMENT_SIZE = 20;
    private static final int SEGMENT_TABLE_OFFSET_ECODE_SEGMENT_SIZE = 24;
    private static final int SEGMENT_TABLE_OFFSET_DEBUG_SEGMENT_SIZE = 28;
    private static final int SEGMENT_TABLE_OFFSET_IPACS_TABLE_SIZE = 32;
    private static final int SEGMENT_TABLE_OFFSET_FRAME_SEGMENT_TABLE_SIZE = 34;
    private static final int SEGMENT_TABLE_OFFSET_TEXT_SEGMENT_TABLE_SIZE = 36;
    protected ByteOrder order;
    protected int version;
    protected boolean sixtyFourBits;
    protected long timeStamp;
    protected int digestOffset;
    protected int segmentTableSize;
    protected int signatureSize;
    protected int typeBlockSize;
    protected int rcodeSize;
    protected int initialValueSegmentOffset;
    protected int initialValueSegmentSize;
    protected int debugSegmentOffset;
    protected int debugSegmentSize;
    protected int actionSegmentOffset;
    protected int actionSegmentSize;
    protected int ecodeSegmentOffset;
    protected int ecodeSegmentSize;
    protected int ipacsTableSize;
    protected int frameSegmentTableSize;
    protected int textSegmentTableSize;
    private boolean isClass = false;
    private ITypeInfo typeInfo;

    public RCodeInfo(InputStream input) throws InvalidRCodeException, IOException {
        this(input, null);
    }

    public RCodeInfo(InputStream input, PrintStream out) throws InvalidRCodeException, IOException {
        long bytesRead;
        this.processHeader(input, out);
        this.processSignatureBlock(input, out);
        this.processSegmentTable(input, out);
        if (this.initialValueSegmentOffset >= 0 && this.initialValueSegmentSize > 0) {
            bytesRead = input.skip(this.initialValueSegmentOffset);
            if (bytesRead != (long)this.initialValueSegmentOffset) {
                throw new InvalidRCodeException("Not enough bytes to reach initial values segment");
            }
            this.processInitialValueSegment(input, out);
        }
        if (this.debugSegmentOffset > 0 && this.debugSegmentSize > 0) {
            bytesRead = input.skip((long)this.debugSegmentOffset - (long)this.initialValueSegmentSize);
            if (bytesRead != (long)(this.debugSegmentOffset - this.initialValueSegmentSize)) {
                throw new InvalidRCodeException("Not enough bytes to reach debug segment");
            }
            this.processDebugSegment(input, out);
        }
        if (this.typeBlockSize > 0) {
            int skip = this.debugSegmentOffset > 0 ? this.rcodeSize - this.debugSegmentOffset - this.debugSegmentSize : this.rcodeSize - this.initialValueSegmentSize - this.debugSegmentSize;
            long bytesRead2 = input.skip(skip);
            if (bytesRead2 != (long)skip) {
                throw new InvalidRCodeException("Not enough bytes to reach type block");
            }
            this.processTypeBlock(input, out);
            this.isClass = true;
        }
        input.close();
    }

    private final void processHeader(InputStream input, PrintStream out) throws IOException, InvalidRCodeException {
        long magic;
        byte[] header = new byte[68];
        int bytesRead = input.read(header);
        if (bytesRead != 68) {
            throw new InvalidRCodeException("Not enough bytes in header");
        }
        if (out != null) {
            out.printf("%n******%nHEADER%n******%n", new Object[0]);
            RCodeInfo.printByteBuffer(out, header);
        }
        if ((magic = (long)ByteBuffer.wrap(header, 0, 4).getInt()) == 1456395017L) {
            this.order = ByteOrder.BIG_ENDIAN;
        } else if (magic == 164875862L) {
            this.order = ByteOrder.LITTLE_ENDIAN;
        } else {
            throw new InvalidRCodeException("Can't find magic number");
        }
        this.version = ByteBuffer.wrap(header, 14, 2).order(this.order).getShort();
        boolean bl = this.sixtyFourBits = (this.version & 0x4000) != 0;
        if ((this.version & 0x3FFF) >= 1200) {
            byte[] header2 = new byte[16];
            if (input.read(header2) != 16) {
                throw new InvalidRCodeException("Not enough bytes in OE12 header");
            }
            this.timeStamp = ByteBuffer.wrap(header, 4, 4).order(this.order).getInt();
            this.digestOffset = ByteBuffer.wrap(header, 22, 2).order(this.order).getShort();
            this.segmentTableSize = ByteBuffer.wrap(header, 30, 2).order(this.order).getShort();
            this.signatureSize = ByteBuffer.wrap(header, 56, 4).order(this.order).getInt();
            this.typeBlockSize = ByteBuffer.wrap(header, 60, 4).order(this.order).getInt();
            this.rcodeSize = ByteBuffer.wrap(header2, 12, 4).order(this.order).getInt();
        } else if ((this.version & 0x3FFF) >= 1100) {
            this.timeStamp = ByteBuffer.wrap(header, 4, 4).order(this.order).getInt();
            this.digestOffset = ByteBuffer.wrap(header, 10, 2).order(this.order).getShort();
            this.segmentTableSize = ByteBuffer.wrap(header, 30, 2).order(this.order).getShort();
            this.signatureSize = ByteBuffer.wrap(header, 56, 4).order(this.order).getInt();
            this.typeBlockSize = ByteBuffer.wrap(header, 60, 4).order(this.order).getInt();
            this.rcodeSize = ByteBuffer.wrap(header, 64, 4).order(this.order).getInt();
        } else {
            throw new InvalidRCodeException("Only v11 rcode is supported");
        }
    }

    private final void processSignatureBlock(InputStream input, PrintStream out) throws IOException, InvalidRCodeException {
        byte[] header = new byte[this.signatureSize];
        int bytesRead = input.read(header);
        if (bytesRead != this.signatureSize) {
            throw new InvalidRCodeException("Not enough bytes in signature block");
        }
        if (out != null) {
            out.printf("%n*********%nSIGNATURE%n*********%n", new Object[0]);
            RCodeInfo.printByteBuffer(out, header);
        }
        int preambleSize = RCodeInfo.readAsciiEncodedNumber(header, 0, 4);
        int numElements = RCodeInfo.readAsciiEncodedNumber(header, 4, 4);
        int pos = preambleSize;
        for (int kk = 0; kk < numElements; ++kk) {
            String str = RCodeInfo.readNullTerminatedString(header, pos);
            pos += str.length() + 1;
            if (!str.startsWith("DSET") && !str.startsWith("TTAB")) continue;
        }
    }

    private final void processSegmentTable(InputStream input, PrintStream out) throws IOException, InvalidRCodeException {
        byte[] header = new byte[this.segmentTableSize];
        int bytesRead = input.read(header);
        if (bytesRead != this.segmentTableSize) {
            throw new InvalidRCodeException("Not enough bytes in segment table block");
        }
        if (out != null) {
            out.printf("%n*******%nSEGMENT%n*******%n", new Object[0]);
            RCodeInfo.printByteBuffer(out, header);
        }
        this.initialValueSegmentOffset = ByteBuffer.wrap(header, 0, 4).order(this.order).getInt();
        this.initialValueSegmentSize = ByteBuffer.wrap(header, 16, 4).order(this.order).getInt();
        this.actionSegmentOffset = ByteBuffer.wrap(header, 4, 4).order(this.order).getInt();
        this.actionSegmentSize = ByteBuffer.wrap(header, 20, 4).order(this.order).getInt();
        this.ecodeSegmentOffset = ByteBuffer.wrap(header, 8, 4).order(this.order).getInt();
        this.ecodeSegmentSize = ByteBuffer.wrap(header, 24, 4).order(this.order).getInt();
        this.debugSegmentOffset = ByteBuffer.wrap(header, 12, 4).order(this.order).getInt();
        this.debugSegmentSize = ByteBuffer.wrap(header, 28, 4).order(this.order).getInt();
        this.ipacsTableSize = ByteBuffer.wrap(header, 32, 2).order(this.order).getShort();
        this.frameSegmentTableSize = ByteBuffer.wrap(header, 34, 2).order(this.order).getShort();
        this.textSegmentTableSize = ByteBuffer.wrap(header, 36, 2).order(this.order).getShort();
    }

    void processTypeBlock(InputStream input, PrintStream out) throws IOException, InvalidRCodeException {
        byte[] segment = new byte[this.typeBlockSize];
        int bytesRead = input.read(segment);
        if (bytesRead != this.typeBlockSize) {
            throw new InvalidRCodeException("Not enough bytes in type block");
        }
        if (out != null) {
            out.printf("%n**********%nTYPE BLOCK%n***********%n", new Object[0]);
            RCodeInfo.printByteBuffer(out, segment);
        }
        this.typeInfo = (this.version & 0x3FFF) >= 1200 ? TypeInfoV12.newTypeInfo(segment, this.order) : TypeInfoV11.newTypeInfo(segment, this.order);
    }

    private final void processInitialValueSegment(InputStream input, PrintStream out) throws IOException, InvalidRCodeException {
        byte[] segment = new byte[this.initialValueSegmentSize];
        int bytesRead = input.read(segment);
        if (bytesRead != this.initialValueSegmentSize) {
            throw new InvalidRCodeException("Not enough bytes in initial value segment block");
        }
        if (out != null) {
            out.printf("%n**********%nINITIAL VALUES%n***********%n", new Object[0]);
            RCodeInfo.printByteBuffer(out, segment);
        }
    }

    void processDebugSegment(InputStream input, PrintStream out) throws IOException, InvalidRCodeException {
        byte[] segment = new byte[this.debugSegmentSize];
        int bytesRead = input.read(segment);
        if (bytesRead != this.debugSegmentSize) {
            throw new InvalidRCodeException("Not enough bytes in debug segment block");
        }
        if (out != null) {
            out.printf("%n*******%nDEBUG%n*******%n", new Object[0]);
            RCodeInfo.printByteBuffer(out, segment);
        }
    }

    public ITypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public static void printByteBuffer(PrintStream writer, byte[] block) {
        int pos;
        StringBuilder sb = new StringBuilder();
        for (pos = 0; pos < block.length; ++pos) {
            if (pos % 16 == 0) {
                writer.print(String.format("%010X | ", pos));
            }
            writer.print(String.format("%02X ", block[pos]));
            if (Character.isISOControl((char)block[pos])) {
                sb.append('.');
            } else {
                sb.append((char)block[pos]);
            }
            if (pos <= 0 || (pos + 1) % 16 != 0) continue;
            writer.println(" | " + sb.toString());
            sb = new StringBuilder();
        }
        if (pos % 16 != 0) {
            writer.print(Strings.repeat((String)"   ", (int)(16 - pos % 16)));
            writer.println(" | " + sb.toString());
        }
    }

    public long getVersion() {
        return this.version;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public boolean is64bits() {
        return this.sixtyFourBits;
    }

    public boolean isClass() {
        return this.isClass;
    }

    public static String readNullTerminatedString(byte[] array, int offset) {
        return RCodeInfo.readNullTerminatedString(array, offset, Charset.defaultCharset());
    }

    public static String readNullTerminatedString(byte[] array, int offset, Charset charset) {
        int zz = 0;
        while (zz + offset < array.length && array[zz + offset] != 0) {
            ++zz;
        }
        return charset.decode(ByteBuffer.wrap(array, offset, zz)).toString();
    }

    private static int readAsciiEncodedNumber(byte[] array, int pos, int length) throws InvalidRCodeException {
        try {
            return Integer.valueOf(new String(Arrays.copyOfRange(array, pos, pos + length)), 16);
        }
        catch (NumberFormatException caught) {
            throw new InvalidRCodeException(caught);
        }
    }

    private static Function parseProcSignature(String str) {
        Function fn = new Function();
        Iterator lst = Splitter.on((char)',').trimResults().split((CharSequence)str).iterator();
        String desc = (String)lst.next();
        fn.type = FunctionType.getTypeFromString(desc.substring(0, desc.indexOf(32)));
        fn.name = desc.substring(desc.indexOf(32) + 1, desc.lastIndexOf(32));
        fn.accessTypes = SigAccessType.getTypeFromString(desc.substring(desc.lastIndexOf(32) + 1));
        String retType = (String)lst.next();
        if (retType.isEmpty()) {
            fn.returnType = DataType.VOID;
        } else {
            if (retType.contains("[[")) {
                while (!retType.contains("]]")) {
                    retType = retType + (String)lst.next();
                }
            }
            fn.returnExtent = Integer.parseInt(retType.substring(retType.lastIndexOf(32) + 1));
            fn.returnType = DataType.getDataType(retType.substring(0, retType.lastIndexOf(32)));
            if (fn.returnType == DataType.CLASS) {
                fn.classReturnType = retType.substring(0, retType.indexOf(32));
            }
        }
        while (lst.hasNext()) {
            String str2 = (String)lst.next();
            if (str2.isEmpty()) continue;
            if (str2.contains("[[")) {
                while (!str2.contains("]]")) {
                    str2 = str2 + (String)lst.next();
                }
            }
            fn.parameters.add(RCodeInfo.parseParameter(str2));
        }
        return fn;
    }

    private static Parameter parseParameter(String str) {
        Parameter param = new Parameter();
        List prm = Splitter.on((char)' ').trimResults().splitToList((CharSequence)str);
        if (prm.size() != 4) {
            return param;
        }
        param.name = (String)prm.get(1);
        param.type = ParameterType.getTypeFromString((String)prm.get(0));
        param.datatype = DataType.getDataType((String)prm.get(2));
        param.extent = Integer.parseInt((String)prm.get(3));
        param.classType = (String)prm.get(2);
        return param;
    }

    public static class Parameter {
        private ParameterType type;
        private String name;
        private DataType datatype;
        private int extent;
        private String classType;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.type != null) {
                sb.append(this.type.toString());
            }
            sb.append(" PARAMETER ");
            if (this.type == ParameterType.BUFFER) {
                sb.append(" FOR ").append(this.name);
            } else {
                sb.append(this.name).append(" AS ").append((Object)this.datatype);
                if (this.datatype == DataType.CLASS) {
                    sb.append('{').append(this.classType).append('}');
                }
                if (this.extent > 0) {
                    sb.append(" EXTENT ").append(this.extent);
                }
            }
            return sb.toString();
        }
    }

    public static enum ParameterType {
        INPUT,
        OUTPUT,
        INPUT_OUTPUT,
        BUFFER;


        public static ParameterType getTypeFromString(String str) {
            switch (str) {
                case "1": {
                    return INPUT;
                }
                case "2": {
                    return OUTPUT;
                }
                case "3": {
                    return INPUT_OUTPUT;
                }
                case "4": {
                    return BUFFER;
                }
            }
            return null;
        }
    }

    public static enum SigAccessType {
        PUBLIC,
        PRIVATE,
        PROTECTED,
        STATIC,
        ABSTRACT,
        FINAL,
        OVERRIDE;


        public static Set<SigAccessType> getTypeFromString(String str) {
            int val = Integer.valueOf(str);
            EnumSet<SigAccessType> set = EnumSet.noneOf(SigAccessType.class);
            switch (val & 7) {
                case 1: {
                    set.add(PUBLIC);
                    break;
                }
                case 2: {
                    set.add(PRIVATE);
                    break;
                }
                case 4: {
                    set.add(PROTECTED);
                    break;
                }
            }
            if ((val & 8) != 0) {
                set.add(STATIC);
            }
            if ((val & 0x10) != 0) {
                set.add(ABSTRACT);
            }
            if ((val & 0x20) != 0) {
                set.add(FINAL);
            }
            if ((val & 0x40) != 0) {
                set.add(OVERRIDE);
            }
            return set;
        }
    }

    public static enum FunctionType {
        MAIN,
        CONSTRUCTOR,
        METHOD,
        FUNCTION,
        PROCEDURE,
        EXTERNAL_PROCEDURE,
        DLL_PROCEDURE,
        DESTRUCTOR;


        public static FunctionType getTypeFromString(String str) {
            switch (str.toUpperCase()) {
                case "CONST": {
                    return CONSTRUCTOR;
                }
                case "MAIN": {
                    return MAIN;
                }
                case "METH": {
                    return METHOD;
                }
                case "FUNC": {
                    return FUNCTION;
                }
                case "PROC": {
                    return PROCEDURE;
                }
                case "EXT": {
                    return EXTERNAL_PROCEDURE;
                }
                case "DLL": {
                    return DLL_PROCEDURE;
                }
                case "DEST": {
                    return DESTRUCTOR;
                }
            }
            return null;
        }
    }

    public static class Function {
        private Set<SigAccessType> accessTypes;
        private String name;
        private List<Parameter> parameters = new ArrayList<Parameter>();
        private DataType returnType;
        private String classReturnType;
        private int returnExtent;
        private FunctionType type;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (SigAccessType type : this.accessTypes) {
                sb.append((Object)type).append(' ');
            }
            sb.append((Object)this.type).append(' ').append((Object)this.returnType);
            if (this.returnType == DataType.CLASS) {
                sb.append('{').append(this.classReturnType).append('}');
            }
            if (this.returnExtent > 0) {
                sb.append(" EXTENT ").append(this.returnExtent);
            }
            sb.append(' ').append(this.name).append(" (");
            StringBuilder sb2 = new StringBuilder();
            for (Parameter p : this.parameters) {
                if (sb2.length() > 0) {
                    sb2.append(", ");
                }
                sb2.append(p.toString());
            }
            sb.append(sb2.toString()).append(')');
            return sb.toString();
        }
    }

    public static class InvalidRCodeException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public InvalidRCodeException(String s) {
            super(s);
        }

        public InvalidRCodeException(Throwable caught) {
            super(caught);
        }
    }
}

