/*
 * Decompiled with CFR 0.152.
 */
package eu.rssw.pct.elements.fixed;

import eu.rssw.pct.elements.AbstractAccessibleElement;
import eu.rssw.pct.elements.AccessType;
import eu.rssw.pct.elements.DataType;
import eu.rssw.pct.elements.IMethodElement;
import eu.rssw.pct.elements.IParameter;
import java.util.EnumSet;

public class MethodElement
extends AbstractAccessibleElement
implements IMethodElement {
    protected static final int METHOD_DESCRIPTOR_SIZE = 24;
    protected static final int FINAL_METHOD = 1;
    protected static final int PROTECTED_METHOD = 2;
    protected static final int PUBLIC_METHOD = 4;
    protected static final int PRIVATE_METHOD = 8;
    protected static final int PROCEDURE_METHOD = 16;
    protected static final int FUNCTION_METHOD = 32;
    protected static final int CONSTRUCTOR_METHOD = 64;
    protected static final int DESTRUCTOR_METHOD = 128;
    protected static final int OVERLOADED_METHOD = 256;
    protected static final int STATIC_METHOD = 512;
    private final int returnType = 0;
    private final String returnTypeName;
    private final int extent = 1;

    public MethodElement(String name, boolean isStatic) {
        super(name, isStatic ? EnumSet.of(AccessType.STATIC) : EnumSet.noneOf(AccessType.class));
        this.returnTypeName = null;
    }

    @Override
    public String getReturnTypeName() {
        return this.returnTypeName;
    }

    @Override
    public DataType getReturnType() {
        return DataType.getDataType(0);
    }

    @Override
    public IParameter[] getParameters() {
        return new IParameter[0];
    }

    @Override
    public int getExtent() {
        if (this.extent == 32769) {
            return -1;
        }
        return this.extent;
    }

    @Override
    public boolean isDestructor() {
        return false;
    }

    @Override
    public int getSizeInRCode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isProcedure() {
        return false;
    }

    @Override
    public boolean isFunction() {
        return false;
    }

    @Override
    public boolean isConstructor() {
        return false;
    }

    @Override
    public boolean isOverloaded() {
        return false;
    }
}

