/*
 * Decompiled with CFR 0.152.
 */
package eu.rssw.pct.elements.fixed;

import eu.rssw.pct.elements.IBufferElement;
import eu.rssw.pct.elements.IEventElement;
import eu.rssw.pct.elements.IMethodElement;
import eu.rssw.pct.elements.IPropertyElement;
import eu.rssw.pct.elements.ITableElement;
import eu.rssw.pct.elements.ITypeInfo;
import eu.rssw.pct.elements.IVariableElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class TypeInfo
implements ITypeInfo {
    private static final int IS_FINAL = 1;
    private static final int IS_INTERFACE = 2;
    private static final int USE_WIDGET_POOL = 4;
    private static final int IS_DOTNET = 8;
    private static final int HAS_STATICS = 64;
    private static final int IS_BUILTIN = 128;
    private static final int IS_HYBRID = 2048;
    private static final int HAS_DOTNETBASE = 4096;
    private static final int IS_ABSTRACT = 32768;
    private static final int IS_SERIALIZABLE = 65536;
    protected String typeName;
    protected String parentTypeName;
    protected String assemblyName;
    protected int flags;
    private List<String> interfaces = new ArrayList<String>();
    private Collection<IMethodElement> methods = new ArrayList<IMethodElement>();
    private Collection<IPropertyElement> properties = new ArrayList<IPropertyElement>();

    public TypeInfo(String typeName, boolean iface, boolean abstrct, String parentTypeName, String assemblyName, String ... interfaces) {
        this.typeName = typeName;
        this.parentTypeName = parentTypeName;
        this.assemblyName = assemblyName;
        this.interfaces.addAll(Arrays.asList(interfaces));
        this.flags = (iface ? 2 : 0) | (abstrct ? 32768 : 0);
    }

    public void addMethod(IMethodElement element) {
        this.methods.add(element);
    }

    public void addProperty(IPropertyElement element) {
        this.properties.add(element);
    }

    @Override
    public IBufferElement getBufferFor(String name) {
        return null;
    }

    @Override
    public boolean hasTempTable(String inName) {
        return false;
    }

    @Override
    public boolean hasMethod(String name) {
        for (IMethodElement mthd : this.methods) {
            if (!mthd.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ITableElement getTempTable(String inName) {
        return null;
    }

    @Override
    public boolean hasProperty(String name) {
        return false;
    }

    @Override
    public IPropertyElement getProperty(String name) {
        for (IPropertyElement prop : this.properties) {
            if (!prop.getName().equalsIgnoreCase(name)) continue;
            return prop;
        }
        return null;
    }

    @Override
    public boolean hasBuffer(String inName) {
        return false;
    }

    @Override
    public IBufferElement getBuffer(String inName) {
        return null;
    }

    @Override
    public Collection<IMethodElement> getMethods() {
        return this.methods;
    }

    @Override
    public Collection<IPropertyElement> getProperties() {
        return this.properties;
    }

    @Override
    public Collection<IEventElement> getEvents() {
        return Collections.emptyList();
    }

    @Override
    public Collection<IVariableElement> getVariables() {
        return Collections.emptyList();
    }

    @Override
    public Collection<ITableElement> getTables() {
        return Collections.emptyList();
    }

    @Override
    public Collection<IBufferElement> getBuffers() {
        return Collections.emptyList();
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public String getParentTypeName() {
        return this.parentTypeName;
    }

    @Override
    public String getAssemblyName() {
        return this.assemblyName;
    }

    @Override
    public List<String> getInterfaces() {
        return this.interfaces;
    }

    public String toString() {
        return String.format("Type info %s - Parent %s", this.typeName, this.parentTypeName);
    }

    @Override
    public boolean isFinal() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean isInterface() {
        return (this.flags & 2) != 0;
    }

    @Override
    public boolean hasStatics() {
        return (this.flags & 0x40) != 0;
    }

    @Override
    public boolean isBuiltIn() {
        return (this.flags & 0x80) != 0;
    }

    @Override
    public boolean isHybrid() {
        return (this.flags & 0x800) != 0;
    }

    @Override
    public boolean hasDotNetBase() {
        return (this.flags & 0x1000) != 0;
    }

    @Override
    public boolean isAbstract() {
        return (this.flags & 0x8000) != 0;
    }

    @Override
    public boolean isSerializable() {
        return (this.flags & 0x10000) != 0;
    }

    @Override
    public boolean isUseWidgetPool() {
        return (this.flags & 4) != 0;
    }

    protected boolean isDotNet() {
        return (this.flags & 8) != 0;
    }
}

