/*
 * Decompiled with CFR 0.152.
 */
package eu.rssw.pct.elements.v11;

import eu.rssw.pct.RCodeInfo;
import eu.rssw.pct.elements.AbstractAccessibleElement;
import eu.rssw.pct.elements.AccessType;
import eu.rssw.pct.elements.IBufferElement;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Set;

public class BufferElementV11
extends AbstractAccessibleElement
implements IBufferElement {
    private static final int TEMP_TABLE = 4;
    private final String tableName;
    private final String databaseName;
    private final int flags;

    public BufferElementV11(String name, Set<AccessType> accessType, String tableName, String dbName, int flags) {
        super(name, accessType);
        this.tableName = tableName;
        this.databaseName = dbName;
        this.flags = flags;
    }

    public static IBufferElement fromDebugSegment(String name, Set<AccessType> accessType, byte[] segment, int currentPos, int textAreaOffset, ByteOrder order) {
        int nameOffset = ByteBuffer.wrap(segment, currentPos, 4).order(order).getInt();
        String name2 = nameOffset == 0 ? name : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + nameOffset);
        int tableNameOffset = ByteBuffer.wrap(segment, currentPos + 4, 4).order(order).getInt();
        String tableName = tableNameOffset == 0 ? "" : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + tableNameOffset);
        int databaseNameOffset = ByteBuffer.wrap(segment, currentPos + 8, 4).order(order).getInt();
        String databaseName = databaseNameOffset == 0 ? "" : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + databaseNameOffset);
        int flags = ByteBuffer.wrap(segment, currentPos + 12, 2).order(order).getShort() & 0xFFFF;
        return new BufferElementV11(name2, accessType, tableName, databaseName, flags);
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public boolean isTempTableBuffer() {
        return (this.flags & 4) != 0;
    }

    @Override
    public int getSizeInRCode() {
        return 24;
    }

    public String toString() {
        return String.format("Buffer %s for %s.%s", this.getName(), this.databaseName, this.tableName);
    }

    public int hashCode() {
        return (this.getName() + "/" + this.databaseName + "/" + this.tableName).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IBufferElement) {
            IBufferElement obj2 = (IBufferElement)obj;
            return this.getName().equals(obj2.getName()) && this.databaseName.equals(obj2.getDatabaseName()) && this.tableName.equals(obj2.getTableName());
        }
        return false;
    }
}

