/*
 * Decompiled with CFR 0.152.
 */
package eu.rssw.pct.elements.v11;

import eu.rssw.pct.RCodeInfo;
import eu.rssw.pct.elements.AbstractElement;
import eu.rssw.pct.elements.IDataRelationElement;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class DataRelationElementV11
extends AbstractElement
implements IDataRelationElement {
    private final String parentBufferName;
    private final String childBufferName;
    private final String fieldPairs;
    private final int flags;

    public DataRelationElementV11(String name, String parentBuffer, String childBuffer, String fieldPairs, int flags) {
        super(name);
        this.parentBufferName = parentBuffer;
        this.childBufferName = childBuffer;
        this.fieldPairs = fieldPairs;
        this.flags = flags;
    }

    public static DataRelationElementV11 fromDebugSegment(byte[] segment, int currentPos, int textAreaOffset, ByteOrder order) {
        int flags = ByteBuffer.wrap(segment, currentPos + 2, 2).order(order).getShort() & 0xFFFF;
        int parentBufferNameOffset = ByteBuffer.wrap(segment, currentPos + 8, 4).order(order).getInt();
        String parentBufferName = parentBufferNameOffset == 0 ? "" : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + parentBufferNameOffset);
        int childBufferNameOffset = ByteBuffer.wrap(segment, currentPos + 12, 4).order(order).getInt();
        String childBufferName = childBufferNameOffset == 0 ? "" : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + childBufferNameOffset);
        int nameOffset = ByteBuffer.wrap(segment, currentPos + 16, 4).order(order).getInt();
        String name = nameOffset == 0 ? "" : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + nameOffset);
        int fieldPairsOffset = ByteBuffer.wrap(segment, currentPos + 20, 4).order(order).getInt();
        String fieldPairs = fieldPairsOffset == 0 ? "" : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + fieldPairsOffset);
        return new DataRelationElementV11(name, parentBufferName, childBufferName, fieldPairs, flags);
    }

    @Override
    public String getParentBufferName() {
        return this.parentBufferName;
    }

    @Override
    public String getChildBufferName() {
        return this.childBufferName;
    }

    @Override
    public String getFieldPairs() {
        return this.fieldPairs;
    }

    public int getFlags() {
        return this.flags;
    }

    @Override
    public int getSizeInRCode() {
        return 24;
    }

    public String toString() {
        return String.format("Data relation from %s to %s", this.parentBufferName, this.childBufferName);
    }

    public int hashCode() {
        return (this.parentBufferName + "/" + this.childBufferName + "/" + this.fieldPairs).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IDataRelationElement) {
            IDataRelationElement obj2 = (IDataRelationElement)obj;
            return this.parentBufferName.equals(obj2.getParentBufferName()) && this.childBufferName.equals(obj2.getChildBufferName()) && this.fieldPairs.equals(obj2.getFieldPairs());
        }
        return false;
    }
}

