/*
 * Decompiled with CFR 0.152.
 */
package eu.rssw.pct.elements.v11;

import com.google.common.base.Joiner;
import eu.rssw.pct.RCodeInfo;
import eu.rssw.pct.elements.AbstractAccessibleElement;
import eu.rssw.pct.elements.AccessType;
import eu.rssw.pct.elements.IDataSourceElement;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Set;

public class DataSourceElementV11
extends AbstractAccessibleElement
implements IDataSourceElement {
    private final String queryName;
    private final String keyComponentNames;
    private final String[] bufferNames;

    public DataSourceElementV11(String name, Set<AccessType> accessType, String queryName, String keyComponentNames, String[] bufferNames) {
        super(name, accessType);
        this.queryName = queryName;
        this.keyComponentNames = keyComponentNames;
        this.bufferNames = bufferNames;
    }

    public static IDataSourceElement fromDebugSegment(String name, Set<AccessType> accessType, byte[] segment, int currentPos, int textAreaOffset, ByteOrder order) {
        int bufferCount = ByteBuffer.wrap(segment, currentPos, 2).order(order).getShort();
        int nameOffset = ByteBuffer.wrap(segment, currentPos + 12, 4).order(order).getInt();
        String name2 = nameOffset == 0 ? name : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + nameOffset);
        int queryNameOffset = ByteBuffer.wrap(segment, currentPos + 16, 4).order(order).getInt();
        String queryName = queryNameOffset == 0 ? "" : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + queryNameOffset);
        int keyComponentNamesOffset = ByteBuffer.wrap(segment, currentPos + 20, 4).order(order).getInt();
        String keyComponentNames = keyComponentNamesOffset == 0 ? "" : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + keyComponentNamesOffset);
        String[] bufferNames = new String[bufferCount];
        for (int zz = 0; zz < bufferCount; ++zz) {
            bufferNames[zz] = RCodeInfo.readNullTerminatedString(segment, textAreaOffset + ByteBuffer.wrap(segment, currentPos + 24 + zz * 4, 4).order(order).getInt());
        }
        return new DataSourceElementV11(name2, accessType, queryName, keyComponentNames, bufferNames);
    }

    @Override
    public String getQueryName() {
        return this.queryName;
    }

    @Override
    public String getKeyComponents() {
        return this.keyComponentNames;
    }

    @Override
    public String[] getBufferNames() {
        return this.bufferNames;
    }

    @Override
    public int getSizeInRCode() {
        int size = 24 + this.bufferNames.length * 4;
        return size + 7 & 0xFFFFFFF8;
    }

    public String toString() {
        return String.format("Datasource %s for %d buffer(s)", this.queryName, this.bufferNames.length);
    }

    public int hashCode() {
        return (this.queryName + "-" + this.keyComponentNames + "-" + Joiner.on((char)'/').join((Object[])this.bufferNames)).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IDataSourceElement) {
            IDataSourceElement obj2 = (IDataSourceElement)obj;
            return this.queryName.equals(obj2.getQueryName()) && this.keyComponentNames.equals(obj2.getKeyComponents()) && Arrays.deepEquals(this.bufferNames, obj2.getBufferNames());
        }
        return false;
    }
}

