/*
 * Decompiled with CFR 0.152.
 */
package eu.rssw.pct.elements.v11;

import com.google.common.base.Joiner;
import eu.rssw.pct.RCodeInfo;
import eu.rssw.pct.elements.AbstractAccessibleElement;
import eu.rssw.pct.elements.AccessType;
import eu.rssw.pct.elements.IDataRelationElement;
import eu.rssw.pct.elements.IDatasetElement;
import eu.rssw.pct.elements.v11.DataRelationElementV11;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Set;

public class DatasetElementV11
extends AbstractAccessibleElement
implements IDatasetElement {
    private final String[] bufferNames;
    private final IDataRelationElement[] relations;

    public DatasetElementV11(String name, Set<AccessType> accessType, String[] bufferNames, IDataRelationElement[] relations) {
        super(name, accessType);
        this.bufferNames = bufferNames;
        this.relations = relations;
    }

    public static IDatasetElement fromDebugSegment(String name, Set<AccessType> accessType, byte[] segment, int currentPos, int textAreaOffset, ByteOrder order) {
        int bufferCount = ByteBuffer.wrap(segment, currentPos, 2).order(order).getShort();
        int relationshipCount = ByteBuffer.wrap(segment, currentPos + 2, 2).order(order).getShort();
        int nameOffset = ByteBuffer.wrap(segment, currentPos + 16, 4).order(order).getInt();
        String name2 = nameOffset == 0 ? name : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + nameOffset);
        String[] bufferNames = new String[bufferCount];
        for (int zz = 0; zz < bufferCount; ++zz) {
            bufferNames[zz] = RCodeInfo.readNullTerminatedString(segment, textAreaOffset + ByteBuffer.wrap(segment, currentPos + 24 + zz * 4, 4).order(order).getInt());
        }
        int currPos = currentPos + 24 + (bufferCount * 4 + 7 & 0xFFFFFFF8);
        IDataRelationElement[] relations = new DataRelationElementV11[relationshipCount];
        for (int zz = 0; zz < relationshipCount; ++zz) {
            DataRelationElementV11 param = DataRelationElementV11.fromDebugSegment(segment, currPos, textAreaOffset, order);
            currPos += param.getSizeInRCode();
            relations[zz] = param;
        }
        return new DatasetElementV11(name2, accessType, bufferNames, relations);
    }

    @Override
    public IDataRelationElement[] getDataRelations() {
        return this.relations;
    }

    @Override
    public String[] getBufferNames() {
        return this.bufferNames;
    }

    @Override
    public int getSizeInRCode() {
        int size = 24 + (this.bufferNames.length * 4 + 7 & 0xFFFFFFF8);
        for (IDataRelationElement elem : this.relations) {
            size += elem.getSizeInRCode();
        }
        return size;
    }

    public String toString() {
        return String.format("Dataset %s for %d buffer(s) and %d relations", this.getName(), this.bufferNames.length, this.relations.length);
    }

    public int hashCode() {
        String str1 = Joiner.on((char)'/').join((Object[])this.bufferNames);
        String str2 = Joiner.on((char)'/').join((Object[])this.relations);
        return (str1 + "-" + str2).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IDatasetElement) {
            IDatasetElement obj2 = (IDatasetElement)obj;
            return Arrays.deepEquals(this.bufferNames, obj2.getBufferNames()) && Arrays.deepEquals(this.relations, obj2.getDataRelations());
        }
        return false;
    }
}

