/*
 * Decompiled with CFR 0.152.
 */
package eu.rssw.pct.elements.v11;

import com.google.common.base.Joiner;
import eu.rssw.pct.RCodeInfo;
import eu.rssw.pct.elements.AbstractAccessibleElement;
import eu.rssw.pct.elements.AccessType;
import eu.rssw.pct.elements.DataType;
import eu.rssw.pct.elements.IEventElement;
import eu.rssw.pct.elements.IParameter;
import eu.rssw.pct.elements.v11.MethodParameterV11;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Set;

public class EventElementV11
extends AbstractAccessibleElement
implements IEventElement {
    private final int flags;
    private final int returnType;
    private final String returnTypeName;
    private final String delegateName;
    private final IParameter[] parameters;

    public EventElementV11(String name, Set<AccessType> accessType, int flags, int returnType, String returnTypeName, String delegateName, IParameter[] parameters) {
        super(name, accessType);
        this.flags = flags;
        this.returnType = returnType;
        this.returnTypeName = returnTypeName;
        this.delegateName = delegateName;
        this.parameters = parameters;
    }

    public static IEventElement fromDebugSegment(String name, Set<AccessType> accessType, byte[] segment, int currentPos, int textAreaOffset, ByteOrder order) {
        int flags = ByteBuffer.wrap(segment, currentPos, 2).order(order).getShort() & 0xFFFF;
        short returnType = ByteBuffer.wrap(segment, currentPos + 2, 2).order(order).getShort();
        int parameterCount = ByteBuffer.wrap(segment, currentPos + 4, 2).order(order).getShort();
        int nameOffset = ByteBuffer.wrap(segment, currentPos + 12, 4).order(order).getInt();
        String name2 = nameOffset == 0 ? name : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + nameOffset);
        int typeNameOffset = ByteBuffer.wrap(segment, currentPos + 16, 4).order(order).getInt();
        String returnTypeName = typeNameOffset == 0 ? "" : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + typeNameOffset);
        int delegateNameOffset = ByteBuffer.wrap(segment, currentPos + 20, 4).order(order).getInt();
        String delegateName = delegateNameOffset == 0 ? "" : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + delegateNameOffset);
        int currPos = currentPos + 24;
        IParameter[] parameters = new IParameter[parameterCount];
        for (int zz = 0; zz < parameterCount; ++zz) {
            IParameter param = MethodParameterV11.fromDebugSegment(segment, currPos, textAreaOffset, order);
            currPos += param.getSizeInRCode();
            parameters[zz] = param;
        }
        return new EventElementV11(name2, accessType, flags, returnType, returnTypeName, delegateName, parameters);
    }

    @Override
    public DataType getReturnType() {
        return DataType.getDataType(this.returnType);
    }

    @Override
    public String getReturnTypeName() {
        return this.returnTypeName;
    }

    @Override
    public String getDelegateName() {
        return this.delegateName;
    }

    @Override
    public IParameter[] getParameters() {
        return this.parameters;
    }

    public int getFlags() {
        return this.flags;
    }

    @Override
    public int getSizeInRCode() {
        int size = 24;
        for (IParameter p : this.parameters) {
            size += ((MethodParameterV11)p).getSizeInRCode();
        }
        return size;
    }

    public String toString() {
        return String.format("Event %s", this.getName());
    }

    public int hashCode() {
        return (this.getName() + "/" + this.delegateName + "/" + this.returnType + "/" + Joiner.on((char)'-').join((Object[])this.parameters)).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IEventElement) {
            IEventElement obj2 = (IEventElement)obj;
            return this.getName().equals(obj2.getName()) && this.delegateName.equals(obj2.getDelegateName()) && DataType.getDataType(this.returnType) == obj2.getReturnType() && Arrays.deepEquals(this.parameters, obj2.getParameters());
        }
        return false;
    }
}

