/*
 * Decompiled with CFR 0.152.
 */
package eu.rssw.pct.elements.v11;

import eu.rssw.pct.elements.AbstractElement;
import eu.rssw.pct.elements.IIndexComponentElement;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class IndexComponentElementV11
extends AbstractElement
implements IIndexComponentElement {
    private final int flags;
    private final int position;
    private final boolean ascending;

    public IndexComponentElementV11(int position, int flags, boolean ascending) {
        this.position = position;
        this.flags = flags;
        this.ascending = ascending;
    }

    protected static IIndexComponentElement fromDebugSegment(byte[] segment, int currentPos, int textAreaOffset, ByteOrder order) {
        byte ascending = segment[currentPos];
        byte flags = segment[currentPos + 1];
        short position = ByteBuffer.wrap(segment, currentPos + 2, 2).order(order).getShort();
        return new IndexComponentElementV11(position, flags, ascending == 106);
    }

    public int getFlags() {
        return this.flags;
    }

    @Override
    public int getFieldPosition() {
        return this.position;
    }

    @Override
    public boolean isAscending() {
        return this.ascending;
    }

    @Override
    public int getSizeInRCode() {
        return 8;
    }

    public String toString() {
        return String.format("Field #%d", this.position);
    }

    public int hashCode() {
        return this.position * 7 + (this.ascending ? 3 : 1);
    }

    public boolean equals(Object obj) {
        if (obj instanceof IIndexComponentElement) {
            IIndexComponentElement obj2 = (IIndexComponentElement)obj;
            return this.position == obj2.getFieldPosition() && this.ascending == obj2.isAscending();
        }
        return false;
    }
}

