/*
 * Decompiled with CFR 0.152.
 */
package eu.rssw.pct.elements.v11;

import com.google.common.base.Joiner;
import eu.rssw.pct.RCodeInfo;
import eu.rssw.pct.elements.AbstractElement;
import eu.rssw.pct.elements.IIndexComponentElement;
import eu.rssw.pct.elements.IIndexElement;
import eu.rssw.pct.elements.v11.IndexComponentElementV11;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class IndexElementV11
extends AbstractElement
implements IIndexElement {
    private static final int UNIQUE_INDEX = 2;
    private static final int WORD_INDEX = 8;
    private static final int DEFAULT_INDEX = 16;
    private final IIndexComponentElement[] indexComponents;
    private final int primary;
    private final int flags;

    public IndexElementV11(String name, int primary, int flags, IIndexComponentElement[] indexComponents) {
        super(name);
        this.primary = primary;
        this.flags = flags;
        this.indexComponents = indexComponents;
    }

    protected static IIndexElement fromDebugSegment(byte[] segment, int currentPos, int textAreaOffset, ByteOrder order) {
        byte primary = segment[currentPos];
        byte flags = segment[currentPos + 1];
        int componentCount = ByteBuffer.wrap(segment, currentPos + 2, 2).order(order).getShort();
        int nameOffset = ByteBuffer.wrap(segment, currentPos + 8, 4).order(order).getInt();
        String name = nameOffset == 0 ? "" : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + nameOffset);
        int currPos = currentPos + 16;
        IIndexComponentElement[] indexComponents = new IndexComponentElementV11[componentCount];
        for (int zz = 0; zz < componentCount; ++zz) {
            IIndexComponentElement component = IndexComponentElementV11.fromDebugSegment(segment, currPos, textAreaOffset, order);
            currPos += component.getSizeInRCode();
            indexComponents[zz] = component;
        }
        return new IndexElementV11(name, primary, flags, indexComponents);
    }

    @Override
    public IIndexComponentElement[] getIndexComponents() {
        return this.indexComponents;
    }

    @Override
    public boolean isPrimary() {
        return this.primary == 1;
    }

    @Override
    public boolean isUnique() {
        return (this.flags & 2) != 0;
    }

    @Override
    public boolean isWordIndex() {
        return (this.flags & 8) != 0;
    }

    @Override
    public boolean isDefaultIndex() {
        return (this.flags & 0x10) != 0;
    }

    @Override
    public int getSizeInRCode() {
        int size = 16;
        for (IIndexComponentElement elem : this.indexComponents) {
            size += elem.getSizeInRCode();
        }
        return size;
    }

    public String toString() {
        return String.format("Index %s %s %s - %d field(s)", this.getName(), this.isPrimary() ? "PRIMARY" : "", this.isUnique() ? "UNIQUE" : "", this.indexComponents.length);
    }

    public int hashCode() {
        return (this.getName() + "/" + this.flags + "/" + Joiner.on((char)'/').join((Object[])this.indexComponents)).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IIndexElement) {
            IIndexElement obj2 = (IIndexElement)obj;
            return this.getName().equals(obj2.getName()) && Arrays.deepEquals(this.indexComponents, obj2.getIndexComponents());
        }
        return false;
    }
}

