/*
 * Decompiled with CFR 0.152.
 */
package eu.rssw.pct.elements.v11;

import com.google.common.base.Joiner;
import eu.rssw.pct.RCodeInfo;
import eu.rssw.pct.elements.AbstractAccessibleElement;
import eu.rssw.pct.elements.AccessType;
import eu.rssw.pct.elements.DataType;
import eu.rssw.pct.elements.IMethodElement;
import eu.rssw.pct.elements.IParameter;
import eu.rssw.pct.elements.v11.MethodParameterV11;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Set;

public class MethodElementV11
extends AbstractAccessibleElement
implements IMethodElement {
    protected static final int METHOD_DESCRIPTOR_SIZE = 24;
    protected static final int FINAL_METHOD = 1;
    protected static final int PROTECTED_METHOD = 2;
    protected static final int PUBLIC_METHOD = 4;
    protected static final int PRIVATE_METHOD = 8;
    protected static final int PROCEDURE_METHOD = 16;
    protected static final int FUNCTION_METHOD = 32;
    protected static final int CONSTRUCTOR_METHOD = 64;
    protected static final int DESTRUCTOR_METHOD = 128;
    protected static final int OVERLOADED_METHOD = 256;
    protected static final int STATIC_METHOD = 512;
    private final int flags;
    private final int returnType;
    private final String returnTypeName;
    private final int extent;
    private final IParameter[] parameters;

    public MethodElementV11(String name, Set<AccessType> accessType, int flags, int returnType, String returnTypeName, int extent, IParameter[] parameters) {
        super(name, accessType);
        this.flags = flags;
        this.returnType = returnType;
        this.returnTypeName = returnTypeName;
        this.extent = extent;
        this.parameters = parameters;
    }

    public static IMethodElement fromDebugSegment(String name, Set<AccessType> accessType, byte[] segment, int currentPos, int textAreaOffset, ByteOrder order) {
        int flags = ByteBuffer.wrap(segment, currentPos, 2).order(order).getShort() & 0xFFFF;
        short returnType = ByteBuffer.wrap(segment, currentPos + 2, 2).order(order).getShort();
        int paramCount = ByteBuffer.wrap(segment, currentPos + 4, 2).order(order).getShort();
        short extent = ByteBuffer.wrap(segment, currentPos + 8, 2).order(order).getShort();
        int nameOffset = ByteBuffer.wrap(segment, currentPos + 12, 4).order(order).getInt();
        String name2 = nameOffset == 0 ? name : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + nameOffset);
        int typeNameOffset = ByteBuffer.wrap(segment, currentPos + 16, 4).order(order).getInt();
        String typeName = typeNameOffset == 0 ? "" : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + typeNameOffset);
        int currPos = currentPos + 24;
        IParameter[] parameters = new IParameter[paramCount];
        for (int zz = 0; zz < paramCount; ++zz) {
            IParameter param = MethodParameterV11.fromDebugSegment(segment, currPos, textAreaOffset, order);
            currPos += param.getSizeInRCode();
            parameters[zz] = param;
        }
        return new MethodElementV11(name2, accessType, flags, returnType, typeName, extent, parameters);
    }

    @Override
    public String getReturnTypeName() {
        return this.returnTypeName;
    }

    @Override
    public DataType getReturnType() {
        return DataType.getDataType(this.returnType);
    }

    @Override
    public IParameter[] getParameters() {
        return this.parameters;
    }

    @Override
    public boolean isStatic() {
        return (this.flags & 0x200) != 0;
    }

    @Override
    public boolean isProcedure() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isFinal() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean isFunction() {
        return (this.flags & 0x20) != 0;
    }

    @Override
    public boolean isConstructor() {
        return (this.flags & 0x40) != 0;
    }

    @Override
    public boolean isDestructor() {
        return (this.flags & 0x80) != 0;
    }

    @Override
    public boolean isOverloaded() {
        return (this.flags & 0x100) != 0;
    }

    @Override
    public int getExtent() {
        if (this.extent == 32769) {
            return -1;
        }
        return this.extent;
    }

    @Override
    public int getSizeInRCode() {
        int size = 24;
        for (IParameter p : this.parameters) {
            size += p.getSizeInRCode();
        }
        return size;
    }

    public String toString() {
        return String.format("Method %s(%d arguments) returns %s", new Object[]{this.getName(), this.parameters.length, this.getReturnType()});
    }

    public int hashCode() {
        return (this.getName() + "/" + (Object)((Object)this.getReturnType()) + "/" + this.getExtent() + "/" + Joiner.on((char)'/').join((Object[])this.parameters)).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IMethodElement) {
            IMethodElement obj2 = (IMethodElement)obj;
            return this.getName().equals(obj2.getName()) && this.getReturnType().equals((Object)obj2.getReturnType()) && this.extent == obj2.getExtent() && Arrays.deepEquals(this.parameters, obj2.getParameters());
        }
        return false;
    }
}

