/*
 * Decompiled with CFR 0.152.
 */
package eu.rssw.pct.elements.v11;

import eu.rssw.pct.RCodeInfo;
import eu.rssw.pct.elements.AbstractElement;
import eu.rssw.pct.elements.DataType;
import eu.rssw.pct.elements.IParameter;
import eu.rssw.pct.elements.ParameterMode;
import eu.rssw.pct.elements.ParameterType;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class MethodParameterV11
extends AbstractElement
implements IParameter {
    private static final int PARAMETER_APPEND = 1;
    private static final int PARAMETER_HANDLE = 2;
    private static final int PARAMETER_BIND = 4;
    public static final int PARAMETER_INPUT = 6028;
    public static final int PARAMETER_INOUT = 6110;
    public static final int PARAMETER_OUTPUT = 6049;
    public static final int PARAMETER_BUFFER = 1070;
    private final int paramNum;
    private final int extent;
    private final int flags;
    private final int parameterType;
    private final int paramMode;
    private final int dataType;
    private final String dataTypeName;

    public MethodParameterV11(int num, String name, int type, int mode, int flags, int dataType, String dataTypeName, int extent) {
        super(name);
        this.paramNum = num;
        this.parameterType = type;
        this.paramMode = mode;
        this.dataType = dataType;
        this.dataTypeName = dataTypeName;
        this.flags = flags;
        this.extent = extent;
    }

    protected static IParameter fromDebugSegment(byte[] segment, int currentPos, int textAreaOffset, ByteOrder order) {
        short parameterType = ByteBuffer.wrap(segment, currentPos, 2).order(order).getShort();
        short paramMode = ByteBuffer.wrap(segment, currentPos + 2, 2).order(order).getShort();
        short extent = ByteBuffer.wrap(segment, currentPos + 4, 2).order(order).getShort();
        short dataType = ByteBuffer.wrap(segment, currentPos + 6, 2).order(order).getShort();
        int flags = ByteBuffer.wrap(segment, currentPos + 10, 2).order(order).getShort() & 0xFFFF;
        int argumentNameOffset = ByteBuffer.wrap(segment, currentPos + 16, 4).order(order).getInt();
        int nameOffset = ByteBuffer.wrap(segment, currentPos + 20, 4).order(order).getInt();
        String dataTypeName = argumentNameOffset == 0 ? "" : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + argumentNameOffset);
        String name = nameOffset == 0 ? "" : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + nameOffset);
        return new MethodParameterV11(0, name, parameterType, paramMode, flags, dataType, dataTypeName, extent);
    }

    @Override
    public int getExtent() {
        return this.extent;
    }

    public DataType getABLDataType() {
        return DataType.getDataType(this.dataType);
    }

    @Override
    public String getDataType() {
        if (this.dataType == DataType.CLASS.getNum()) {
            return this.dataTypeName;
        }
        return this.getABLDataType().name();
    }

    public String getArgumentName() {
        return this.dataTypeName;
    }

    @Override
    public ParameterType getParameterType() {
        return ParameterType.getParameterType(this.parameterType);
    }

    @Override
    public ParameterMode getMode() {
        return ParameterMode.getParameterMode(this.paramMode);
    }

    @Override
    public boolean isClassDataType() {
        return this.dataType == DataType.CLASS.getNum();
    }

    public boolean isBind() {
        return (this.flags & 4) != 0;
    }

    public boolean isAppend() {
        return (this.flags & 1) != 0;
    }

    public boolean isHandle() {
        return (this.flags & 2) != 0;
    }

    @Override
    public int getSizeInRCode() {
        return 24;
    }

    public String toString() {
        return (Object)((Object)this.getMode()) + " " + (Object)((Object)this.getParameterType()) + " " + this.getName() + " AS " + this.getDataType();
    }

    public int hashCode() {
        return ((Object)((Object)this.getMode()) + "/" + (Object)((Object)this.getParameterType()) + "/" + this.getName() + "/" + this.getDataType()).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IParameter) {
            IParameter obj2 = (IParameter)obj;
            return this.getName().equals(obj2.getName()) && this.getMode().equals((Object)obj2.getMode()) && this.getParameterType().equals((Object)obj2.getParameterType()) && this.getDataType().equals(obj2.getDataType());
        }
        return false;
    }
}

