/*
 * Decompiled with CFR 0.152.
 */
package eu.rssw.pct.elements.v11;

import eu.rssw.pct.RCodeInfo;
import eu.rssw.pct.elements.AbstractAccessibleElement;
import eu.rssw.pct.elements.AccessType;
import eu.rssw.pct.elements.IMethodElement;
import eu.rssw.pct.elements.IPropertyElement;
import eu.rssw.pct.elements.IVariableElement;
import eu.rssw.pct.elements.v11.MethodElementV11;
import eu.rssw.pct.elements.v11.VariableElementV11;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.EnumSet;
import java.util.Set;

public class PropertyElementV11
extends AbstractAccessibleElement
implements IPropertyElement {
    public static final int PUBLIC_GETTER = 1;
    public static final int PROTECTED_GETTER = 2;
    public static final int PRIVATE_GETTER = 4;
    public static final int PUBLIC_SETTER = 8;
    public static final int PROTECTED_SETTER = 16;
    public static final int PRIVATE_SETTER = 32;
    public static final int HAS_GETTER = 256;
    public static final int HAS_SETTER = 512;
    public static final int PROPERTY_AS_VARIABLE = 1024;
    public static final int PROPERTY_IS_INDEXED = 8192;
    public static final int PROPERTY_IS_DEFAULT = 16384;
    public static final int PROPERTY_IS_ENUM = 65536;
    public static final int PACKAGE_PRIVATE_GETTER = 131072;
    public static final int PACKAGE_PROTECTED_GETTER = 262144;
    public static final int PACKAGE_PRIVATE_SETTER = 524288;
    public static final int PACKAGE_PROTECTED_SETTER = 0x100000;
    private final int flags;
    private final IVariableElement variable;
    private final IMethodElement getter;
    private final IMethodElement setter;

    public PropertyElementV11(String name, Set<AccessType> accessType, int flags, IVariableElement var, IMethodElement getter, IMethodElement setter) {
        super(name, accessType);
        this.flags = flags;
        this.variable = var;
        this.getter = getter;
        this.setter = setter;
    }

    public static IPropertyElement fromDebugSegment(String name, Set<AccessType> accessType, byte[] segment, int currentPos, int textAreaOffset, ByteOrder order) {
        int flags = ByteBuffer.wrap(segment, currentPos, 2).order(order).getShort() & 0xFFFF;
        int nameOffset = ByteBuffer.wrap(segment, currentPos + 4, 4).order(order).getInt();
        String name2 = nameOffset == 0 ? name : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + nameOffset);
        IVariableElement variable = null;
        int currPos = currentPos + 8;
        if ((flags & 0x400) != 0) {
            variable = VariableElementV11.fromDebugSegment("", accessType, segment, currPos, textAreaOffset, order);
            currPos += variable.getSizeInRCode();
        }
        IMethodElement getter = null;
        if ((flags & 0x100) != 0) {
            EnumSet<AccessType> atp = EnumSet.noneOf(AccessType.class);
            if ((flags & 1) != 0) {
                atp.add(AccessType.PUBLIC);
            }
            if ((flags & 2) != 0) {
                atp.add(AccessType.PROTECTED);
            }
            getter = MethodElementV11.fromDebugSegment("", atp, segment, currPos, textAreaOffset, order);
            currPos += getter.getSizeInRCode();
        }
        IMethodElement setter = null;
        if ((flags & 0x200) != 0) {
            EnumSet<AccessType> atp = EnumSet.noneOf(AccessType.class);
            if ((flags & 8) != 0) {
                atp.add(AccessType.PUBLIC);
            }
            if ((flags & 0x10) != 0) {
                atp.add(AccessType.PROTECTED);
            }
            setter = MethodElementV11.fromDebugSegment("", atp, segment, currPos, textAreaOffset, order);
        }
        return new PropertyElementV11(name2, accessType, flags, variable, getter, setter);
    }

    @Override
    public IVariableElement getVariable() {
        return this.variable;
    }

    @Override
    public IMethodElement getGetter() {
        return this.getter;
    }

    @Override
    public IMethodElement getSetter() {
        return this.setter;
    }

    @Override
    public int getSizeInRCode() {
        int size = 8;
        if (this.propertyAsVariable()) {
            size += this.variable.getSizeInRCode();
        }
        if (this.hasGetter()) {
            size += this.getter.getSizeInRCode();
        }
        if (this.hasSetter()) {
            size += this.setter.getSizeInRCode();
        }
        return size;
    }

    public boolean propertyAsVariable() {
        return (this.flags & 0x400) != 0;
    }

    public boolean hasGetter() {
        return (this.flags & 0x100) != 0;
    }

    public boolean hasSetter() {
        return (this.flags & 0x200) != 0;
    }

    public boolean isGetterPublic() {
        return (this.flags & 1) != 0;
    }

    public boolean isGetterProtected() {
        return (this.flags & 2) != 0;
    }

    public boolean isGetterPrivate() {
        return (this.flags & 4) != 0;
    }

    public boolean isSetterPublic() {
        return (this.flags & 8) != 0;
    }

    public boolean isSetterProtected() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isSetterPrivate() {
        return (this.flags & 0x20) != 0;
    }

    public boolean isIndexed() {
        return (this.flags & 0x2000) != 0;
    }

    public boolean isDefault() {
        return (this.flags & 0x4000) != 0;
    }

    public boolean canRead() {
        return this.isGetterPrivate() || this.isGetterProtected() || this.isGetterPublic();
    }

    public boolean canWrite() {
        return this.isSetterPrivate() || this.isSetterProtected() || this.isSetterPublic();
    }

    public String toString() {
        return String.format("Property %s AS %s", new Object[]{this.getName(), this.getVariable().getDataType()});
    }

    public int hashCode() {
        return (this.getName() + "/" + this.variable.toString()).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IPropertyElement) {
            IPropertyElement obj2 = (IPropertyElement)obj;
            return this.getName().equals(obj2.getName()) && this.variable.equals(obj2.getVariable());
        }
        return false;
    }
}

