/*
 * Decompiled with CFR 0.152.
 */
package eu.rssw.pct.elements.v11;

import com.google.common.base.Joiner;
import eu.rssw.pct.RCodeInfo;
import eu.rssw.pct.elements.AbstractAccessibleElement;
import eu.rssw.pct.elements.AccessType;
import eu.rssw.pct.elements.IQueryElement;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Set;

public class QueryElementV11
extends AbstractAccessibleElement
implements IQueryElement {
    private final String[] bufferNames;
    private final int prvte;
    private final int flags;

    public QueryElementV11(String name, Set<AccessType> accessType, String[] buffers, int flags, int prvte) {
        super(name, accessType);
        this.bufferNames = buffers;
        this.flags = flags;
        this.prvte = prvte;
    }

    public static IQueryElement fromDebugSegment(String name, Set<AccessType> accessType, byte[] segment, int currentPos, int textAreaOffset, ByteOrder order) {
        int bufferCount = ByteBuffer.wrap(segment, currentPos, 2).order(order).getShort();
        short prvte = ByteBuffer.wrap(segment, currentPos + 2, 2).order(order).getShort();
        int flags = ByteBuffer.wrap(segment, currentPos + 6, 2).order(order).getShort() & 0xFFFF;
        int nameOffset = ByteBuffer.wrap(segment, currentPos + 16, 4).order(order).getInt();
        String name2 = nameOffset == 0 ? name : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + nameOffset);
        String[] bufferNames = new String[bufferCount];
        for (int zz = 0; zz < bufferCount; ++zz) {
            bufferNames[zz] = RCodeInfo.readNullTerminatedString(segment, textAreaOffset + ByteBuffer.wrap(segment, currentPos + 24 + zz * 4, 4).order(order).getInt());
        }
        return new QueryElementV11(name2, accessType, bufferNames, flags, prvte);
    }

    @Override
    public String[] getBufferNames() {
        return this.bufferNames;
    }

    public int getPrvte() {
        return this.prvte;
    }

    public int getFlags() {
        return this.flags;
    }

    @Override
    public int getSizeInRCode() {
        return 24 + 4 * this.bufferNames.length + 7 & 0xFFFFFFF8;
    }

    public String toString() {
        return String.format("Query %s for %d buffer(s)", this.getName(), this.bufferNames.length);
    }

    public int hashCode() {
        return (this.getName() + "/" + Joiner.on((char)'-').join((Object[])this.bufferNames)).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IQueryElement) {
            IQueryElement obj2 = (IQueryElement)obj;
            return this.getName().equals(obj2.getName()) && Arrays.deepEquals(this.bufferNames, obj2.getBufferNames());
        }
        return false;
    }
}

