/*
 * Decompiled with CFR 0.152.
 */
package eu.rssw.pct.elements.v11;

import com.google.common.base.Joiner;
import eu.rssw.pct.RCodeInfo;
import eu.rssw.pct.elements.AbstractAccessibleElement;
import eu.rssw.pct.elements.AccessType;
import eu.rssw.pct.elements.IElement;
import eu.rssw.pct.elements.IIndexElement;
import eu.rssw.pct.elements.ITableElement;
import eu.rssw.pct.elements.IVariableElement;
import eu.rssw.pct.elements.v11.IndexElementV11;
import eu.rssw.pct.elements.v11.VariableElementV11;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Set;

public class TableElementV11
extends AbstractAccessibleElement
implements ITableElement {
    private final int flags;
    private final IVariableElement[] fields;
    private final IIndexElement[] indexes;
    private final String beforeTableName;

    public TableElementV11(String name, Set<AccessType> accessType, int flags, IVariableElement[] fields, IIndexElement[] indexes, String beforeTableName) {
        super(name, accessType);
        this.fields = fields;
        this.indexes = indexes;
        this.beforeTableName = beforeTableName;
        this.flags = flags;
    }

    public static ITableElement fromDebugSegment(String name, Set<AccessType> accessType, byte[] segment, int currentPos, int textAreaOffset, ByteOrder order) {
        int fieldCount = ByteBuffer.wrap(segment, currentPos, 2).order(order).getShort();
        int indexCount = ByteBuffer.wrap(segment, currentPos + 2, 2).order(order).getShort();
        int flags = ByteBuffer.wrap(segment, currentPos + 4, 2).order(order).getShort() & 0xFFFF;
        int nameOffset = ByteBuffer.wrap(segment, currentPos + 16, 4).order(order).getInt();
        String name2 = nameOffset == 0 ? name : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + nameOffset);
        int beforeNameOffset = ByteBuffer.wrap(segment, currentPos + 20, 4).order(order).getInt();
        String beforeTableName = beforeNameOffset == 0 ? "" : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + beforeNameOffset);
        IVariableElement[] fields = new VariableElementV11[fieldCount];
        int currPos = currentPos + 24;
        for (int zz = 0; zz < fieldCount; ++zz) {
            IVariableElement var = VariableElementV11.fromDebugSegment("", null, segment, currPos, textAreaOffset, order);
            currPos += var.getSizeInRCode();
            fields[zz] = var;
        }
        IIndexElement[] indexes = new IndexElementV11[indexCount];
        for (int zz = 0; zz < indexCount; ++zz) {
            IIndexElement idx = IndexElementV11.fromDebugSegment(segment, currPos, textAreaOffset, order);
            currPos += idx.getSizeInRCode();
            indexes[zz] = idx;
        }
        return new TableElementV11(name2, accessType, flags, fields, indexes, beforeTableName);
    }

    public int getFlags() {
        return this.flags;
    }

    @Override
    public IVariableElement[] getFields() {
        return this.fields;
    }

    @Override
    public IIndexElement[] getIndexes() {
        return this.indexes;
    }

    @Override
    public String getBeforeTableName() {
        return this.beforeTableName;
    }

    @Override
    public int getSizeInRCode() {
        int size = 24;
        for (IVariableElement iVariableElement : this.fields) {
            size += iVariableElement.getSizeInRCode();
        }
        for (IElement iElement : this.indexes) {
            size += iElement.getSizeInRCode();
        }
        return size;
    }

    public String toString() {
        return String.format("Table %s - BeforeTable %s", this.getName(), this.beforeTableName);
    }

    public int hashCode() {
        return (this.getName() + "/" + Joiner.on((char)'-').join((Object[])this.fields) + "/" + Joiner.on((char)'-').join((Object[])this.indexes)).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ITableElement) {
            ITableElement obj2 = (ITableElement)obj;
            return this.getName().equals(obj2.getName()) && this.beforeTableName.equals(obj2.getBeforeTableName()) && Arrays.deepEquals(this.fields, obj2.getFields()) && Arrays.deepEquals(this.indexes, obj2.getIndexes());
        }
        return false;
    }
}

