/*
 * Decompiled with CFR 0.152.
 */
package eu.rssw.pct.elements.v11;

import eu.rssw.pct.RCodeInfo;
import eu.rssw.pct.elements.AbstractAccessibleElement;
import eu.rssw.pct.elements.AccessType;
import eu.rssw.pct.elements.DataType;
import eu.rssw.pct.elements.IVariableElement;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Set;

public class VariableElementV11
extends AbstractAccessibleElement
implements IVariableElement {
    private static final int READ_ONLY = 1;
    private static final int WRITE_ONLY = 2;
    private static final int BASE_IS_DOTNET = 4;
    private static final int NO_UNDO = 8;
    private final int dataType;
    private final int extent;
    private final int flags;
    private final String typeName;

    public VariableElementV11(String name, Set<AccessType> accessType, int dataType, int extent, int flags, String typeName) {
        super(name, accessType);
        this.dataType = dataType;
        this.extent = extent;
        this.flags = flags;
        this.typeName = typeName;
    }

    public static IVariableElement fromDebugSegment(String name, Set<AccessType> accessType, byte[] segment, int currentPos, int textAreaOffset, ByteOrder order) {
        short dataType = ByteBuffer.wrap(segment, currentPos, 2).order(order).getShort();
        short extent = ByteBuffer.wrap(segment, currentPos + 4, 2).order(order).getShort();
        int flags = ByteBuffer.wrap(segment, currentPos + 6, 2).order(order).getShort() & 0xFFFF;
        int nameOffset = ByteBuffer.wrap(segment, currentPos + 12, 4).order(order).getInt();
        String name2 = nameOffset == 0 ? name : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + nameOffset);
        int typeNameOffset = ByteBuffer.wrap(segment, currentPos + 16, 4).order(order).getInt();
        String typeName = typeNameOffset == 0 ? "" : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + typeNameOffset);
        return new VariableElementV11(name2, accessType, dataType, extent, flags, typeName);
    }

    @Override
    public int getExtent() {
        return this.extent;
    }

    @Override
    public DataType getDataType() {
        return DataType.getDataType(this.dataType);
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public boolean isReadOnly() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean isWriteOnly() {
        return (this.flags & 2) != 0;
    }

    @Override
    public boolean isNoUndo() {
        return (this.flags & 8) != 0;
    }

    @Override
    public boolean baseIsDotNet() {
        return (this.flags & 4) != 0;
    }

    @Override
    public int getSizeInRCode() {
        return 24;
    }

    public String toString() {
        return String.format("Variable %s [%d] - %s", this.getName(), this.extent, this.getDataType().toString());
    }

    public int hashCode() {
        return (this.getName() + "/" + (Object)((Object)this.getDataType()) + "/" + this.getExtent()).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IVariableElement) {
            IVariableElement obj2 = (IVariableElement)obj;
            return this.getName().equals(obj2.getName()) && this.getDataType().equals((Object)obj2.getDataType()) && this.extent == obj2.getExtent();
        }
        return false;
    }
}

