/*
 * Decompiled with CFR 0.152.
 */
package eu.rssw.pct.elements.v12;

import eu.rssw.pct.RCodeInfo;
import eu.rssw.pct.elements.AccessType;
import eu.rssw.pct.elements.IBufferElement;
import eu.rssw.pct.elements.v11.BufferElementV11;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Set;

public class BufferElementV12
extends BufferElementV11 {
    public BufferElementV12(String name, Set<AccessType> accessType, String tableName, String dbName, int flags) {
        super(name, accessType, tableName, dbName, flags);
    }

    public static IBufferElement fromDebugSegment(String name, Set<AccessType> accessType, byte[] segment, int currentPos, int textAreaOffset, ByteOrder order) {
        int nameOffset = ByteBuffer.wrap(segment, currentPos, 4).order(order).getInt();
        String name2 = nameOffset == 0 ? name : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + nameOffset);
        int tableNameOffset = ByteBuffer.wrap(segment, currentPos + 4, 4).order(order).getInt();
        String tableName = tableNameOffset == 0 ? "" : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + tableNameOffset);
        int databaseNameOffset = ByteBuffer.wrap(segment, currentPos + 8, 4).order(order).getInt();
        String databaseName = databaseNameOffset == 0 ? "" : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + databaseNameOffset);
        int flags = ByteBuffer.wrap(segment, currentPos + 18, 2).order(order).getShort() & 0xFFFF;
        return new BufferElementV12(name2, accessType, tableName, databaseName, flags);
    }
}

