/*
 * Decompiled with CFR 0.152.
 */
package eu.rssw.pct.elements.v12;

import eu.rssw.pct.RCodeInfo;
import eu.rssw.pct.elements.AccessType;
import eu.rssw.pct.elements.IDataSourceElement;
import eu.rssw.pct.elements.v11.DataSourceElementV11;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Set;

public class DataSourceElementV12
extends DataSourceElementV11 {
    public DataSourceElementV12(String name, Set<AccessType> accessType, String queryName, String keyComponentNames, String[] bufferNames) {
        super(name, accessType, queryName, keyComponentNames, bufferNames);
    }

    public static IDataSourceElement fromDebugSegment(String name, Set<AccessType> accessType, byte[] segment, int currentPos, int textAreaOffset, ByteOrder order) {
        int bufferCount = ByteBuffer.wrap(segment, currentPos + 18, 2).order(order).getShort();
        int nameOffset = ByteBuffer.wrap(segment, currentPos, 4).order(order).getInt();
        String name2 = nameOffset == 0 ? name : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + nameOffset);
        int queryNameOffset = ByteBuffer.wrap(segment, currentPos + 4, 4).order(order).getInt();
        String queryName = queryNameOffset == 0 ? "" : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + queryNameOffset);
        int keyComponentNamesOffset = ByteBuffer.wrap(segment, currentPos + 8, 4).order(order).getInt();
        String keyComponentNames = keyComponentNamesOffset == 0 ? "" : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + keyComponentNamesOffset);
        String[] bufferNames = new String[bufferCount];
        for (int zz = 0; zz < bufferCount; ++zz) {
            bufferNames[zz] = RCodeInfo.readNullTerminatedString(segment, textAreaOffset + ByteBuffer.wrap(segment, currentPos + 24 + zz * 4, 4).order(order).getInt());
        }
        return new DataSourceElementV12(name2, accessType, queryName, keyComponentNames, bufferNames);
    }
}

