/*
 * Decompiled with CFR 0.152.
 */
package eu.rssw.pct.elements.v12;

import eu.rssw.pct.RCodeInfo;
import eu.rssw.pct.elements.AccessType;
import eu.rssw.pct.elements.IDataRelationElement;
import eu.rssw.pct.elements.IDatasetElement;
import eu.rssw.pct.elements.v11.DatasetElementV11;
import eu.rssw.pct.elements.v12.DataRelationElementV12;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Set;

public class DatasetElementV12
extends DatasetElementV11 {
    public DatasetElementV12(String name, Set<AccessType> accessType, String[] bufferNames, IDataRelationElement[] relations) {
        super(name, accessType, bufferNames, relations);
    }

    public static IDatasetElement fromDebugSegment(String name, Set<AccessType> accessType, byte[] segment, int currentPos, int textAreaOffset, ByteOrder order) {
        int bufferCount = ByteBuffer.wrap(segment, currentPos + 14, 2).order(order).getShort();
        int relationshipCount = ByteBuffer.wrap(segment, currentPos + 16, 2).order(order).getShort();
        int nameOffset = ByteBuffer.wrap(segment, currentPos, 4).order(order).getInt();
        String name2 = nameOffset == 0 ? name : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + nameOffset);
        String[] bufferNames = new String[bufferCount];
        for (int zz = 0; zz < bufferCount; ++zz) {
            bufferNames[zz] = RCodeInfo.readNullTerminatedString(segment, textAreaOffset + ByteBuffer.wrap(segment, currentPos + 24 + zz * 4, 4).order(order).getInt());
        }
        int currPos = currentPos + 24 + (bufferCount * 4 + 7 & 0xFFFFFFF8);
        IDataRelationElement[] relations = new DataRelationElementV12[relationshipCount];
        for (int zz = 0; zz < relationshipCount; ++zz) {
            DataRelationElementV12 param = DataRelationElementV12.fromDebugSegment(segment, currPos, textAreaOffset, order);
            currPos += param.getSizeInRCode();
            relations[zz] = param;
        }
        return new DatasetElementV12(name2, accessType, bufferNames, relations);
    }
}

