/*
 * Decompiled with CFR 0.152.
 */
package eu.rssw.pct.elements.v12;

import eu.rssw.pct.RCodeInfo;
import eu.rssw.pct.elements.AccessType;
import eu.rssw.pct.elements.IEventElement;
import eu.rssw.pct.elements.IParameter;
import eu.rssw.pct.elements.v11.EventElementV11;
import eu.rssw.pct.elements.v12.MethodParameterV12;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Set;

public class EventElementV12
extends EventElementV11 {
    public EventElementV12(String name, Set<AccessType> accessType, int flags, int returnType, String returnTypeName, String delegateName, IParameter[] parameters) {
        super(name, accessType, flags, returnType, returnTypeName, delegateName, parameters);
    }

    public static IEventElement fromDebugSegment(String name, Set<AccessType> accessType, byte[] segment, int currentPos, int textAreaOffset, ByteOrder order) {
        int flags = ByteBuffer.wrap(segment, currentPos + 18, 2).order(order).getShort() & 0xFFFF;
        short returnType = ByteBuffer.wrap(segment, currentPos + 20, 2).order(order).getShort();
        int parameterCount = ByteBuffer.wrap(segment, currentPos + 22, 2).order(order).getShort();
        int nameOffset = ByteBuffer.wrap(segment, currentPos, 4).order(order).getInt();
        String name2 = nameOffset == 0 ? name : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + nameOffset);
        int typeNameOffset = ByteBuffer.wrap(segment, currentPos + 4, 4).order(order).getInt();
        String returnTypeName = typeNameOffset == 0 ? "" : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + typeNameOffset);
        int delegateNameOffset = ByteBuffer.wrap(segment, currentPos + 8, 4).order(order).getInt();
        String delegateName = delegateNameOffset == 0 ? "" : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + delegateNameOffset);
        int currPos = currentPos + 24;
        IParameter[] parameters = new IParameter[parameterCount];
        for (int zz = 0; zz < parameterCount; ++zz) {
            IParameter param = MethodParameterV12.fromDebugSegment(segment, currPos, textAreaOffset, order);
            currPos += param.getSizeInRCode();
            parameters[zz] = param;
        }
        return new EventElementV12(name2, accessType, flags, returnType, returnTypeName, delegateName, parameters);
    }
}

