/*
 * Decompiled with CFR 0.152.
 */
package eu.rssw.pct.elements.v12;

import eu.rssw.pct.RCodeInfo;
import eu.rssw.pct.elements.IIndexComponentElement;
import eu.rssw.pct.elements.IIndexElement;
import eu.rssw.pct.elements.v11.IndexElementV11;
import eu.rssw.pct.elements.v12.IndexComponentElementV12;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class IndexElementV12
extends IndexElementV11 {
    public IndexElementV12(String name, int primary, int flags, IIndexComponentElement[] indexComponents) {
        super(name, primary, flags, indexComponents);
    }

    protected static IIndexElement fromDebugSegment(byte[] segment, int currentPos, int textAreaOffset, ByteOrder order) {
        byte primary = segment[currentPos + 14];
        byte flags = segment[currentPos + 15];
        int componentCount = ByteBuffer.wrap(segment, currentPos + 12, 2).order(order).getShort();
        int nameOffset = ByteBuffer.wrap(segment, currentPos, 4).order(order).getInt();
        String name = nameOffset == 0 ? "" : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + nameOffset);
        int currPos = currentPos + 16;
        IIndexComponentElement[] indexComponents = new IndexComponentElementV12[componentCount];
        for (int zz = 0; zz < componentCount; ++zz) {
            IIndexComponentElement component = IndexComponentElementV12.fromDebugSegment(segment, currPos, textAreaOffset, order);
            currPos += component.getSizeInRCode();
            indexComponents[zz] = component;
        }
        return new IndexElementV12(name, primary, flags, indexComponents);
    }
}

