/*
 * Decompiled with CFR 0.152.
 */
package eu.rssw.pct.elements.v12;

import eu.rssw.pct.RCodeInfo;
import eu.rssw.pct.elements.AccessType;
import eu.rssw.pct.elements.IMethodElement;
import eu.rssw.pct.elements.IParameter;
import eu.rssw.pct.elements.v11.MethodElementV11;
import eu.rssw.pct.elements.v12.MethodParameterV12;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Set;

public class MethodElementV12
extends MethodElementV11 {
    public MethodElementV12(String name, Set<AccessType> accessType, int flags, int returnType, String returnTypeName, int extent, IParameter[] parameters) {
        super(name, accessType, flags, returnType, returnTypeName, extent, parameters);
    }

    public static IMethodElement fromDebugSegment(String name, Set<AccessType> accessType, byte[] segment, int currentPos, int textAreaOffset, ByteOrder order) {
        int flags = ByteBuffer.wrap(segment, currentPos + 14, 2).order(order).getShort() & 0xFFFF;
        short returnType = ByteBuffer.wrap(segment, currentPos + 16, 2).order(order).getShort();
        int paramCount = ByteBuffer.wrap(segment, currentPos + 18, 2).order(order).getShort();
        short extent = ByteBuffer.wrap(segment, currentPos + 22, 2).order(order).getShort();
        int nameOffset = ByteBuffer.wrap(segment, currentPos, 4).order(order).getInt();
        String name2 = nameOffset == 0 ? name : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + nameOffset);
        int typeNameOffset = ByteBuffer.wrap(segment, currentPos + 4, 4).order(order).getInt();
        String typeName = typeNameOffset == 0 ? "" : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + typeNameOffset);
        int currPos = currentPos + 56;
        IParameter[] parameters = new IParameter[paramCount];
        for (int zz = 0; zz < paramCount; ++zz) {
            IParameter param = MethodParameterV12.fromDebugSegment(segment, currPos, textAreaOffset, order);
            currPos += param.getSizeInRCode();
            parameters[zz] = param;
        }
        return new MethodElementV12(name2, accessType, flags, returnType, typeName, extent, parameters);
    }

    @Override
    public int getSizeInRCode() {
        int size = 56;
        for (IParameter p : this.getParameters()) {
            size += p.getSizeInRCode();
        }
        return size;
    }
}

