/*
 * Decompiled with CFR 0.152.
 */
package eu.rssw.pct.elements.v12;

import eu.rssw.pct.RCodeInfo;
import eu.rssw.pct.elements.AccessType;
import eu.rssw.pct.elements.IEnumDescriptor;
import eu.rssw.pct.elements.IMethodElement;
import eu.rssw.pct.elements.IPropertyElement;
import eu.rssw.pct.elements.IVariableElement;
import eu.rssw.pct.elements.v11.PropertyElementV11;
import eu.rssw.pct.elements.v12.EnumDescriptorV12;
import eu.rssw.pct.elements.v12.MethodElementV12;
import eu.rssw.pct.elements.v12.VariableElementV12;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.EnumSet;
import java.util.Set;

public class PropertyElementV12
extends PropertyElementV11 {
    private final IEnumDescriptor enumDesc;

    public PropertyElementV12(String name, Set<AccessType> accessType, int flags, IVariableElement var, IMethodElement getter, IMethodElement setter, IEnumDescriptor enumDesc) {
        super(name, accessType, flags, var, getter, setter);
        this.enumDesc = enumDesc;
    }

    public static IPropertyElement fromDebugSegment(String name, Set<AccessType> accessType, byte[] segment, int currentPos, int textAreaOffset, ByteOrder order, boolean isEnum) {
        int flags = ByteBuffer.wrap(segment, currentPos + 4, 2).order(order).getShort() & 0xFFFF;
        int nameOffset = ByteBuffer.wrap(segment, currentPos, 4).order(order).getInt();
        String name2 = nameOffset == 0 ? name : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + nameOffset);
        IVariableElement variable = null;
        int currPos = currentPos + 16;
        if ((flags & 0x400) != 0) {
            variable = VariableElementV12.fromDebugSegment("", accessType, segment, currPos, textAreaOffset, order);
            currPos += variable.getSizeInRCode();
        }
        IMethodElement getter = null;
        if ((flags & 0x100) != 0) {
            EnumSet<AccessType> atp = EnumSet.noneOf(AccessType.class);
            if ((flags & 1) != 0) {
                atp.add(AccessType.PUBLIC);
            }
            if ((flags & 2) != 0) {
                atp.add(AccessType.PROTECTED);
            }
            getter = MethodElementV12.fromDebugSegment("", atp, segment, currPos, textAreaOffset, order);
            currPos += getter.getSizeInRCode();
        }
        IMethodElement setter = null;
        if ((flags & 0x200) != 0) {
            EnumSet<AccessType> atp = EnumSet.noneOf(AccessType.class);
            if ((flags & 8) != 0) {
                atp.add(AccessType.PUBLIC);
            }
            if ((flags & 0x10) != 0) {
                atp.add(AccessType.PROTECTED);
            }
            setter = MethodElementV12.fromDebugSegment("", atp, segment, currPos, textAreaOffset, order);
            currPos += setter.getSizeInRCode();
        }
        IEnumDescriptor enumDesc = null;
        if (isEnum || (flags & 0x10000) != 0) {
            enumDesc = EnumDescriptorV12.fromDebugSegment("", segment, currPos, textAreaOffset, order);
        }
        return new PropertyElementV12(name2, accessType, flags, variable, getter, setter, enumDesc);
    }

    @Override
    public int getSizeInRCode() {
        int size = 16;
        if (this.propertyAsVariable()) {
            size += this.getVariable().getSizeInRCode();
        }
        if (this.hasGetter()) {
            size += this.getGetter().getSizeInRCode();
        }
        if (this.hasSetter()) {
            size += this.getSetter().getSizeInRCode();
        }
        if (this.enumDesc != null) {
            size += this.enumDesc.getSizeInRCode();
        }
        return size;
    }
}

