/*
 * Decompiled with CFR 0.152.
 */
package eu.rssw.pct.elements.v12;

import eu.rssw.pct.RCodeInfo;
import eu.rssw.pct.elements.AccessType;
import eu.rssw.pct.elements.IIndexElement;
import eu.rssw.pct.elements.ITableElement;
import eu.rssw.pct.elements.IVariableElement;
import eu.rssw.pct.elements.v11.TableElementV11;
import eu.rssw.pct.elements.v12.IndexElementV12;
import eu.rssw.pct.elements.v12.VariableElementV12;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Set;

public class TableElementV12
extends TableElementV11 {
    public TableElementV12(String name, Set<AccessType> accessType, int flags, IVariableElement[] fields, IIndexElement[] indexes, String beforeTableName) {
        super(name, accessType, flags, fields, indexes, beforeTableName);
    }

    public static ITableElement fromDebugSegment(String name, Set<AccessType> accessType, byte[] segment, int currentPos, int textAreaOffset, ByteOrder order) {
        int fieldCount = ByteBuffer.wrap(segment, currentPos + 12, 2).order(order).getShort();
        int indexCount = ByteBuffer.wrap(segment, currentPos + 14, 2).order(order).getShort();
        int flags = ByteBuffer.wrap(segment, currentPos + 16, 2).order(order).getShort() & 0xFFFF;
        int nameOffset = ByteBuffer.wrap(segment, currentPos, 4).order(order).getInt();
        String name2 = nameOffset == 0 ? name : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + nameOffset);
        int beforeNameOffset = ByteBuffer.wrap(segment, currentPos + 4, 4).order(order).getInt();
        String beforeTableName = beforeNameOffset == 0 ? "" : RCodeInfo.readNullTerminatedString(segment, textAreaOffset + beforeNameOffset);
        IVariableElement[] fields = new VariableElementV12[fieldCount];
        int currPos = currentPos + 24;
        for (int zz = 0; zz < fieldCount; ++zz) {
            IVariableElement var = VariableElementV12.fromDebugSegment("", null, segment, currPos, textAreaOffset, order);
            currPos += var.getSizeInRCode();
            fields[zz] = var;
        }
        IIndexElement[] indexes = new IndexElementV12[indexCount];
        for (int zz = 0; zz < indexCount; ++zz) {
            IIndexElement idx = IndexElementV12.fromDebugSegment(segment, currPos, textAreaOffset, order);
            currPos += idx.getSizeInRCode();
            indexes[zz] = idx;
        }
        return new TableElementV12(name2, accessType, flags, fields, indexes, beforeTableName);
    }
}

