/*
 * Decompiled with CFR 0.152.
 */
package eu.rssw.pct.elements.v12;

import eu.rssw.pct.RCodeInfo;
import eu.rssw.pct.elements.AccessType;
import eu.rssw.pct.elements.ElementKind;
import eu.rssw.pct.elements.IBufferElement;
import eu.rssw.pct.elements.IDataSourceElement;
import eu.rssw.pct.elements.IDatasetElement;
import eu.rssw.pct.elements.IEventElement;
import eu.rssw.pct.elements.IMethodElement;
import eu.rssw.pct.elements.IPropertyElement;
import eu.rssw.pct.elements.IQueryElement;
import eu.rssw.pct.elements.ITableElement;
import eu.rssw.pct.elements.ITypeInfo;
import eu.rssw.pct.elements.IVariableElement;
import eu.rssw.pct.elements.v12.BufferElementV12;
import eu.rssw.pct.elements.v12.DataSourceElementV12;
import eu.rssw.pct.elements.v12.DatasetElementV12;
import eu.rssw.pct.elements.v12.EventElementV12;
import eu.rssw.pct.elements.v12.MethodElementV12;
import eu.rssw.pct.elements.v12.PropertyElementV12;
import eu.rssw.pct.elements.v12.QueryElementV12;
import eu.rssw.pct.elements.v12.TableElementV12;
import eu.rssw.pct.elements.v12.VariableElementV12;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class TypeInfoV12
implements ITypeInfo {
    private static final int IS_FINAL = 1;
    private static final int IS_INTERFACE = 2;
    private static final int USE_WIDGET_POOL = 4;
    private static final int IS_DOTNET = 8;
    private static final int HAS_STATICS = 64;
    private static final int IS_BUILTIN = 128;
    private static final int IS_HYBRID = 2048;
    private static final int HAS_DOTNETBASE = 4096;
    private static final int IS_ABSTRACT = 32768;
    private static final int IS_SERIALIZABLE = 65536;
    protected String typeName;
    protected String parentTypeName;
    protected String assemblyName;
    protected int flags;
    private List<String> interfaces = new ArrayList<String>();
    private Collection<IMethodElement> methods = new ArrayList<IMethodElement>();
    private Collection<IPropertyElement> properties = new ArrayList<IPropertyElement>();
    private Collection<IEventElement> events = new ArrayList<IEventElement>();
    private Collection<IVariableElement> variables = new ArrayList<IVariableElement>();
    private Collection<ITableElement> tables = new ArrayList<ITableElement>();
    private Collection<IBufferElement> buffers = new ArrayList<IBufferElement>();

    private TypeInfoV12() {
    }

    public static TypeInfoV12 newTypeInfo(byte[] segment, ByteOrder order) throws RCodeInfo.InvalidRCodeException {
        TypeInfoV12 typeInfo = new TypeInfoV12();
        short publicElementCount = ByteBuffer.wrap(segment, 2, 2).order(order).getShort();
        short protectedElementCount = ByteBuffer.wrap(segment, 4, 2).order(order).getShort();
        short privateElementCount = ByteBuffer.wrap(segment, 6, 2).order(order).getShort();
        short constructorCount = ByteBuffer.wrap(segment, 8, 2).order(order).getShort();
        int interfaceCount = ByteBuffer.wrap(segment, 10, 2).order(order).getShort();
        int textAreaOffset = ByteBuffer.wrap(segment, 24, 4).order(order).getInt();
        short packageProtectedElementCount = ByteBuffer.wrap(segment, 172, 2).order(order).getShort();
        short packagePrivateElementCount = ByteBuffer.wrap(segment, 174, 2).order(order).getShort();
        typeInfo.flags = ByteBuffer.wrap(segment, 32, 4).order(order).getInt();
        int nameOffset = ByteBuffer.wrap(segment, 12, 4).order(order).getInt();
        typeInfo.typeName = RCodeInfo.readNullTerminatedString(segment, textAreaOffset + nameOffset);
        int assemblyNameOffset = ByteBuffer.wrap(segment, 16, 4).order(order).getInt();
        typeInfo.assemblyName = RCodeInfo.readNullTerminatedString(segment, textAreaOffset + assemblyNameOffset);
        ArrayList<int[]> entries = new ArrayList<int[]>();
        for (int zz = 0; zz < publicElementCount + protectedElementCount + privateElementCount + constructorCount + packagePrivateElementCount + packageProtectedElementCount; ++zz) {
            entries.add(new int[]{ByteBuffer.wrap(segment, 202 + 16 * zz, 2).order(order).getShort(), ByteBuffer.wrap(segment, 204 + 16 * zz, 2).order(order).getShort(), ByteBuffer.wrap(segment, 206 + 16 * zz, 2).order(order).getShort(), ByteBuffer.wrap(segment, 192 + 16 * zz, 4).order(order).getInt()});
        }
        int currOffset = 192 + 16 * (publicElementCount + protectedElementCount + privateElementCount + constructorCount + packagePrivateElementCount + packageProtectedElementCount);
        typeInfo.parentTypeName = RCodeInfo.readNullTerminatedString(segment, textAreaOffset + ByteBuffer.wrap(segment, currOffset, 4).order(order).getInt());
        currOffset += 56;
        boolean isEnum = "Progress.Lang.Enum".equals(typeInfo.getParentTypeName()) || "Progress.Lang.FlagsEnum".equals(typeInfo.getParentTypeName());
        for (int zz = 0; zz < interfaceCount; ++zz) {
            String str = RCodeInfo.readNullTerminatedString(segment, textAreaOffset + ByteBuffer.wrap(segment, currOffset, 4).order(order).getInt());
            typeInfo.getInterfaces().add(str);
            currOffset += 56;
        }
        for (int[] entry : entries) {
            String name = RCodeInfo.readNullTerminatedString(segment, textAreaOffset + entry[3]);
            Set<AccessType> set = AccessType.getTypeFromString(entry[1]);
            if (isEnum && ElementKind.getKind(entry[2]) != ElementKind.PROPERTY) {
                return typeInfo;
            }
            switch (ElementKind.getKind(entry[2])) {
                case METHOD: {
                    IMethodElement mthd = MethodElementV12.fromDebugSegment(name, set, segment, currOffset, textAreaOffset, order);
                    currOffset += mthd.getSizeInRCode();
                    typeInfo.getMethods().add(mthd);
                    break;
                }
                case PROPERTY: {
                    IPropertyElement prop = PropertyElementV12.fromDebugSegment(name, set, segment, currOffset, textAreaOffset, order, isEnum);
                    currOffset += prop.getSizeInRCode();
                    typeInfo.getProperties().add(prop);
                    break;
                }
                case VARIABLE: {
                    IVariableElement var = VariableElementV12.fromDebugSegment(name, set, segment, currOffset, textAreaOffset, order);
                    currOffset += var.getSizeInRCode();
                    typeInfo.getVariables().add(var);
                    break;
                }
                case TABLE: {
                    ITableElement tbl = TableElementV12.fromDebugSegment(name, set, segment, currOffset, textAreaOffset, order);
                    currOffset += tbl.getSizeInRCode();
                    typeInfo.getTables().add(tbl);
                    break;
                }
                case BUFFER: {
                    IBufferElement buf = BufferElementV12.fromDebugSegment(name, set, segment, currOffset, textAreaOffset, order);
                    currOffset += buf.getSizeInRCode();
                    typeInfo.getBuffers().add(buf);
                    break;
                }
                case QUERY: {
                    IQueryElement qry = QueryElementV12.fromDebugSegment(name, set, segment, currOffset, textAreaOffset, order);
                    currOffset += qry.getSizeInRCode();
                    break;
                }
                case DATASET: {
                    IDatasetElement ds = DatasetElementV12.fromDebugSegment(name, set, segment, currOffset, textAreaOffset, order);
                    currOffset += ds.getSizeInRCode();
                    break;
                }
                case DATASOURCE: {
                    IDataSourceElement dso = DataSourceElementV12.fromDebugSegment(name, set, segment, currOffset, textAreaOffset, order);
                    currOffset += dso.getSizeInRCode();
                    break;
                }
                case EVENT: {
                    IEventElement evt = EventElementV12.fromDebugSegment(name, set, segment, currOffset, textAreaOffset, order);
                    currOffset += evt.getSizeInRCode();
                    typeInfo.getEvents().add(evt);
                    break;
                }
                case UNKNOWN: {
                    throw new RCodeInfo.InvalidRCodeException("Found element kind " + entry[2]);
                }
            }
        }
        return typeInfo;
    }

    @Override
    public IBufferElement getBufferFor(String name) {
        for (IBufferElement tbl : this.buffers) {
            if (!tbl.getName().equalsIgnoreCase(name)) continue;
            return tbl;
        }
        return null;
    }

    @Override
    public boolean hasTempTable(String inName) {
        for (ITableElement tbl : this.tables) {
            if (!tbl.getName().equalsIgnoreCase(inName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasMethod(String name) {
        for (IMethodElement mthd : this.methods) {
            if (!mthd.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ITableElement getTempTable(String inName) {
        for (ITableElement tbl : this.tables) {
            if (!tbl.getName().equalsIgnoreCase(inName)) continue;
            return tbl;
        }
        return null;
    }

    @Override
    public boolean hasProperty(String name) {
        for (IPropertyElement prop : this.properties) {
            if (!prop.getName().equalsIgnoreCase(name) || !prop.isPublic() && !prop.isProtected()) continue;
            return true;
        }
        return false;
    }

    @Override
    public IPropertyElement getProperty(String name) {
        for (IPropertyElement prop : this.properties) {
            if (!prop.getName().equalsIgnoreCase(name)) continue;
            return prop;
        }
        return null;
    }

    @Override
    public boolean hasBuffer(String inName) {
        for (IBufferElement buf : this.buffers) {
            if (!buf.getName().equalsIgnoreCase(inName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IBufferElement getBuffer(String inName) {
        for (IBufferElement buf : this.buffers) {
            if (!buf.getName().equalsIgnoreCase(inName)) continue;
            return buf;
        }
        return null;
    }

    @Override
    public Collection<IMethodElement> getMethods() {
        return this.methods;
    }

    @Override
    public Collection<IPropertyElement> getProperties() {
        return this.properties;
    }

    @Override
    public Collection<IEventElement> getEvents() {
        return this.events;
    }

    @Override
    public Collection<IVariableElement> getVariables() {
        return this.variables;
    }

    @Override
    public Collection<ITableElement> getTables() {
        return this.tables;
    }

    @Override
    public Collection<IBufferElement> getBuffers() {
        return this.buffers;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public String getParentTypeName() {
        return this.parentTypeName;
    }

    @Override
    public String getAssemblyName() {
        return this.assemblyName;
    }

    @Override
    public List<String> getInterfaces() {
        return this.interfaces;
    }

    public String toString() {
        return String.format("Type info %s - Parent %s", this.typeName, this.parentTypeName);
    }

    @Override
    public boolean isFinal() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean isInterface() {
        return (this.flags & 2) != 0;
    }

    @Override
    public boolean hasStatics() {
        return (this.flags & 0x40) != 0;
    }

    @Override
    public boolean isBuiltIn() {
        return (this.flags & 0x80) != 0;
    }

    @Override
    public boolean isHybrid() {
        return (this.flags & 0x800) != 0;
    }

    @Override
    public boolean hasDotNetBase() {
        return (this.flags & 0x1000) != 0;
    }

    @Override
    public boolean isAbstract() {
        return (this.flags & 0x8000) != 0;
    }

    @Override
    public boolean isSerializable() {
        return (this.flags & 0x10000) != 0;
    }

    @Override
    public boolean isUseWidgetPool() {
        return (this.flags & 4) != 0;
    }

    protected boolean isDotNet() {
        return (this.flags & 8) != 0;
    }
}

