/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.helper;

import com.atlassian.maven.plugins.jgitflow.ReleaseContext;
import com.atlassian.maven.plugins.jgitflow.VersionType;
import com.atlassian.maven.plugins.jgitflow.exception.MavenJGitFlowException;
import com.atlassian.maven.plugins.jgitflow.exception.ProjectRewriteException;
import com.atlassian.maven.plugins.jgitflow.helper.BranchHelper;
import com.atlassian.maven.plugins.jgitflow.helper.PomUpdater;
import com.atlassian.maven.plugins.jgitflow.provider.ContextProvider;
import com.atlassian.maven.plugins.jgitflow.provider.ProjectCacheKey;
import com.atlassian.maven.plugins.jgitflow.provider.VersionProvider;
import com.atlassian.maven.plugins.jgitflow.rewrite.ArtifactReleaseVersionChange;
import com.atlassian.maven.plugins.jgitflow.rewrite.ParentReleaseVersionChange;
import com.atlassian.maven.plugins.jgitflow.rewrite.ProjectChangeset;
import com.atlassian.maven.plugins.jgitflow.rewrite.ProjectReleaseVersionChange;
import com.atlassian.maven.plugins.jgitflow.rewrite.ProjectRewriter;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;

@Component(role=PomUpdater.class)
public class DefaultPomUpdater
extends AbstractLogEnabled
implements PomUpdater {
    public static final String VERSION_DELIMITER = "-";
    @Requirement
    private VersionProvider versionProvider;
    @Requirement
    private ProjectRewriter projectRewriter;
    @Requirement
    private ContextProvider contextProvider;
    @Requirement
    private BranchHelper branchHelper;

    @Override
    public void removeSnapshotFromPomVersions(ProjectCacheKey cacheKey, String versionSuffix, List<MavenProject> reactorProjects) throws MavenJGitFlowException {
        String fullBranchName = this.branchHelper.getCurrentBranchName();
        this.getLogger().info("(" + fullBranchName + ") removing snapshot from pom versions...");
        ReleaseContext ctx = this.contextProvider.getContext();
        Map<String, String> originalVersions = this.versionProvider.getOriginalVersions(cacheKey, reactorProjects);
        final String delimitedVersionSuffix = this.getDelimitedVersionSuffix(versionSuffix);
        Map finalVersions = Maps.transformValues(originalVersions, (Function)new Function<String, String>(){

            public String apply(String input) {
                if (input.endsWith(delimitedVersionSuffix + "-SNAPSHOT")) {
                    return StringUtils.substringBeforeLast((String)input, (String)(delimitedVersionSuffix + "-SNAPSHOT"));
                }
                return input;
            }
        });
        this.doUpdate(reactorProjects, originalVersions, finalVersions, ctx.isUpdateDependencies(), ctx.isConsistentProjectVersions());
    }

    @Override
    public void removeSnapshotFromPomVersionsKeepSuffix(ProjectCacheKey cacheKey, String versionSuffix, List<MavenProject> reactorProjects) throws MavenJGitFlowException {
        String fullBranchName = this.branchHelper.getCurrentBranchName();
        this.getLogger().info("(" + fullBranchName + ") removing snapshot from pom versions...");
        ReleaseContext ctx = this.contextProvider.getContext();
        Map<String, String> originalVersions = this.versionProvider.getOriginalVersions(cacheKey, reactorProjects);
        final String delimitedVersionSuffix = this.getDelimitedVersionSuffix(versionSuffix);
        Map finalVersions = Maps.transformValues(originalVersions, (Function)new Function<String, String>(){

            public String apply(String input) {
                if (input.endsWith(delimitedVersionSuffix + "-SNAPSHOT")) {
                    return StringUtils.substringBeforeLast((String)input, (String)"-SNAPSHOT");
                }
                if (input.endsWith("-SNAPSHOT")) {
                    return StringUtils.substringBeforeLast((String)input, (String)"-SNAPSHOT") + delimitedVersionSuffix;
                }
                if (!input.endsWith(delimitedVersionSuffix)) {
                    return input + delimitedVersionSuffix;
                }
                return input;
            }
        });
        this.doUpdate(reactorProjects, originalVersions, finalVersions, ctx.isUpdateDependencies(), ctx.isConsistentProjectVersions());
    }

    @Override
    public void addSnapshotToPomVersions(ProjectCacheKey cacheKey, VersionType versionType, String versionSuffix, List<MavenProject> reactorProjects) throws MavenJGitFlowException {
        String fullBranchName = this.branchHelper.getCurrentBranchName();
        this.getLogger().info("(" + fullBranchName + ") adding snapshot to pom versions...");
        ReleaseContext ctx = this.contextProvider.getContext();
        Map<String, String> originalVersions = this.versionProvider.getOriginalVersions(cacheKey, reactorProjects);
        Map<String, String> nonSnapshotVersions = this.versionProvider.getNextVersionsForType(versionType, cacheKey, reactorProjects);
        final String delimitedVersionSuffix = this.getDelimitedVersionSuffix(versionSuffix);
        Map snapshotVersions = Maps.transformValues(nonSnapshotVersions, (Function)new Function<String, String>(){

            public String apply(String input) {
                return input + delimitedVersionSuffix + "-SNAPSHOT";
            }
        });
        this.doUpdate(reactorProjects, originalVersions, snapshotVersions, ctx.isUpdateDependencies(), ctx.isConsistentProjectVersions());
    }

    @Override
    public void copyPomVersionsFromProject(List<MavenProject> projectsToCopy, List<MavenProject> projectsToUpdate) throws MavenJGitFlowException {
        String fullBranchName = this.branchHelper.getCurrentBranchName();
        this.getLogger().info("(" + fullBranchName + ") copying pom versions...");
        ReleaseContext ctx = this.contextProvider.getContext();
        Map<String, String> originalVersions = this.versionProvider.getOriginalVersions(projectsToUpdate);
        Map<String, String> versionsToCopy = this.versionProvider.getOriginalVersions(projectsToCopy);
        this.doUpdate(projectsToUpdate, originalVersions, versionsToCopy, ctx.isUpdateDependencies(), ctx.isConsistentProjectVersions());
    }

    @Override
    public void copyPomVersionsFromMap(Map<String, String> versionsToCopy, List<MavenProject> projectsToUpdate) throws MavenJGitFlowException {
        this.getLogger().info("copying pom versions...");
        ReleaseContext ctx = this.contextProvider.getContext();
        Map<String, String> originalVersions = this.versionProvider.getOriginalVersions(projectsToUpdate);
        this.doUpdate(projectsToUpdate, originalVersions, versionsToCopy, ctx.isUpdateDependencies(), ctx.isConsistentProjectVersions());
    }

    @Override
    public void updatePomsWithNextDevelopmentVersion(ProjectCacheKey cacheKey, List<MavenProject> reactorProjects) throws MavenJGitFlowException {
        String fullBranchName = this.branchHelper.getCurrentBranchName();
        this.getLogger().info("(" + fullBranchName + ") updating poms with next development version...");
        ReleaseContext ctx = this.contextProvider.getContext();
        Map<String, String> originalVersions = this.versionProvider.getOriginalVersions(cacheKey, reactorProjects);
        Map<String, String> developmentVersions = this.versionProvider.getNextDevelopmentVersions(cacheKey, reactorProjects);
        this.doUpdate(reactorProjects, originalVersions, developmentVersions, ctx.isUpdateDependencies(), ctx.isConsistentProjectVersions());
    }

    @Override
    public void addFeatureVersionToSnapshotVersions(ProjectCacheKey cacheKey, final String featureVersion, List<MavenProject> reactorProjects) throws MavenJGitFlowException {
        String fullBranchName = this.branchHelper.getCurrentBranchName();
        this.getLogger().info("(" + fullBranchName + ") adding feature versions to poms...");
        ReleaseContext ctx = this.contextProvider.getContext();
        File originalVersionsFile = ctx.getVersionChangeFilesPath() != null ? new File(ctx.getVersionChangeFilesPath(), featureVersion + ".originalVersions.properties") : null;
        File featureSuffixedVersionsFile = ctx.getVersionChangeFilesPath() != null ? new File(ctx.getVersionChangeFilesPath(), featureVersion + ".featureSuffixedVersions.properties") : null;
        Map<String, String> originalVersions = this.readMap(originalVersionsFile);
        originalVersions.putAll(this.versionProvider.getOriginalVersions(cacheKey, reactorProjects));
        Map<String, String> featureSuffixedVersions = this.readMap(featureSuffixedVersionsFile);
        featureSuffixedVersions.putAll(Maps.transformValues(originalVersions, (Function)new Function<String, String>(){

            public String apply(String input) {
                if (input.endsWith("-SNAPSHOT")) {
                    return StringUtils.substringBeforeLast((String)input, (String)"-SNAPSHOT") + DefaultPomUpdater.VERSION_DELIMITER + featureVersion + "-SNAPSHOT";
                }
                return input;
            }
        }));
        this.storeMap(originalVersions, originalVersionsFile);
        this.storeMap(featureSuffixedVersions, featureSuffixedVersionsFile);
        this.doUpdate(reactorProjects, originalVersions, featureSuffixedVersions, ctx.isUpdateDependencies(), ctx.isConsistentProjectVersions());
    }

    @Override
    public void removeFeatureVersionFromSnapshotVersions(ProjectCacheKey cacheKey, String featureVersion, List<MavenProject> reactorProjects) throws MavenJGitFlowException {
        String fullBranchName = this.branchHelper.getCurrentBranchName();
        this.getLogger().info("(" + fullBranchName + ") removing feature versions to poms...");
        ReleaseContext ctx = this.contextProvider.getContext();
        File originalVersionsFile = ctx.getVersionChangeFilesPath() != null ? new File(ctx.getVersionChangeFilesPath(), featureVersion + ".originalVersions.properties") : null;
        File featureSuffixedVersionsFile = ctx.getVersionChangeFilesPath() != null ? new File(ctx.getVersionChangeFilesPath(), featureVersion + ".featureSuffixedVersions.properties") : null;
        Map<String, String> featureSuffixedVersions = this.readMap(featureSuffixedVersionsFile);
        featureSuffixedVersions.putAll(this.versionProvider.getOriginalVersions(cacheKey, reactorProjects));
        final String featureSuffix = VERSION_DELIMITER + featureVersion + "-SNAPSHOT";
        Map<String, String> originalVersions = this.readMap(originalVersionsFile);
        originalVersions.putAll(Maps.transformValues(featureSuffixedVersions, (Function)new Function<String, String>(){

            public String apply(String input) {
                if (input.endsWith(featureSuffix)) {
                    return StringUtils.substringBeforeLast((String)input, (String)featureSuffix) + "-SNAPSHOT";
                }
                return input;
            }
        }));
        this.storeMap(originalVersions, originalVersionsFile);
        this.storeMap(featureSuffixedVersions, featureSuffixedVersionsFile);
        this.doUpdate(reactorProjects, featureSuffixedVersions, originalVersions, ctx.isUpdateDependencies(), ctx.isConsistentProjectVersions());
    }

    @Override
    public void removeSnapshotFromFeatureVersions(ProjectCacheKey cacheKey, final String featureVersion, List<MavenProject> reactorProjects) throws MavenJGitFlowException {
        ReleaseContext ctx = this.contextProvider.getContext();
        Map<String, String> originalVersions = this.versionProvider.getOriginalVersions(cacheKey, reactorProjects);
        Map featureVersions = Maps.transformValues(originalVersions, (Function)new Function<String, String>(){

            public String apply(String input) {
                if (input.endsWith("-SNAPSHOT")) {
                    return StringUtils.substringBeforeLast((String)input, (String)"-SNAPSHOT") + DefaultPomUpdater.VERSION_DELIMITER + featureVersion;
                }
                return input;
            }
        });
        this.doUpdate(reactorProjects, originalVersions, featureVersions, ctx.isUpdateDependencies(), ctx.isConsistentProjectVersions());
    }

    protected void doUpdate(List<MavenProject> reactorProjects, Map<String, String> originalVersions, Map<String, String> finalVersions, boolean updateDependencies, boolean consistentProjectVersions) throws MavenJGitFlowException {
        String fullBranchName = this.branchHelper.getCurrentBranchName();
        this.getLogger().info("(" + fullBranchName + ") updating poms for all projects...");
        if (!this.getLogger().isDebugEnabled()) {
            this.getLogger().info("turn on debug logging with -X to see exact changes");
        }
        for (MavenProject project : reactorProjects) {
            ProjectChangeset changes = new ProjectChangeset().with(ParentReleaseVersionChange.parentReleaseVersionChange(originalVersions, finalVersions, consistentProjectVersions)).with(ProjectReleaseVersionChange.projectReleaseVersionChange(finalVersions, consistentProjectVersions)).with(ArtifactReleaseVersionChange.artifactReleaseVersionChange(originalVersions, finalVersions, updateDependencies));
            try {
                this.getLogger().info("(" + fullBranchName + ") updating pom for " + project.getName() + "...");
                this.projectRewriter.applyChanges(project, changes);
                this.logChanges(changes);
            }
            catch (ProjectRewriteException e) {
                throw new MavenJGitFlowException("Error updating poms with final versions", e);
            }
        }
    }

    protected void logChanges(ProjectChangeset changes) {
        if (this.getLogger().isDebugEnabled()) {
            for (String desc : changes.getChangeDescriptionsOrSummaries()) {
                this.getLogger().debug("  " + desc);
            }
        }
    }

    private String getDelimitedVersionSuffix(String versionSuffix) {
        return StringUtils.isNotBlank((String)versionSuffix) && !versionSuffix.startsWith(VERSION_DELIMITER) ? VERSION_DELIMITER + versionSuffix : versionSuffix;
    }

    private Map<String, String> readMap(File name) throws MavenJGitFlowException {
        if (name != null) {
            try {
                Properties p = new Properties();
                p.load(new FileReader(name));
                return new HashMap<Object, Object>(p);
            }
            catch (FileNotFoundException p) {
            }
            catch (IOException e) {
                throw new MavenJGitFlowException(e);
            }
        }
        return new HashMap<String, String>();
    }

    private void storeMap(Map<String, String> map, File name) throws MavenJGitFlowException {
        if (name != null) {
            if (!name.getParentFile().exists()) {
                name.getParentFile().mkdirs();
            }
            try {
                Properties p = new Properties();
                p.putAll(map);
                FileOutputStream fos = new FileOutputStream(name, true);
                p.store(fos, "");
            }
            catch (IOException e) {
                throw new MavenJGitFlowException(e);
            }
        }
    }
}

