/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.mojo;

import com.atlassian.maven.jgitflow.api.MavenJGitFlowExtension;
import com.atlassian.maven.plugins.jgitflow.FlowInitContext;
import com.google.common.base.Strings;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;

public abstract class AbstractJGitFlowMojo
extends AbstractMojo {
    @Component
    protected MavenProject project;
    @Component
    protected MavenSession session;
    @Component
    private Settings settings;
    @Parameter(defaultValue="${basedir}", readonly=true, required=true)
    private File basedir;
    @Parameter(defaultValue="${reactorProjects}", readonly=true, required=true)
    private List<MavenProject> reactorProjects;
    @Parameter(defaultValue="${flowInitContext}")
    private FlowInitContext flowInitContext;
    @Parameter(defaultValue="false", property="enableSshAgent")
    protected boolean enableSshAgent = false;
    @Parameter(defaultValue="false", property="allowSnapshots")
    protected boolean allowSnapshots = false;
    @Parameter(defaultValue="false", property="allowUntracked")
    protected boolean allowUntracked = false;
    @Parameter(property="offline", defaultValue="${settings.offline}")
    protected boolean offline;
    @Parameter(property="localOnly", defaultValue="false")
    protected boolean localOnly = false;
    @Parameter(property="defaultOriginUrl", defaultValue="")
    protected String defaultOriginUrl = "";
    @Parameter(property="scmCommentPrefix", defaultValue="")
    protected String scmCommentPrefix = "";
    @Parameter(property="scmCommentSuffix", defaultValue="")
    protected String scmCommentSuffix = "";
    @Parameter(property="username", defaultValue="")
    protected String username = "";
    @Parameter(property="password", defaultValue="")
    protected String password = "";
    @Parameter(defaultValue="true", property="alwaysUpdateOrigin")
    protected boolean alwaysUpdateOrigin = true;
    @Parameter(defaultValue="false", property="pullMaster")
    protected boolean pullMaster = false;
    @Parameter(defaultValue="false", property="pullDevelop")
    protected boolean pullDevelop = false;
    @Parameter(defaultValue="", property="eol")
    protected String eol = "";
    @Parameter(property="versionChangeFilesPath")
    protected File versionChangeFilesPath = null;

    Settings getSettings() {
        return this.settings;
    }

    protected final File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public List<MavenProject> getReactorProjects() {
        return this.reactorProjects;
    }

    public FlowInitContext getFlowInitContext() {
        return this.flowInitContext;
    }

    public void setFlowInitContext(FlowInitContext flowInitContext) {
        this.flowInitContext = flowInitContext;
    }

    public boolean isRemoteAllowed() {
        return !this.offline && !this.localOnly;
    }

    public MavenJGitFlowExtension getExtensionInstance(String classname) throws MojoExecutionException {
        if (Strings.isNullOrEmpty((String)classname)) {
            return null;
        }
        try {
            Class<?> providerClass = Thread.currentThread().getContextClassLoader().loadClass(classname);
            Constructor<?> ctr = providerClass.getConstructor(new Class[0]);
            return (MavenJGitFlowExtension)ctr.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to load maven jgitflow extension class '" + classname + "'", e);
        }
    }

    public ClassLoader getClassloader(String classpath) {
        List<String> pathList = Arrays.asList(classpath.split(File.pathSeparator));
        ArrayList<URL> urls = new ArrayList<URL>(pathList.size());
        for (String filename : pathList) {
            try {
                urls.add(new File(filename).toURL());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), Thread.currentThread().getContextClassLoader());
    }

    protected String getClasspath() throws MojoExecutionException {
        HashSet<String> allPaths = new HashSet<String>();
        StringBuffer finalPath = new StringBuffer(File.pathSeparator + this.project.getBuild().getOutputDirectory());
        try {
            allPaths.addAll(this.project.getCompileClasspathElements());
            allPaths.addAll(this.project.getRuntimeClasspathElements());
            allPaths.addAll(this.project.getSystemClasspathElements());
            URL[] pluginUrls = ((URLClassLoader)Thread.currentThread().getContextClassLoader()).getURLs();
            for (URL pluginUrl : pluginUrls) {
                allPaths.add(new File(pluginUrl.getFile()).getPath());
            }
            for (String path : allPaths) {
                finalPath.append(File.pathSeparator);
                finalPath.append(path);
            }
            return finalPath.toString();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Dependencies must be resolved", (Exception)((Object)e));
        }
    }
}

