/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.container.payara.clientutils;

import fish.payara.arquillian.container.payara.CommonPayaraConfiguration;
import fish.payara.arquillian.container.payara.clientutils.NodeAddress;
import fish.payara.arquillian.container.payara.clientutils.PayaraClient;
import fish.payara.arquillian.container.payara.clientutils.PayaraClientException;
import fish.payara.arquillian.container.payara.clientutils.PayaraClientUtil;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.ProcessingException;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;

public class PayaraClientService
implements PayaraClient {
    private static final Logger log = Logger.getLogger(PayaraClientService.class.getName());
    private static final String WEBMODULE = "WebModule";
    private static final String SERVLET = "Servlet";
    private static final String RUNNING_STATUS = "RUNNING";
    private static final String PAYARA_VERSION = "/version";
    private static final String INSTANCE_LIST = "/list-instances";
    private static final String APPLICATION = "/applications/application";
    private static final String APPLICATION_RESOURCE = "/applications/application/{name}";
    private static final String APPLICATION_COMPONENTS = "/applications/application/{application}/list-sub-components";
    private static final String APPLICATION_SERVLETS = "/applications/application/{application}/list-sub-components?appname={application}&id={module}&type=servlets";
    private static final String CLUSTERED_SERVER_INSTANCES = "/clusters/cluster";
    private static final String MEMBER_SERVERS_RESOURCE = "/clusters/cluster/{target}/server-ref";
    private static final String CLUSTER_RESOURCE = "/clusters/cluster/{cluster}";
    private static final String STANDALONE_SERVER_INSTANCES = "/servers/server";
    private static final String SERVER_RESOURCE = "/servers/server/{server}";
    private static final String SERVER_VM_REPORT = "/servers/server/{server}/generate-jvm-report";
    private static final String SERVER_PROPERTY = "/servers/server/{server}/system-property/{system-property}";
    private static final String HTTP_LISTENER_INS = "/servers/server/{server}/system-property/{http-listener}";
    private static final String NODE_RESOURCE = "/nodes/node/{node}";
    private static final String SYSTEM_PROPERTY = "/configs/config/{config}/system-property/{system-property}";
    private static final String VIRTUAL_SERVERS = "/configs/config/{config}/http-service/list-virtual-servers?target={target}";
    private static final String VIRTUAL_SERVER = "/configs/config/{config}/http-service/virtual-server/{virtualServer}";
    private static final String LISTENER = "/configs/config/{config}/network-config/network-listeners/network-listener/{listener}";
    private static final String PROTOCOL = "/configs/config/{config}/network-config/protocols/protocol/{protocol}";
    private static final String SYSTEM_PROPERTY_REGEX = "\\$\\{(.*)\\}";
    private String target = "server";
    private String adminBaseUrl;
    private String DASUrl;
    private ServerStartegy serverInstance;
    private PayaraClientUtil clientUtil;
    private NodeAddress nodeAddress;
    private Map<String, String> deploymentAliases = new HashMap<String, String>();
    private final CommonPayaraConfiguration configuration;

    public PayaraClientService(CommonPayaraConfiguration configuration) {
        this.configuration = configuration;
        this.target = configuration.getTarget();
        StringBuilder adminUrlBuilder = new StringBuilder().append(NodeAddress.getHttpProtocolPrefix(configuration.isAdminHttps())).append(configuration.getAdminHost()).append(":").append(configuration.getAdminPort());
        this.DASUrl = adminUrlBuilder.toString();
        this.adminBaseUrl = adminUrlBuilder.append("/management/domain").toString();
        this.clientUtil = new PayaraClientUtil(configuration, this.adminBaseUrl);
    }

    @Override
    public void startUp() throws PayaraClientException {
        Map<String, String> systemProperties;
        String gfHome;
        Map<Object, Object> standaloneServers = new HashMap();
        Map<Object, Object> clusters = new HashMap();
        try {
            standaloneServers = this.getServersList();
        }
        catch (ProcessingException ch) {
            String message = "";
            if (ch.getCause() != null && ch.getCause().getMessage() != null) {
                message = " | " + ch.getCause().getMessage();
            }
            throw new PayaraClientException("Could not connect to DAS on: " + this.getDASUrl() + message);
        }
        if ("server".equals(this.getTarget())) {
            this.serverInstance = new AdminServer();
        } else if (standaloneServers.containsKey(this.getTarget())) {
            this.serverInstance = new StandaloneServer();
        } else {
            clusters = this.getClustersList();
            if (clusters != null && clusters.containsKey(this.getTarget())) {
                this.serverInstance = new ClusterServer();
            } else {
                throw new PayaraClientException("The target property: " + this.getTarget() + " is not a valid target");
            }
        }
        List<NodeAddress> nodeAddressList = this.serverInstance.getNodeAddressList();
        this.nodeAddress = "server".equals(this.target) ? nodeAddressList.get(0) : this.runningInstanceFilter(nodeAddressList);
        if (System.getProperty("glassfishRemote_gfHome") == null && (gfHome = (systemProperties = this.getServerSystemProperties(this.target)).get("com.sun.aas.productRoot")) != null) {
            System.setProperty("glassfishRemote_gfHome", gfHome);
        }
    }

    public Integer getPayaraVersion() {
        String version;
        StringTokenizer tokenizer;
        Object versionNumberObj;
        Map<String, Object> extraProperties = this.clientUtil.getExtraProperties(this.clientUtil.GETRequest(PAYARA_VERSION));
        if (extraProperties != null && (versionNumberObj = extraProperties.get("version-number")) instanceof String && (tokenizer = new StringTokenizer(version = (String)versionNumberObj, ".")).hasMoreElements()) {
            try {
                return Integer.valueOf(tokenizer.nextToken());
            }
            catch (NumberFormatException ignore) {
                log.info("Exception getting major version for: " + version);
            }
        }
        return null;
    }

    private NodeAddress runningInstanceFilter(List<NodeAddress> nodeAddressList) {
        String instanceStatus = null;
        for (Map<String, Object> instance : this.getClientUtil().getInstancesList(INSTANCE_LIST)) {
            for (NodeAddress node : nodeAddressList) {
                if (!instance.get("name").equals(node.getServerName()) || !RUNNING_STATUS.equals(instanceStatus = (String)instance.get("status"))) continue;
                return node;
            }
        }
        if (nodeAddressList.size() == 1) {
            throw new PayaraClientException("The " + nodeAddressList.get(0).getServerName() + " server-instance status is: " + instanceStatus);
        }
        throw new PayaraClientException("Could not find any instance with RUNNING status in cluster: " + this.getTarget());
    }

    @Override
    public HTTPContext doDeploy(String name, FormDataMultiPart form) {
        Map<String, Object> deploymentResult = this.getClientUtil().POSTMultiPartRequest(APPLICATION, form);
        String deployedName = deploymentResult.containsKey("properties") ? (String)((Map)deploymentResult.get("properties")).get("name") : null;
        name = this.registerDeployedName(name, deployedName);
        Map<String, Object> subComponentsResponse = this.getClientUtil().GETRequest(APPLICATION_COMPONENTS.replace("{application}", name));
        Map subComponents = (Map)subComponentsResponse.get("properties");
        HTTPContext httpContext = new HTTPContext(this.nodeAddress.getHost(), this.nodeAddress.getHttpPort());
        String contextRoot = this.getApplicationContextRoot(name);
        if (subComponents != null) {
            for (Map.Entry subComponent : subComponents.entrySet()) {
                String componentName = ((String)subComponent.getKey()).toString();
                if (WEBMODULE.equals(subComponent.getValue())) {
                    List children = (List)subComponentsResponse.get("children");
                    contextRoot = this.resolveWebModuleContextRoot(componentName, children);
                    this.resolveWebModuleSubComponents(name, componentName, contextRoot, httpContext);
                    continue;
                }
                if (!SERVLET.equals(subComponent.getValue())) continue;
                httpContext.add(new Servlet(componentName, contextRoot));
            }
        }
        return httpContext;
    }

    private String registerDeployedName(String name, String deployedName) {
        if (deployedName != null && !deployedName.equals(name)) {
            log.info("Deployment " + name + " resulted in application with different name " + deployedName);
            this.deploymentAliases.put(name, deployedName);
            return deployedName;
        }
        return name;
    }

    private String unregisterDeployedName(String name) {
        String alias = this.deploymentAliases.remove(name);
        return alias != null ? alias : name;
    }

    private String getDeployedName(String name) {
        String alias = this.deploymentAliases.get(name);
        return alias != null ? alias : name;
    }

    @Override
    public Map<String, Object> doUndeploy(String name, FormDataMultiPart form) {
        name = this.unregisterDeployedName(name);
        return this.getClientUtil().POSTMultiPartRequest(APPLICATION_RESOURCE.replace("{name}", name), form);
    }

    @Override
    public boolean isDASRunning() {
        block2: {
            try {
                this.getClientUtil().GETRequest("");
            }
            catch (ProcessingException clientEx) {
                if (clientEx.getCause() == null || !clientEx.getCause().getClass().equals(ConnectException.class)) break block2;
                return false;
            }
        }
        return true;
    }

    private Map<String, String> getServersList() {
        return this.getClientUtil().getChildResources(STANDALONE_SERVER_INSTANCES);
    }

    private Map<String, String> getClustersList() {
        return this.getClientUtil().getChildResources(CLUSTERED_SERVER_INSTANCES);
    }

    private String getApplicationContextRoot(String name) {
        return this.getClientUtil().getAttributes(APPLICATION_RESOURCE.replace("{name}", this.getDeployedName(name))).get("contextRoot");
    }

    private String resolveWebModuleContextRoot(String componentName, List<Map<String, Object>> modules) {
        for (Map<String, Object> module : modules) {
            Map moduleProperties = (Map)module.get("properties");
            if (moduleProperties != null && !moduleProperties.isEmpty()) {
                String moduleInfo = (String)moduleProperties.get("moduleInfo");
                if (!moduleInfo.startsWith(componentName)) continue;
                String contextRoot = moduleInfo.split(":")[2];
                return contextRoot.indexOf("/") > -1 ? contextRoot.substring(contextRoot.indexOf("/")) : contextRoot;
            }
            throw new PayaraClientException("Could not resolve the web-module contextRoot");
        }
        return null;
    }

    private void resolveWebModuleSubComponents(String name, String module, String context, HTTPContext httpContext) {
        Set<Map.Entry<String, String>> subComponents = this.getProperties(this.clientUtil.GETRequest(APPLICATION_SERVLETS.replace("{application}", this.getDeployedName(name)).replace("{module}", module))).entrySet();
        for (Map.Entry<String, String> subComponent : subComponents) {
            httpContext.add(new Servlet(subComponent.getKey(), context));
        }
    }

    private Map<String, String> getProperties(Map<String, Object> responseMap) {
        return (Map)responseMap.get("properties");
    }

    protected Map<String, String> getServerInstances(String target) {
        return this.clientUtil.getChildResources(MEMBER_SERVERS_RESOURCE.replace("{target}", target));
    }

    protected Map<String, String> getServerAttributes(String server) {
        return this.clientUtil.getAttributes(SERVER_RESOURCE.replace("{server}", server));
    }

    protected Map<String, String> getServerSystemProperties(String server) {
        return this.clientUtil.getServerSystemProperties(SERVER_VM_REPORT.replace("{server}", server));
    }

    protected Map<String, String> getClusterAttributes(String cluster) {
        return this.clientUtil.getAttributes(CLUSTER_RESOURCE.replace("{cluster}", cluster));
    }

    protected String getHostAddress(Map<String, String> serverAttributes) {
        String nodeHost = this.clientUtil.getAttributes(NODE_RESOURCE.replace("{node}", serverAttributes.get("nodeRef"))).get("nodeHost");
        if (nodeHost.equals("localhost")) {
            nodeHost = this.configuration.getAdminHost();
        }
        return nodeHost;
    }

    private int getSystemProperty(Map<String, String> attributes, String propertyName) {
        return Integer.parseInt(this.clientUtil.getAttributes(SYSTEM_PROPERTY.replace("{config}", attributes.get("configRef")).replace("{system-property}", propertyName)).get("value"));
    }

    private int getServerSystemProperty(String server, String propertyName, int defaultValue) {
        String value = this.clientUtil.getAttributes(SERVER_PROPERTY.replace("{server}", server).replace("{system-property}", propertyName)).get("value");
        return value != null ? Integer.parseInt(value) : defaultValue;
    }

    protected int getServerInstanceHttpPort(String server, int defaultPort, boolean secure) {
        String httpListener = !secure ? "HTTP_LISTENER_PORT" : "HTTP_SSL_LISTENER_PORT";
        String value = this.getClientUtil().getAttributes(HTTP_LISTENER_INS.replace("{server}", server).replace("{http-listener}", httpListener)).get("value");
        return value != null ? Integer.parseInt(value) : defaultPort;
    }

    private List<String> getVirtualServers(Map<String, String> attributes) {
        List virtualServers = (List)this.clientUtil.GETRequest(VIRTUAL_SERVERS.replace("{config}", attributes.get("configRef")).replace("{target}", attributes.get("name"))).get("children");
        ArrayList<String> virtualServerNames = new ArrayList<String>();
        for (Map virtualServer : virtualServers) {
            String virtualServerName = (String)virtualServer.get("message");
            if (virtualServerName.equals("__asadmin")) continue;
            virtualServerNames.add(virtualServerName);
        }
        return virtualServerNames;
    }

    private List<String> getNetworkListeners(Map<String, String> attributes, List<String> virtualServers) {
        ArrayList<String> networkListeners = new ArrayList<String>();
        for (String virtualServer : virtualServers) {
            String[] listeners;
            for (String listener : listeners = this.clientUtil.getAttributes(VIRTUAL_SERVER.replace("{config}", attributes.get("configRef")).replace("{virtualServer}", virtualServer)).get("networkListeners").split(",")) {
                networkListeners.add(listener.trim());
            }
        }
        return networkListeners;
    }

    private String getActiveHttpPort(Map<String, String> attributes, List<String> networkListeners, boolean secure) {
        for (String networkListener : networkListeners) {
            Map<String, String> listenerAttributes = this.clientUtil.getAttributes(LISTENER.replace("{config}", attributes.get("configRef")).replace("{listener}", networkListener));
            if (!Boolean.parseBoolean(listenerAttributes.get("enabled"))) continue;
            String port = listenerAttributes.get("port");
            String protocolName = listenerAttributes.get("protocol");
            boolean secureProtocol = this.isSecureProtocol(attributes, protocolName);
            if (secure && secureProtocol) {
                return port;
            }
            if (secure || secureProtocol) continue;
            return port;
        }
        return null;
    }

    private boolean isSecureProtocol(Map<String, String> attributes, String protocolName) {
        return Boolean.parseBoolean(this.clientUtil.getAttributes(PROTOCOL.replace("{config}", attributes.get("configRef")).replace("{protocol}", protocolName)).get("securityEnabled"));
    }

    private int getPortValue(Map<String, String> attributes, String serverName, String portNum) {
        try {
            return Integer.parseInt(portNum);
        }
        catch (NumberFormatException formatEx) {
            Matcher matcher = Pattern.compile(SYSTEM_PROPERTY_REGEX).matcher(portNum);
            if (matcher.find()) {
                String propertyName = matcher.group(1);
                return this.getServerSystemProperty(serverName, propertyName, this.getSystemProperty(attributes, propertyName));
            }
            return -1;
        }
    }

    private CommonPayaraConfiguration getConfiguration() {
        return this.configuration;
    }

    private String getTarget() {
        return this.target;
    }

    private PayaraClientUtil getClientUtil() {
        return this.clientUtil;
    }

    private String getDASUrl() {
        return this.DASUrl;
    }

    class ClusterServer
    extends ServerStartegy {
        @Override
        public List<NodeAddress> getNodeAddressList() {
            String nodeHost = "localhost";
            this.setNodes(new ArrayList<NodeAddress>());
            Map<String, String> clusterAttributes = PayaraClientService.this.getClusterAttributes(PayaraClientService.this.getTarget());
            Map<String, String> serverInstances = PayaraClientService.this.getServerInstances(PayaraClientService.this.getTarget());
            List virtualServers = PayaraClientService.this.getVirtualServers(clusterAttributes);
            List networkListeners = PayaraClientService.this.getNetworkListeners(clusterAttributes, virtualServers);
            String httpPortNum = PayaraClientService.this.getActiveHttpPort(clusterAttributes, networkListeners, false);
            String httpsPortNum = PayaraClientService.this.getActiveHttpPort(clusterAttributes, networkListeners, true);
            for (Map.Entry<String, String> serverInstance : serverInstances.entrySet()) {
                String serverName = serverInstance.getKey();
                Map<String, String> serverAttributes = PayaraClientService.this.getServerAttributes(serverName);
                nodeHost = PayaraClientService.this.getHostAddress(serverAttributes);
                int httpPort = PayaraClientService.this.getPortValue(clusterAttributes, serverName, httpPortNum);
                int httpsPort = -1;
                if (httpsPortNum != null && !httpsPortNum.equals("")) {
                    httpsPort = PayaraClientService.this.getPortValue(clusterAttributes, serverName, httpsPortNum);
                }
                this.addNode(new NodeAddress(serverName, nodeHost, httpPort, httpsPort));
            }
            return this.getNodes();
        }
    }

    class StandaloneServer
    extends ServerStartegy {
        @Override
        public List<NodeAddress> getNodeAddressList() {
            String nodeHost = "localhost";
            this.setNodes(new ArrayList<NodeAddress>());
            Map<String, String> serverAttributes = PayaraClientService.this.getServerAttributes(PayaraClientService.this.getTarget());
            nodeHost = PayaraClientService.this.getHostAddress(serverAttributes);
            List virtualServers = PayaraClientService.this.getVirtualServers(serverAttributes);
            List networkListeners = PayaraClientService.this.getNetworkListeners(serverAttributes, virtualServers);
            String httpPortNum = PayaraClientService.this.getActiveHttpPort(serverAttributes, networkListeners, false);
            String httpsPortNum = PayaraClientService.this.getActiveHttpPort(serverAttributes, networkListeners, true);
            int httpPort = PayaraClientService.this.getPortValue(serverAttributes, PayaraClientService.this.getTarget(), httpPortNum);
            int httpsPort = -1;
            if (httpsPortNum != null && !httpsPortNum.equals("")) {
                httpsPort = PayaraClientService.this.getPortValue(serverAttributes, PayaraClientService.this.getTarget(), httpsPortNum);
            }
            this.addNode(new NodeAddress(PayaraClientService.this.getTarget(), nodeHost, httpPort, httpsPort));
            return this.getNodes();
        }
    }

    class AdminServer
    extends ServerStartegy {
        @Override
        public List<NodeAddress> getNodeAddressList() {
            String nodeHost = "localhost";
            this.setNodes(new ArrayList<NodeAddress>());
            int count = 10;
            Map<String, String> serverAttributes = PayaraClientService.this.getServerAttributes("server");
            while (serverAttributes.size() == 0 && count-- > 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                serverAttributes = PayaraClientService.this.getServerAttributes("server");
            }
            nodeHost = PayaraClientService.this.getConfiguration().getAdminHost();
            List virtualServers = PayaraClientService.this.getVirtualServers(serverAttributes);
            List networkListeners = PayaraClientService.this.getNetworkListeners(serverAttributes, virtualServers);
            String httpPortNum = PayaraClientService.this.getActiveHttpPort(serverAttributes, networkListeners, false);
            String httpsPortNum = PayaraClientService.this.getActiveHttpPort(serverAttributes, networkListeners, true);
            int httpPort = PayaraClientService.this.getPortValue(serverAttributes, PayaraClientService.this.getTarget(), httpPortNum);
            int httpsPort = -1;
            if (httpsPortNum != null && !httpsPortNum.equals("")) {
                httpsPort = PayaraClientService.this.getPortValue(serverAttributes, PayaraClientService.this.getTarget(), httpsPortNum);
            }
            this.addNode(new NodeAddress("server", nodeHost, httpPort, httpsPort));
            return this.getNodes();
        }
    }

    abstract class ServerStartegy {
        private List<NodeAddress> nodes = new ArrayList<NodeAddress>();
        protected PayaraClientService glassFishClient;

        protected ServerStartegy() {
        }

        protected List<NodeAddress> getNodes() {
            return this.nodes;
        }

        protected void setNodes(List<NodeAddress> nodes) {
            this.nodes = nodes;
        }

        protected void addNode(NodeAddress node) {
            this.nodes.add(node);
        }

        protected PayaraClientService getGlassFishClient() {
            return this.glassFishClient;
        }

        protected abstract List<NodeAddress> getNodeAddressList();
    }
}

