package fr.enedis.chutney.agent.domain.explore;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AgentId}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAgentId.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableAgentId.of()}.
 */
@Generated(from = "AgentId", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableAgentId implements AgentId {
  private final String name;

  private ImmutableAgentId(String name) {
    this.name = Objects.requireNonNull(name, "name");
  }

  private ImmutableAgentId(ImmutableAgentId original, String name) {
    this.name = name;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AgentId#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableAgentId withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableAgentId(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAgentId} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAgentId
        && equalsByValue((ImmutableAgentId) another);
  }

  private boolean equalsByValue(ImmutableAgentId another) {
    return name.equals(another.name);
  }

  /**
   * Computes a hash code from attributes: {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AgentId} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("AgentId")
        .omitNullValues()
        .add("name", name)
        .toString();
  }

  /**
   * Construct a new immutable {@code AgentId} instance.
   * @param name The value for the {@code name} attribute
   * @return An immutable AgentId instance
   */
  public static ImmutableAgentId of(String name) {
    return new ImmutableAgentId(name);
  }

  /**
   * Creates an immutable copy of a {@link AgentId} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AgentId instance
   */
  public static ImmutableAgentId copyOf(AgentId instance) {
    if (instance instanceof ImmutableAgentId) {
      return (ImmutableAgentId) instance;
    }
    return ImmutableAgentId.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAgentId ImmutableAgentId}.
   * <pre>
   * ImmutableAgentId.builder()
   *    .name(String) // required {@link AgentId#name() name}
   *    .build();
   * </pre>
   * @return A new ImmutableAgentId builder
   */
  public static ImmutableAgentId.Builder builder() {
    return new ImmutableAgentId.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAgentId ImmutableAgentId}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AgentId", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AgentId} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(AgentId instance) {
      Objects.requireNonNull(instance, "instance");
      this.name(instance.name());
      return this;
    }

    /**
     * Initializes the value for the {@link AgentId#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Builds a new {@link ImmutableAgentId ImmutableAgentId}.
     * @return An immutable instance of AgentId
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAgentId build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableAgentId(null, name);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build AgentId, some of required attributes are not set " + attributes;
    }
  }
}
