package fr.enedis.chutney.jira.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link JiraTestExecutionDto}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableJiraTestExecutionDto.builder()}.
 */
@Generated(from = "JiraTestExecutionDto", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableJiraTestExecutionDto implements JiraTestExecutionDto {
  private final String id;
  private final List<JiraDto> jiraScenarios;

  private ImmutableJiraTestExecutionDto(String id, List<JiraDto> jiraScenarios) {
    this.id = id;
    this.jiraScenarios = jiraScenarios;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty(value = "id", required = true)
  @Override
  public String id() {
    return id;
  }

  /**
   * @return The value of the {@code jiraScenarios} attribute
   */
  @JsonProperty(value = "jiraScenarios")
  @Override
  public List<JiraDto> jiraScenarios() {
    return jiraScenarios;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JiraTestExecutionDto#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableJiraTestExecutionDto withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableJiraTestExecutionDto(newValue, this.jiraScenarios);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JiraTestExecutionDto#jiraScenarios() jiraScenarios}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJiraTestExecutionDto withJiraScenarios(JiraDto... elements) {
    List<JiraDto> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableJiraTestExecutionDto(this.id, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JiraTestExecutionDto#jiraScenarios() jiraScenarios}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of jiraScenarios elements to set
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableJiraTestExecutionDto withJiraScenarios(Iterable<? extends JiraDto> elements) {
    if (this.jiraScenarios == elements) return this;
    List<JiraDto> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableJiraTestExecutionDto(this.id, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJiraTestExecutionDto} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJiraTestExecutionDto
        && equalsByValue((ImmutableJiraTestExecutionDto) another);
  }

  private boolean equalsByValue(ImmutableJiraTestExecutionDto another) {
    return id.equals(another.id)
        && jiraScenarios.equals(another.jiraScenarios);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code jiraScenarios}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + jiraScenarios.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code JiraTestExecutionDto} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "JiraTestExecutionDto{"
        + "id=" + id
        + ", jiraScenarios=" + jiraScenarios
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "JiraTestExecutionDto", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  static final class Json implements JiraTestExecutionDto {
    @JsonIgnore @Nullable String _id;
    @JsonIgnore @Nullable List<JiraDto> _jiraScenarios = Collections.emptyList();

    @JsonProperty(value = "id", required = true)
    public void setId(String id) {
      this._id = id;
    }

    @JsonProperty(value = "jiraScenarios")
    public void setJiraScenarios(List<JiraDto> jiraScenarios) {
      this._jiraScenarios = jiraScenarios;
    }

    @Override
    public String id() { throw new UnsupportedOperationException(); }

    @Override
    public List<JiraDto> jiraScenarios() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableJiraTestExecutionDto fromJson(Json json) {
    ImmutableJiraTestExecutionDto.Builder builder = ImmutableJiraTestExecutionDto.builder();
    if (json._id != null) {
      builder.id(json._id);
    }
    if (json._jiraScenarios != null) {
      builder.addAllJiraScenarios(json._jiraScenarios);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link JiraTestExecutionDto} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable JiraTestExecutionDto instance
   */
  public static ImmutableJiraTestExecutionDto copyOf(JiraTestExecutionDto instance) {
    if (instance instanceof ImmutableJiraTestExecutionDto) {
      return (ImmutableJiraTestExecutionDto) instance;
    }
    return ImmutableJiraTestExecutionDto.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableJiraTestExecutionDto ImmutableJiraTestExecutionDto}.
   * <pre>
   * ImmutableJiraTestExecutionDto.builder()
   *    .id(String) // required {@link JiraTestExecutionDto#id() id}
   *    .addJiraScenarios|addAllJiraScenarios(fr.enedis.chutney.jira.api.JiraDto) // {@link JiraTestExecutionDto#jiraScenarios() jiraScenarios} elements
   *    .build();
   * </pre>
   * @return A new ImmutableJiraTestExecutionDto builder
   */
  public static ImmutableJiraTestExecutionDto.Builder builder() {
    return new ImmutableJiraTestExecutionDto.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableJiraTestExecutionDto ImmutableJiraTestExecutionDto}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "JiraTestExecutionDto", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String id;
    private List<JiraDto> jiraScenarios = new ArrayList<JiraDto>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code JiraTestExecutionDto} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(JiraTestExecutionDto instance) {
      Objects.requireNonNull(instance, "instance");
      this.id(instance.id());
      addAllJiraScenarios(instance.jiraScenarios());
      return this;
    }

    /**
     * Initializes the value for the {@link JiraTestExecutionDto#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "id", required = true)
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Adds one element to {@link JiraTestExecutionDto#jiraScenarios() jiraScenarios} list.
     * @param element A jiraScenarios element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addJiraScenarios(JiraDto element) {
      this.jiraScenarios.add(Objects.requireNonNull(element, "jiraScenarios element"));
      return this;
    }

    /**
     * Adds elements to {@link JiraTestExecutionDto#jiraScenarios() jiraScenarios} list.
     * @param elements An array of jiraScenarios elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addJiraScenarios(JiraDto... elements) {
      for (JiraDto element : elements) {
        this.jiraScenarios.add(Objects.requireNonNull(element, "jiraScenarios element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link JiraTestExecutionDto#jiraScenarios() jiraScenarios} list.
     * @param elements An iterable of jiraScenarios elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "jiraScenarios")
    public final Builder jiraScenarios(Iterable<? extends JiraDto> elements) {
      this.jiraScenarios.clear();
      return addAllJiraScenarios(elements);
    }

    /**
     * Adds elements to {@link JiraTestExecutionDto#jiraScenarios() jiraScenarios} list.
     * @param elements An iterable of jiraScenarios elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllJiraScenarios(Iterable<? extends JiraDto> elements) {
      for (JiraDto element : elements) {
        this.jiraScenarios.add(Objects.requireNonNull(element, "jiraScenarios element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableJiraTestExecutionDto ImmutableJiraTestExecutionDto}.
     * @return An immutable instance of JiraTestExecutionDto
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJiraTestExecutionDto build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableJiraTestExecutionDto(id, createUnmodifiableList(true, jiraScenarios));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build JiraTestExecutionDto, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
