
package fr.enedis.chutney.agent.domain.explore;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import fr.enedis.chutney.agent.domain.TargetId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ExploreResult}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableExploreResult.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableExploreResult.of()}.
 */
@Generated(from = "ExploreResult", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableExploreResult implements ExploreResult {
  private final ExploreResult.Links<AgentId, AgentId> agentLinks;
  private final ExploreResult.Links<AgentId, TargetId> targetLinks;

  private ImmutableExploreResult(
      ExploreResult.Links<AgentId, AgentId> agentLinks,
      ExploreResult.Links<AgentId, TargetId> targetLinks) {
    this.agentLinks = Objects.requireNonNull(agentLinks, "agentLinks");
    this.targetLinks = Objects.requireNonNull(targetLinks, "targetLinks");
  }

  private ImmutableExploreResult(
      ImmutableExploreResult original,
      ExploreResult.Links<AgentId, AgentId> agentLinks,
      ExploreResult.Links<AgentId, TargetId> targetLinks) {
    this.agentLinks = agentLinks;
    this.targetLinks = targetLinks;
  }

  /**
   * @return The value of the {@code agentLinks} attribute
   */
  @Override
  public ExploreResult.Links<AgentId, AgentId> agentLinks() {
    return agentLinks;
  }

  /**
   * @return The value of the {@code targetLinks} attribute
   */
  @Override
  public ExploreResult.Links<AgentId, TargetId> targetLinks() {
    return targetLinks;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExploreResult#agentLinks() agentLinks} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for agentLinks
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableExploreResult withAgentLinks(ExploreResult.Links<AgentId, AgentId> value) {
    if (this.agentLinks == value) return this;
    ExploreResult.Links<AgentId, AgentId> newValue = Objects.requireNonNull(value, "agentLinks");
    return new ImmutableExploreResult(this, newValue, this.targetLinks);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExploreResult#targetLinks() targetLinks} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for targetLinks
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableExploreResult withTargetLinks(ExploreResult.Links<AgentId, TargetId> value) {
    if (this.targetLinks == value) return this;
    ExploreResult.Links<AgentId, TargetId> newValue = Objects.requireNonNull(value, "targetLinks");
    return new ImmutableExploreResult(this, this.agentLinks, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExploreResult} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExploreResult
        && equalsByValue((ImmutableExploreResult) another);
  }

  private boolean equalsByValue(ImmutableExploreResult another) {
    return agentLinks.equals(another.agentLinks)
        && targetLinks.equals(another.targetLinks);
  }

  /**
   * Computes a hash code from attributes: {@code agentLinks}, {@code targetLinks}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + agentLinks.hashCode();
    h += (h << 5) + targetLinks.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ExploreResult} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ExploreResult")
        .omitNullValues()
        .add("agentLinks", agentLinks)
        .add("targetLinks", targetLinks)
        .toString();
  }

  /**
   * Construct a new immutable {@code ExploreResult} instance.
   * @param agentLinks The value for the {@code agentLinks} attribute
   * @param targetLinks The value for the {@code targetLinks} attribute
   * @return An immutable ExploreResult instance
   */
  public static ImmutableExploreResult of(ExploreResult.Links<AgentId, AgentId> agentLinks, ExploreResult.Links<AgentId, TargetId> targetLinks) {
    return new ImmutableExploreResult(agentLinks, targetLinks);
  }

  /**
   * Creates an immutable copy of a {@link ExploreResult} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ExploreResult instance
   */
  public static ImmutableExploreResult copyOf(ExploreResult instance) {
    if (instance instanceof ImmutableExploreResult) {
      return (ImmutableExploreResult) instance;
    }
    return ImmutableExploreResult.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableExploreResult ImmutableExploreResult}.
   * <pre>
   * ImmutableExploreResult.builder()
   *    .agentLinks(fr.enedis.chutney.agent.domain.explore.ExploreResult.Links&lt;fr.enedis.chutney.agent.domain.explore.AgentId, fr.enedis.chutney.agent.domain.explore.AgentId&gt;) // required {@link ExploreResult#agentLinks() agentLinks}
   *    .targetLinks(fr.enedis.chutney.agent.domain.explore.ExploreResult.Links&lt;fr.enedis.chutney.agent.domain.explore.AgentId, fr.enedis.chutney.agent.domain.TargetId&gt;) // required {@link ExploreResult#targetLinks() targetLinks}
   *    .build();
   * </pre>
   * @return A new ImmutableExploreResult builder
   */
  public static ImmutableExploreResult.Builder builder() {
    return new ImmutableExploreResult.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableExploreResult ImmutableExploreResult}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ExploreResult", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_AGENT_LINKS = 0x1L;
    private static final long INIT_BIT_TARGET_LINKS = 0x2L;
    private long initBits = 0x3L;

    private @Nullable ExploreResult.Links<AgentId, AgentId> agentLinks;
    private @Nullable ExploreResult.Links<AgentId, TargetId> targetLinks;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ExploreResult} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ExploreResult instance) {
      Objects.requireNonNull(instance, "instance");
      this.agentLinks(instance.agentLinks());
      this.targetLinks(instance.targetLinks());
      return this;
    }

    /**
     * Initializes the value for the {@link ExploreResult#agentLinks() agentLinks} attribute.
     * @param agentLinks The value for agentLinks 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder agentLinks(ExploreResult.Links<AgentId, AgentId> agentLinks) {
      this.agentLinks = Objects.requireNonNull(agentLinks, "agentLinks");
      initBits &= ~INIT_BIT_AGENT_LINKS;
      return this;
    }

    /**
     * Initializes the value for the {@link ExploreResult#targetLinks() targetLinks} attribute.
     * @param targetLinks The value for targetLinks 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder targetLinks(ExploreResult.Links<AgentId, TargetId> targetLinks) {
      this.targetLinks = Objects.requireNonNull(targetLinks, "targetLinks");
      initBits &= ~INIT_BIT_TARGET_LINKS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableExploreResult ImmutableExploreResult}.
     * @return An immutable instance of ExploreResult
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableExploreResult build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableExploreResult(null, agentLinks, targetLinks);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_AGENT_LINKS) != 0) attributes.add("agentLinks");
      if ((initBits & INIT_BIT_TARGET_LINKS) != 0) attributes.add("targetLinks");
      return "Cannot build ExploreResult, some of required attributes are not set " + attributes;
    }
  }

  /**
   * Immutable implementation of {@link ExploreResult.Links}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableExploreResult.Links.builder()}.
   * Use the static factory method to create immutable instances:
   * {@code ImmutableExploreResult.Links.of()}.
   */
  @Generated(from = "ExploreResult.Links", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  public static final class Links<SOURCE, DESTINATION>
      implements ExploreResult.Links<SOURCE, DESTINATION> {
    private final ImmutableSet<ExploreResult.Link<SOURCE, DESTINATION>> links;

    private Links(
        Iterable<? extends ExploreResult.Link<SOURCE, DESTINATION>> links) {
      this.links = ImmutableSet.copyOf(links);
    }

    private Links(
        ImmutableExploreResult.Links<SOURCE, DESTINATION> original,
        ImmutableSet<ExploreResult.Link<SOURCE, DESTINATION>> links) {
      this.links = links;
    }

    /**
     * @return The value of the {@code links} attribute
     */
    @Override
    public ImmutableSet<ExploreResult.Link<SOURCE, DESTINATION>> links() {
      return links;
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link ExploreResult.Links#links() links}.
     * @param elements The elements to set
     * @return A modified copy of {@code this} object
     */
    @SafeVarargs @SuppressWarnings("varargs")
    public final ImmutableExploreResult.Links<SOURCE, DESTINATION> withLinks(ExploreResult.Link<SOURCE, DESTINATION>... elements) {
      ImmutableSet<ExploreResult.Link<SOURCE, DESTINATION>> newValue = ImmutableSet.copyOf(elements);
      return new ImmutableExploreResult.Links<>(this, newValue);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link ExploreResult.Links#links() links}.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements An iterable of links elements to set
     * @return A modified copy or {@code this} if not changed
     */
    public final ImmutableExploreResult.Links<SOURCE, DESTINATION> withLinks(Iterable<? extends ExploreResult.Link<SOURCE, DESTINATION>> elements) {
      if (this.links == elements) return this;
      ImmutableSet<ExploreResult.Link<SOURCE, DESTINATION>> newValue = ImmutableSet.copyOf(elements);
      return new ImmutableExploreResult.Links<>(this, newValue);
    }

    /**
     * This instance is equal to all instances of {@code Links} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableExploreResult.Links<?, ?>
          && equalsByValue((ImmutableExploreResult.Links<?, ?>) another);
    }

    private boolean equalsByValue(ImmutableExploreResult.Links<?, ?> another) {
      return links.equals(another.links);
    }

    /**
     * Computes a hash code from attributes: {@code links}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + links.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code Links} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("Links")
          .omitNullValues()
          .add("links", links)
          .toString();
    }

    /**
     * Construct a new immutable {@code Links} instance.
   * @param <SOURCE> generic parameter SOURCE
   * @param <DESTINATION> generic parameter DESTINATION
     * @param links The value for the {@code links} attribute
     * @return An immutable Links instance
     */
    public static <SOURCE, DESTINATION> ImmutableExploreResult.Links<SOURCE, DESTINATION> of(Set<ExploreResult.Link<SOURCE, DESTINATION>> links) {
      return of((Iterable<? extends ExploreResult.Link<SOURCE, DESTINATION>>) links);
    }

    /**
     * Construct a new immutable {@code Links} instance.
   * @param <SOURCE> generic parameter SOURCE
   * @param <DESTINATION> generic parameter DESTINATION
     * @param links The value for the {@code links} attribute
     * @return An immutable Links instance
     */
    public static <SOURCE, DESTINATION> ImmutableExploreResult.Links<SOURCE, DESTINATION> of(Iterable<? extends ExploreResult.Link<SOURCE, DESTINATION>> links) {
      return new ImmutableExploreResult.Links<>(links);
    }

    /**
     * Creates an immutable copy of a {@link ExploreResult.Links} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param <SOURCE> generic parameter SOURCE
     * @param <DESTINATION> generic parameter DESTINATION
     * @param instance The instance to copy
     * @return A copied immutable Links instance
     */
    public static <SOURCE, DESTINATION> ImmutableExploreResult.Links<SOURCE, DESTINATION> copyOf(ExploreResult.Links<SOURCE, DESTINATION> instance) {
      if (instance instanceof ImmutableExploreResult.Links<?, ?>) {
        return (ImmutableExploreResult.Links<SOURCE, DESTINATION>) instance;
      }
      return ImmutableExploreResult.Links.<SOURCE, DESTINATION>builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableExploreResult.Links Links}.
     * <pre>
     * ImmutableExploreResult.Links.&lt;SOURCE, DESTINATION&gt;builder()
     *    .addLinks|addAllLinks(fr.enedis.chutney.agent.domain.explore.ExploreResult.Link&lt;SOURCE, DESTINATION&gt;) // {@link ExploreResult.Links#links() links} elements
     *    .build();
     * </pre>
     * @param <SOURCE> generic parameter SOURCE
     * @param <DESTINATION> generic parameter DESTINATION
     * @return A new Links builder
     */
    public static <SOURCE, DESTINATION> ImmutableExploreResult.Links.Builder<SOURCE, DESTINATION> builder() {
      return new ImmutableExploreResult.Links.Builder<>();
    }

    /**
     * Builds instances of type {@link ImmutableExploreResult.Links Links}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "ExploreResult.Links", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder<SOURCE, DESTINATION> {
      private ImmutableSet.Builder<ExploreResult.Link<SOURCE, DESTINATION>> links = ImmutableSet.builder();

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code Links} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * Collection elements and entries will be added, not replaced.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder<SOURCE, DESTINATION> from(ExploreResult.Links<SOURCE, DESTINATION> instance) {
        Objects.requireNonNull(instance, "instance");
        addAllLinks(instance.links());
        return this;
      }

      /**
       * Adds one element to {@link ExploreResult.Links#links() links} set.
       * @param element A links element
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder<SOURCE, DESTINATION> addLinks(ExploreResult.Link<SOURCE, DESTINATION> element) {
        this.links.add(element);
        return this;
      }

      /**
       * Adds elements to {@link ExploreResult.Links#links() links} set.
       * @param elements An array of links elements
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      @SafeVarargs @SuppressWarnings("varargs")
      public final Builder<SOURCE, DESTINATION> addLinks(ExploreResult.Link<SOURCE, DESTINATION>... elements) {
        this.links.add(elements);
        return this;
      }


      /**
       * Sets or replaces all elements for {@link ExploreResult.Links#links() links} set.
       * @param elements An iterable of links elements
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder<SOURCE, DESTINATION> links(Iterable<? extends ExploreResult.Link<SOURCE, DESTINATION>> elements) {
        this.links = ImmutableSet.builder();
        return addAllLinks(elements);
      }

      /**
       * Adds elements to {@link ExploreResult.Links#links() links} set.
       * @param elements An iterable of links elements
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder<SOURCE, DESTINATION> addAllLinks(Iterable<? extends ExploreResult.Link<SOURCE, DESTINATION>> elements) {
        this.links.addAll(elements);
        return this;
      }

      /**
       * Builds a new {@link ImmutableExploreResult.Links Links}.
       * @return An immutable instance of Links
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableExploreResult.Links<SOURCE, DESTINATION> build() {
        return new ImmutableExploreResult.Links<>(null, links.build());
      }
    }
  }

  /**
   * Immutable implementation of {@link ExploreResult.Link}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableExploreResult.Link.builder()}.
   * Use the static factory method to create immutable instances:
   * {@code ImmutableExploreResult.Link.of()}.
   */
  @Generated(from = "ExploreResult.Link", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  public static final class Link<SOURCE, DESTINATION>
      implements ExploreResult.Link<SOURCE, DESTINATION> {
    private final SOURCE source;
    private final DESTINATION destination;

    private Link(SOURCE source, DESTINATION destination) {
      this.source = Objects.requireNonNull(source, "source");
      this.destination = Objects.requireNonNull(destination, "destination");
    }

    private Link(ImmutableExploreResult.Link<SOURCE, DESTINATION> original, SOURCE source, DESTINATION destination) {
      this.source = source;
      this.destination = destination;
    }

    /**
     * @return The value of the {@code source} attribute
     */
    @Override
    public SOURCE source() {
      return source;
    }

    /**
     * @return The value of the {@code destination} attribute
     */
    @Override
    public DESTINATION destination() {
      return destination;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ExploreResult.Link#source() source} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for source
     * @return A modified copy or the {@code this} object
     */
    public final ImmutableExploreResult.Link<SOURCE, DESTINATION> withSource(SOURCE value) {
      if (this.source == value) return this;
      SOURCE newValue = Objects.requireNonNull(value, "source");
      return new ImmutableExploreResult.Link<>(this, newValue, this.destination);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ExploreResult.Link#destination() destination} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for destination
     * @return A modified copy or the {@code this} object
     */
    public final ImmutableExploreResult.Link<SOURCE, DESTINATION> withDestination(DESTINATION value) {
      if (this.destination == value) return this;
      DESTINATION newValue = Objects.requireNonNull(value, "destination");
      return new ImmutableExploreResult.Link<>(this, this.source, newValue);
    }

    /**
     * This instance is equal to all instances of {@code Link} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableExploreResult.Link<?, ?>
          && equalsByValue((ImmutableExploreResult.Link<?, ?>) another);
    }

    private boolean equalsByValue(ImmutableExploreResult.Link<?, ?> another) {
      return source.equals(another.source)
          && destination.equals(another.destination);
    }

    /**
     * Computes a hash code from attributes: {@code source}, {@code destination}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + source.hashCode();
      h += (h << 5) + destination.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code Link} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("Link")
          .omitNullValues()
          .add("source", source)
          .add("destination", destination)
          .toString();
    }

    /**
     * Construct a new immutable {@code Link} instance.
   * @param <SOURCE> generic parameter SOURCE
   * @param <DESTINATION> generic parameter DESTINATION
     * @param source The value for the {@code source} attribute
     * @param destination The value for the {@code destination} attribute
     * @return An immutable Link instance
     */
    public static <SOURCE, DESTINATION> ImmutableExploreResult.Link<SOURCE, DESTINATION> of(SOURCE source, DESTINATION destination) {
      return new ImmutableExploreResult.Link<>(source, destination);
    }

    /**
     * Creates an immutable copy of a {@link ExploreResult.Link} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param <SOURCE> generic parameter SOURCE
     * @param <DESTINATION> generic parameter DESTINATION
     * @param instance The instance to copy
     * @return A copied immutable Link instance
     */
    public static <SOURCE, DESTINATION> ImmutableExploreResult.Link<SOURCE, DESTINATION> copyOf(ExploreResult.Link<SOURCE, DESTINATION> instance) {
      if (instance instanceof ImmutableExploreResult.Link<?, ?>) {
        return (ImmutableExploreResult.Link<SOURCE, DESTINATION>) instance;
      }
      return ImmutableExploreResult.Link.<SOURCE, DESTINATION>builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableExploreResult.Link Link}.
     * <pre>
     * ImmutableExploreResult.Link.&lt;SOURCE, DESTINATION&gt;builder()
     *    .source(SOURCE) // required {@link ExploreResult.Link#source() source}
     *    .destination(DESTINATION) // required {@link ExploreResult.Link#destination() destination}
     *    .build();
     * </pre>
     * @param <SOURCE> generic parameter SOURCE
     * @param <DESTINATION> generic parameter DESTINATION
     * @return A new Link builder
     */
    public static <SOURCE, DESTINATION> ImmutableExploreResult.Link.Builder<SOURCE, DESTINATION> builder() {
      return new ImmutableExploreResult.Link.Builder<>();
    }

    /**
     * Builds instances of type {@link ImmutableExploreResult.Link Link}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "ExploreResult.Link", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder<SOURCE, DESTINATION> {
      private static final long INIT_BIT_SOURCE = 0x1L;
      private static final long INIT_BIT_DESTINATION = 0x2L;
      private long initBits = 0x3L;

      private @Nullable SOURCE source;
      private @Nullable DESTINATION destination;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code Link} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder<SOURCE, DESTINATION> from(ExploreResult.Link<SOURCE, DESTINATION> instance) {
        Objects.requireNonNull(instance, "instance");
        this.source(instance.source());
        this.destination(instance.destination());
        return this;
      }

      /**
       * Initializes the value for the {@link ExploreResult.Link#source() source} attribute.
       * @param source The value for source 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder<SOURCE, DESTINATION> source(SOURCE source) {
        this.source = Objects.requireNonNull(source, "source");
        initBits &= ~INIT_BIT_SOURCE;
        return this;
      }

      /**
       * Initializes the value for the {@link ExploreResult.Link#destination() destination} attribute.
       * @param destination The value for destination 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder<SOURCE, DESTINATION> destination(DESTINATION destination) {
        this.destination = Objects.requireNonNull(destination, "destination");
        initBits &= ~INIT_BIT_DESTINATION;
        return this;
      }

      /**
       * Builds a new {@link ImmutableExploreResult.Link Link}.
       * @return An immutable instance of Link
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableExploreResult.Link<SOURCE, DESTINATION> build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableExploreResult.Link<>(null, source, destination);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_SOURCE) != 0) attributes.add("source");
        if ((initBits & INIT_BIT_DESTINATION) != 0) attributes.add("destination");
        return "Cannot build Link, some of required attributes are not set " + attributes;
      }
    }
  }
}
