package fr.enedis.chutney.execution.api;

import fr.enedis.chutney.server.core.domain.execution.report.ScenarioExecutionReport;
import fr.enedis.chutney.server.core.domain.execution.report.ServerReportStatus;
import fr.enedis.chutney.server.core.domain.execution.report.StepExecutionReportCore;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-09-19T09:10:11+0000",
    comments = "version: 1.6.2, compiler: javac, environment: Java 21.0.8 (Eclipse Adoptium)"
)
@Component
public class ScenarioExecutionReportMapperImpl implements ScenarioExecutionReportMapper {

    @Override
    public ScenarioExecutionReportDto toDto(ScenarioExecutionReport source) {
        if ( source == null ) {
            return null;
        }

        long executionId = 0L;
        String scenarioName = null;
        String environment = null;
        String user = null;
        Set<String> tags = null;
        Map<String, Object> contextVariables = null;
        StepExecutionReportCoreDto report = null;

        executionId = source.executionId;
        scenarioName = source.scenarioName;
        environment = source.environment;
        user = source.user;
        Set<String> set = source.tags;
        if ( set != null ) {
            tags = new LinkedHashSet<String>( set );
        }
        Map<String, Object> map = source.contextVariables;
        if ( map != null ) {
            contextVariables = new LinkedHashMap<String, Object>( map );
        }
        report = toStepDto( source.report );

        ScenarioExecutionReportDto scenarioExecutionReportDto = new ScenarioExecutionReportDto( executionId, scenarioName, environment, user, tags, contextVariables, report );

        return scenarioExecutionReportDto;
    }

    @Override
    public StepExecutionReportCoreDto toStepDto(StepExecutionReportCore domain) {
        if ( domain == null ) {
            return null;
        }

        String name = null;
        Long duration = null;
        Instant startDate = null;
        ServerReportStatus status = null;
        List<String> information = null;
        List<String> errors = null;
        List<StepExecutionReportCoreDto> steps = null;
        String type = null;
        String targetName = null;
        String targetUrl = null;
        String strategy = null;
        Map<String, Object> evaluatedInputs = null;
        Map<String, Object> stepOutputs = null;

        name = domain.name;
        duration = domain.duration;
        startDate = domain.startDate;
        status = domain.getStatus();
        List<String> list = domain.information;
        if ( list != null ) {
            information = new ArrayList<String>( list );
        }
        List<String> list1 = domain.errors;
        if ( list1 != null ) {
            errors = new ArrayList<String>( list1 );
        }
        steps = stepExecutionReportCoreListToStepExecutionReportCoreDtoList( domain.steps );
        type = domain.type;
        targetName = domain.targetName;
        targetUrl = domain.targetUrl;
        strategy = domain.strategy;
        Map<String, Object> map = domain.evaluatedInputs;
        if ( map != null ) {
            evaluatedInputs = new LinkedHashMap<String, Object>( map );
        }
        Map<String, Object> map1 = domain.stepOutputs;
        if ( map1 != null ) {
            stepOutputs = new LinkedHashMap<String, Object>( map1 );
        }

        StepExecutionReportCoreDto stepExecutionReportCoreDto = new StepExecutionReportCoreDto( name, duration, startDate, status, information, errors, steps, type, targetName, targetUrl, strategy, evaluatedInputs, stepOutputs );

        return stepExecutionReportCoreDto;
    }

    protected List<StepExecutionReportCoreDto> stepExecutionReportCoreListToStepExecutionReportCoreDtoList(List<StepExecutionReportCore> list) {
        if ( list == null ) {
            return null;
        }

        List<StepExecutionReportCoreDto> list1 = new ArrayList<StepExecutionReportCoreDto>( list.size() );
        for ( StepExecutionReportCore stepExecutionReportCore : list ) {
            list1.add( toStepDto( stepExecutionReportCore ) );
        }

        return list1;
    }
}
