
package fr.enedis.chutney.scenario.api.raw.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RawTestCaseDto}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRawTestCaseDto.builder()}.
 */
@Generated(from = "RawTestCaseDto", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableRawTestCaseDto implements RawTestCaseDto {
  private final String scenario;
  private final @Nullable String id;
  private final String title;
  private final @Nullable String description;
  private final List<String> tags;
  private final @Nullable String defaultDataset;
  private final Instant creationDate;
  private final String author;
  private final Instant updateDate;
  private final Integer version;

  private ImmutableRawTestCaseDto(ImmutableRawTestCaseDto.Builder builder) {
    this.scenario = builder.scenario;
    this.id = builder.id;
    this.title = builder.title;
    this.description = builder.description;
    this.tags = createUnmodifiableList(true, builder.tags);
    this.defaultDataset = builder.defaultDataset;
    if (builder.creationDate != null) {
      initShim.creationDate(builder.creationDate);
    }
    if (builder.author != null) {
      initShim.author(builder.author);
    }
    if (builder.updateDate != null) {
      initShim.updateDate(builder.updateDate);
    }
    if (builder.version != null) {
      initShim.version(builder.version);
    }
    this.creationDate = initShim.creationDate();
    this.author = initShim.author();
    this.updateDate = initShim.updateDate();
    this.version = initShim.version();
    this.initShim = null;
  }

  private ImmutableRawTestCaseDto(
      String scenario,
      @Nullable String id,
      String title,
      @Nullable String description,
      List<String> tags,
      @Nullable String defaultDataset,
      Instant creationDate,
      String author,
      Instant updateDate,
      Integer version) {
    this.scenario = scenario;
    this.id = id;
    this.title = title;
    this.description = description;
    this.tags = tags;
    this.defaultDataset = defaultDataset;
    this.creationDate = creationDate;
    this.author = author;
    this.updateDate = updateDate;
    this.version = version;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "RawTestCaseDto", generator = "Immutables")
  private final class InitShim {
    private byte creationDateBuildStage = STAGE_UNINITIALIZED;
    private Instant creationDate;

    Instant creationDate() {
      if (creationDateBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (creationDateBuildStage == STAGE_UNINITIALIZED) {
        creationDateBuildStage = STAGE_INITIALIZING;
        this.creationDate = Objects.requireNonNull(creationDateInitialize(), "creationDate");
        creationDateBuildStage = STAGE_INITIALIZED;
      }
      return this.creationDate;
    }

    void creationDate(Instant creationDate) {
      this.creationDate = creationDate;
      creationDateBuildStage = STAGE_INITIALIZED;
    }

    private byte authorBuildStage = STAGE_UNINITIALIZED;
    private String author;

    String author() {
      if (authorBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (authorBuildStage == STAGE_UNINITIALIZED) {
        authorBuildStage = STAGE_INITIALIZING;
        this.author = Objects.requireNonNull(authorInitialize(), "author");
        authorBuildStage = STAGE_INITIALIZED;
      }
      return this.author;
    }

    void author(String author) {
      this.author = author;
      authorBuildStage = STAGE_INITIALIZED;
    }

    private byte updateDateBuildStage = STAGE_UNINITIALIZED;
    private Instant updateDate;

    Instant updateDate() {
      if (updateDateBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (updateDateBuildStage == STAGE_UNINITIALIZED) {
        updateDateBuildStage = STAGE_INITIALIZING;
        this.updateDate = Objects.requireNonNull(updateDateInitialize(), "updateDate");
        updateDateBuildStage = STAGE_INITIALIZED;
      }
      return this.updateDate;
    }

    void updateDate(Instant updateDate) {
      this.updateDate = updateDate;
      updateDateBuildStage = STAGE_INITIALIZED;
    }

    private byte versionBuildStage = STAGE_UNINITIALIZED;
    private Integer version;

    Integer version() {
      if (versionBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (versionBuildStage == STAGE_UNINITIALIZED) {
        versionBuildStage = STAGE_INITIALIZING;
        this.version = Objects.requireNonNull(versionInitialize(), "version");
        versionBuildStage = STAGE_INITIALIZED;
      }
      return this.version;
    }

    void version(Integer version) {
      this.version = version;
      versionBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (creationDateBuildStage == STAGE_INITIALIZING) attributes.add("creationDate");
      if (authorBuildStage == STAGE_INITIALIZING) attributes.add("author");
      if (updateDateBuildStage == STAGE_INITIALIZING) attributes.add("updateDate");
      if (versionBuildStage == STAGE_INITIALIZING) attributes.add("version");
      return "Cannot build RawTestCaseDto, attribute initializers form cycle " + attributes;
    }
  }

  private Instant creationDateInitialize() {
    return RawTestCaseDto.super.creationDate();
  }

  private String authorInitialize() {
    return RawTestCaseDto.super.author();
  }

  private Instant updateDateInitialize() {
    return RawTestCaseDto.super.updateDate();
  }

  private Integer versionInitialize() {
    return RawTestCaseDto.super.version();
  }

  /**
   * @return The value of the {@code scenario} attribute
   */
  @JsonProperty("content")
  @Override
  public String scenario() {
    return scenario;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty(value = "id", required = true)
  @Override
  public Optional<String> id() {
    return Optional.ofNullable(id);
  }

  /**
   * @return The value of the {@code title} attribute
   */
  @JsonProperty(value = "title", required = true)
  @Override
  public String title() {
    return title;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty(value = "description", required = true)
  @Override
  public Optional<String> description() {
    return Optional.ofNullable(description);
  }

  /**
   * @return The value of the {@code tags} attribute
   */
  @JsonProperty(value = "tags", required = true)
  @Override
  public List<String> tags() {
    return tags;
  }

  /**
   * @return The value of the {@code defaultDataset} attribute
   */
  @JsonProperty(value = "defaultDataset", required = true)
  @Override
  public Optional<String> defaultDataset() {
    return Optional.ofNullable(defaultDataset);
  }

  /**
   * @return The value of the {@code creationDate} attribute
   */
  @JsonProperty(value = "creationDate", required = true)
  @Override
  public Instant creationDate() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.creationDate()
        : this.creationDate;
  }

  /**
   * @return The value of the {@code author} attribute
   */
  @JsonProperty(value = "author", required = true)
  @Override
  public String author() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.author()
        : this.author;
  }

  /**
   * @return The value of the {@code updateDate} attribute
   */
  @JsonProperty(value = "updateDate", required = true)
  @Override
  public Instant updateDate() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.updateDate()
        : this.updateDate;
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @JsonProperty(value = "version", required = true)
  @Override
  public Integer version() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.version()
        : this.version;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RawTestCaseDto#scenario() scenario} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for scenario
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableRawTestCaseDto withScenario(String value) {
    String newValue = Objects.requireNonNull(value, "scenario");
    if (this.scenario.equals(newValue)) return this;
    return new ImmutableRawTestCaseDto(
        newValue,
        this.id,
        this.title,
        this.description,
        this.tags,
        this.defaultDataset,
        this.creationDate,
        this.author,
        this.updateDate,
        this.version);
  }

  /**
   * Copy the current immutable object by setting a <em>present</em> value for the optional {@link RawTestCaseDto#id() id} attribute.
   * @param value The value for id
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableRawTestCaseDto withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (Objects.equals(this.id, newValue)) return this;
    return new ImmutableRawTestCaseDto(
        this.scenario,
        newValue,
        this.title,
        this.description,
        this.tags,
        this.defaultDataset,
        this.creationDate,
        this.author,
        this.updateDate,
        this.version);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RawTestCaseDto#id() id} attribute.
   * An equality check is used on inner value to prevent copying of the same value by returning {@code this}.
   * @param optional An optional value for id
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableRawTestCaseDto withId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableRawTestCaseDto(
        this.scenario,
        value,
        this.title,
        this.description,
        this.tags,
        this.defaultDataset,
        this.creationDate,
        this.author,
        this.updateDate,
        this.version);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RawTestCaseDto#title() title} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for title
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableRawTestCaseDto withTitle(String value) {
    String newValue = Objects.requireNonNull(value, "title");
    if (this.title.equals(newValue)) return this;
    return new ImmutableRawTestCaseDto(
        this.scenario,
        this.id,
        newValue,
        this.description,
        this.tags,
        this.defaultDataset,
        this.creationDate,
        this.author,
        this.updateDate,
        this.version);
  }

  /**
   * Copy the current immutable object by setting a <em>present</em> value for the optional {@link RawTestCaseDto#description() description} attribute.
   * @param value The value for description
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableRawTestCaseDto withDescription(String value) {
    String newValue = Objects.requireNonNull(value, "description");
    if (Objects.equals(this.description, newValue)) return this;
    return new ImmutableRawTestCaseDto(
        this.scenario,
        this.id,
        this.title,
        newValue,
        this.tags,
        this.defaultDataset,
        this.creationDate,
        this.author,
        this.updateDate,
        this.version);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RawTestCaseDto#description() description} attribute.
   * An equality check is used on inner value to prevent copying of the same value by returning {@code this}.
   * @param optional An optional value for description
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableRawTestCaseDto withDescription(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableRawTestCaseDto(
        this.scenario,
        this.id,
        this.title,
        value,
        this.tags,
        this.defaultDataset,
        this.creationDate,
        this.author,
        this.updateDate,
        this.version);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link RawTestCaseDto#tags() tags}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRawTestCaseDto withTags(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableRawTestCaseDto(
        this.scenario,
        this.id,
        this.title,
        this.description,
        newValue,
        this.defaultDataset,
        this.creationDate,
        this.author,
        this.updateDate,
        this.version);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link RawTestCaseDto#tags() tags}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of tags elements to set
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableRawTestCaseDto withTags(Iterable<String> elements) {
    if (this.tags == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableRawTestCaseDto(
        this.scenario,
        this.id,
        this.title,
        this.description,
        newValue,
        this.defaultDataset,
        this.creationDate,
        this.author,
        this.updateDate,
        this.version);
  }

  /**
   * Copy the current immutable object by setting a <em>present</em> value for the optional {@link RawTestCaseDto#defaultDataset() defaultDataset} attribute.
   * @param value The value for defaultDataset
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableRawTestCaseDto withDefaultDataset(String value) {
    String newValue = Objects.requireNonNull(value, "defaultDataset");
    if (Objects.equals(this.defaultDataset, newValue)) return this;
    return new ImmutableRawTestCaseDto(
        this.scenario,
        this.id,
        this.title,
        this.description,
        this.tags,
        newValue,
        this.creationDate,
        this.author,
        this.updateDate,
        this.version);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RawTestCaseDto#defaultDataset() defaultDataset} attribute.
   * An equality check is used on inner value to prevent copying of the same value by returning {@code this}.
   * @param optional An optional value for defaultDataset
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableRawTestCaseDto withDefaultDataset(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.defaultDataset, value)) return this;
    return new ImmutableRawTestCaseDto(
        this.scenario,
        this.id,
        this.title,
        this.description,
        this.tags,
        value,
        this.creationDate,
        this.author,
        this.updateDate,
        this.version);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RawTestCaseDto#creationDate() creationDate} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for creationDate
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableRawTestCaseDto withCreationDate(Instant value) {
    if (this.creationDate == value) return this;
    Instant newValue = Objects.requireNonNull(value, "creationDate");
    return new ImmutableRawTestCaseDto(
        this.scenario,
        this.id,
        this.title,
        this.description,
        this.tags,
        this.defaultDataset,
        newValue,
        this.author,
        this.updateDate,
        this.version);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RawTestCaseDto#author() author} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for author
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableRawTestCaseDto withAuthor(String value) {
    String newValue = Objects.requireNonNull(value, "author");
    if (this.author.equals(newValue)) return this;
    return new ImmutableRawTestCaseDto(
        this.scenario,
        this.id,
        this.title,
        this.description,
        this.tags,
        this.defaultDataset,
        this.creationDate,
        newValue,
        this.updateDate,
        this.version);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RawTestCaseDto#updateDate() updateDate} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for updateDate
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableRawTestCaseDto withUpdateDate(Instant value) {
    if (this.updateDate == value) return this;
    Instant newValue = Objects.requireNonNull(value, "updateDate");
    return new ImmutableRawTestCaseDto(
        this.scenario,
        this.id,
        this.title,
        this.description,
        this.tags,
        this.defaultDataset,
        this.creationDate,
        this.author,
        newValue,
        this.version);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RawTestCaseDto#version() version} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableRawTestCaseDto withVersion(Integer value) {
    Integer newValue = Objects.requireNonNull(value, "version");
    if (this.version.equals(newValue)) return this;
    return new ImmutableRawTestCaseDto(
        this.scenario,
        this.id,
        this.title,
        this.description,
        this.tags,
        this.defaultDataset,
        this.creationDate,
        this.author,
        this.updateDate,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRawTestCaseDto} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRawTestCaseDto
        && equalsByValue((ImmutableRawTestCaseDto) another);
  }

  private boolean equalsByValue(ImmutableRawTestCaseDto another) {
    return scenario.equals(another.scenario)
        && Objects.equals(id, another.id)
        && title.equals(another.title)
        && Objects.equals(description, another.description)
        && tags.equals(another.tags)
        && Objects.equals(defaultDataset, another.defaultDataset)
        && creationDate.equals(another.creationDate)
        && author.equals(another.author)
        && updateDate.equals(another.updateDate)
        && version.equals(another.version);
  }

  /**
   * Computes a hash code from attributes: {@code scenario}, {@code id}, {@code title}, {@code description}, {@code tags}, {@code defaultDataset}, {@code creationDate}, {@code author}, {@code updateDate}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + scenario.hashCode();
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + title.hashCode();
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + tags.hashCode();
    h += (h << 5) + Objects.hashCode(defaultDataset);
    h += (h << 5) + creationDate.hashCode();
    h += (h << 5) + author.hashCode();
    h += (h << 5) + updateDate.hashCode();
    h += (h << 5) + version.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RawTestCaseDto} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("RawTestCaseDto{");
    builder.append("scenario=").append(scenario);
    if (id != null) {
      builder.append(", ");
      builder.append("id=").append(id);
    }
    builder.append(", ");
    builder.append("title=").append(title);
    if (description != null) {
      builder.append(", ");
      builder.append("description=").append(description);
    }
    builder.append(", ");
    builder.append("tags=").append(tags);
    if (defaultDataset != null) {
      builder.append(", ");
      builder.append("defaultDataset=").append(defaultDataset);
    }
    builder.append(", ");
    builder.append("creationDate=").append(creationDate);
    builder.append(", ");
    builder.append("author=").append(author);
    builder.append(", ");
    builder.append("updateDate=").append(updateDate);
    builder.append(", ");
    builder.append("version=").append(version);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "RawTestCaseDto", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  static final class Json implements RawTestCaseDto {
    @JsonIgnore @Nullable String scenario;
    @JsonIgnore @Nullable Optional<String> id = Optional.empty();
    @JsonIgnore @Nullable String title;
    @JsonIgnore @Nullable Optional<String> description = Optional.empty();
    @JsonIgnore @Nullable List<String> tags = Collections.emptyList();
    @JsonIgnore @Nullable Optional<String> defaultDataset = Optional.empty();
    @JsonIgnore @Nullable Instant creationDate;
    @JsonIgnore @Nullable String author;
    @JsonIgnore @Nullable Instant updateDate;
    @JsonIgnore @Nullable Integer version;

    @JsonProperty("content")
    public void setScenario(String scenario) {
      this.scenario = scenario;
    }

    @JsonProperty(value = "id", required = true)
    public void setId(Optional<String> id) {
      this.id = id;
    }

    @JsonProperty(value = "title", required = true)
    public void setTitle(String title) {
      this.title = title;
    }

    @JsonProperty(value = "description", required = true)
    public void setDescription(Optional<String> description) {
      this.description = description;
    }

    @JsonProperty(value = "tags", required = true)
    public void setTags(List<String> tags) {
      this.tags = tags;
    }

    @JsonProperty(value = "defaultDataset", required = true)
    public void setDefaultDataset(Optional<String> defaultDataset) {
      this.defaultDataset = defaultDataset;
    }

    @JsonProperty(value = "creationDate", required = true)
    public void setCreationDate(Instant creationDate) {
      this.creationDate = creationDate;
    }

    @JsonProperty(value = "author", required = true)
    public void setAuthor(String author) {
      this.author = author;
    }

    @JsonProperty(value = "updateDate", required = true)
    public void setUpdateDate(Instant updateDate) {
      this.updateDate = updateDate;
    }

    @JsonProperty(value = "version", required = true)
    public void setVersion(Integer version) {
      this.version = version;
    }

    @Override
    public String scenario() { throw new UnsupportedOperationException(); }

    @Override
    public Optional<String> id() { throw new UnsupportedOperationException(); }

    @Override
    public String title() { throw new UnsupportedOperationException(); }

    @Override
    public Optional<String> description() { throw new UnsupportedOperationException(); }

    @Override
    public List<String> tags() { throw new UnsupportedOperationException(); }

    @Override
    public Optional<String> defaultDataset() { throw new UnsupportedOperationException(); }

    @Override
    public Instant creationDate() { throw new UnsupportedOperationException(); }

    @Override
    public String author() { throw new UnsupportedOperationException(); }

    @Override
    public Instant updateDate() { throw new UnsupportedOperationException(); }

    @Override
    public Integer version() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableRawTestCaseDto fromJson(Json json) {
    ImmutableRawTestCaseDto.Builder builder = ImmutableRawTestCaseDto.builder();
    if (json.scenario != null) {
      builder.scenario(json.scenario);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.title != null) {
      builder.title(json.title);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.tags != null) {
      builder.addAllTags(json.tags);
    }
    if (json.defaultDataset != null) {
      builder.defaultDataset(json.defaultDataset);
    }
    if (json.creationDate != null) {
      builder.creationDate(json.creationDate);
    }
    if (json.author != null) {
      builder.author(json.author);
    }
    if (json.updateDate != null) {
      builder.updateDate(json.updateDate);
    }
    if (json.version != null) {
      builder.version(json.version);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link RawTestCaseDto} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RawTestCaseDto instance
   */
  public static ImmutableRawTestCaseDto copyOf(RawTestCaseDto instance) {
    if (instance instanceof ImmutableRawTestCaseDto) {
      return (ImmutableRawTestCaseDto) instance;
    }
    return ImmutableRawTestCaseDto.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRawTestCaseDto ImmutableRawTestCaseDto}.
   * <pre>
   * ImmutableRawTestCaseDto.builder()
   *    .scenario(String) // required {@link RawTestCaseDto#scenario() scenario}
   *    .id(Optional&lt;String&gt;) // optional {@link RawTestCaseDto#id() id}
   *    .title(String) // required {@link RawTestCaseDto#title() title}
   *    .description(Optional&lt;String&gt;) // optional {@link RawTestCaseDto#description() description}
   *    .addTags|addAllTags(String) // {@link RawTestCaseDto#tags() tags} elements
   *    .defaultDataset(Optional&lt;String&gt;) // optional {@link RawTestCaseDto#defaultDataset() defaultDataset}
   *    .creationDate(java.time.Instant) // optional {@link RawTestCaseDto#creationDate() creationDate}
   *    .author(String) // optional {@link RawTestCaseDto#author() author}
   *    .updateDate(java.time.Instant) // optional {@link RawTestCaseDto#updateDate() updateDate}
   *    .version(Integer) // optional {@link RawTestCaseDto#version() version}
   *    .build();
   * </pre>
   * @return A new ImmutableRawTestCaseDto builder
   */
  public static ImmutableRawTestCaseDto.Builder builder() {
    return new ImmutableRawTestCaseDto.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRawTestCaseDto ImmutableRawTestCaseDto}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RawTestCaseDto", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SCENARIO = 0x1L;
    private static final long INIT_BIT_TITLE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String scenario;
    private @Nullable String id;
    private @Nullable String title;
    private @Nullable String description;
    private List<String> tags = new ArrayList<String>();
    private @Nullable String defaultDataset;
    private @Nullable Instant creationDate;
    private @Nullable String author;
    private @Nullable Instant updateDate;
    private @Nullable Integer version;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RawTestCaseDto} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(RawTestCaseDto instance) {
      Objects.requireNonNull(instance, "instance");
      this.scenario(instance.scenario());
      Optional<String> idOptional = instance.id();
      if (idOptional.isPresent()) {
        id(idOptional);
      }
      this.title(instance.title());
      Optional<String> descriptionOptional = instance.description();
      if (descriptionOptional.isPresent()) {
        description(descriptionOptional);
      }
      addAllTags(instance.tags());
      Optional<String> defaultDatasetOptional = instance.defaultDataset();
      if (defaultDatasetOptional.isPresent()) {
        defaultDataset(defaultDatasetOptional);
      }
      this.creationDate(instance.creationDate());
      this.author(instance.author());
      this.updateDate(instance.updateDate());
      this.version(instance.version());
      return this;
    }

    /**
     * Initializes the value for the {@link RawTestCaseDto#scenario() scenario} attribute.
     * @param scenario The value for scenario 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("content")
    public final Builder scenario(String scenario) {
      this.scenario = Objects.requireNonNull(scenario, "scenario");
      initBits &= ~INIT_BIT_SCENARIO;
      return this;
    }

    /**
     * Initializes the optional value {@link RawTestCaseDto#id() id} to id.
     * @param id The value for id
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return this;
    }

    /**
     * Initializes the optional value {@link RawTestCaseDto#id() id} to id.
     * @param id The value for id
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "id", required = true)
    public final Builder id(Optional<String> id) {
      this.id = id.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link RawTestCaseDto#title() title} attribute.
     * @param title The value for title 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "title", required = true)
    public final Builder title(String title) {
      this.title = Objects.requireNonNull(title, "title");
      initBits &= ~INIT_BIT_TITLE;
      return this;
    }

    /**
     * Initializes the optional value {@link RawTestCaseDto#description() description} to description.
     * @param description The value for description
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      return this;
    }

    /**
     * Initializes the optional value {@link RawTestCaseDto#description() description} to description.
     * @param description The value for description
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "description", required = true)
    public final Builder description(Optional<String> description) {
      this.description = description.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link RawTestCaseDto#tags() tags} list.
     * @param element A tags element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTags(String element) {
      this.tags.add(Objects.requireNonNull(element, "tags element"));
      return this;
    }

    /**
     * Adds elements to {@link RawTestCaseDto#tags() tags} list.
     * @param elements An array of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTags(String... elements) {
      for (String element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link RawTestCaseDto#tags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "tags", required = true)
    public final Builder tags(Iterable<String> elements) {
      this.tags.clear();
      return addAllTags(elements);
    }

    /**
     * Adds elements to {@link RawTestCaseDto#tags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllTags(Iterable<String> elements) {
      for (String element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      return this;
    }

    /**
     * Initializes the optional value {@link RawTestCaseDto#defaultDataset() defaultDataset} to defaultDataset.
     * @param defaultDataset The value for defaultDataset
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder defaultDataset(String defaultDataset) {
      this.defaultDataset = Objects.requireNonNull(defaultDataset, "defaultDataset");
      return this;
    }

    /**
     * Initializes the optional value {@link RawTestCaseDto#defaultDataset() defaultDataset} to defaultDataset.
     * @param defaultDataset The value for defaultDataset
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "defaultDataset", required = true)
    public final Builder defaultDataset(Optional<String> defaultDataset) {
      this.defaultDataset = defaultDataset.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link RawTestCaseDto#creationDate() creationDate} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link RawTestCaseDto#creationDate() creationDate}.</em>
     * @param creationDate The value for creationDate 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "creationDate", required = true)
    public final Builder creationDate(Instant creationDate) {
      this.creationDate = Objects.requireNonNull(creationDate, "creationDate");
      return this;
    }

    /**
     * Initializes the value for the {@link RawTestCaseDto#author() author} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link RawTestCaseDto#author() author}.</em>
     * @param author The value for author 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "author", required = true)
    public final Builder author(String author) {
      this.author = Objects.requireNonNull(author, "author");
      return this;
    }

    /**
     * Initializes the value for the {@link RawTestCaseDto#updateDate() updateDate} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link RawTestCaseDto#updateDate() updateDate}.</em>
     * @param updateDate The value for updateDate 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "updateDate", required = true)
    public final Builder updateDate(Instant updateDate) {
      this.updateDate = Objects.requireNonNull(updateDate, "updateDate");
      return this;
    }

    /**
     * Initializes the value for the {@link RawTestCaseDto#version() version} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link RawTestCaseDto#version() version}.</em>
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "version", required = true)
    public final Builder version(Integer version) {
      this.version = Objects.requireNonNull(version, "version");
      return this;
    }

    /**
     * Builds a new {@link ImmutableRawTestCaseDto ImmutableRawTestCaseDto}.
     * @return An immutable instance of RawTestCaseDto
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRawTestCaseDto build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRawTestCaseDto(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SCENARIO) != 0) attributes.add("scenario");
      if ((initBits & INIT_BIT_TITLE) != 0) attributes.add("title");
      return "Cannot build RawTestCaseDto, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
