
package fr.enedis.chutney.scenario.api.raw.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TestCaseIndexDto}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTestCaseIndexDto.builder()}.
 */
@Generated(from = "TestCaseIndexDto", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableTestCaseIndexDto
    implements TestCaseIndexDto {
  private final GwtTestCaseMetadataDto metadata;

  private ImmutableTestCaseIndexDto(GwtTestCaseMetadataDto metadata) {
    this.metadata = metadata;
  }

  /**
   * @return The value of the {@code metadata} attribute
   */
  @JsonProperty(value = "metadata", required = true)
  @Override
  public GwtTestCaseMetadataDto metadata() {
    return metadata;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TestCaseIndexDto#metadata() metadata} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for metadata
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableTestCaseIndexDto withMetadata(GwtTestCaseMetadataDto value) {
    if (this.metadata == value) return this;
    GwtTestCaseMetadataDto newValue = Objects.requireNonNull(value, "metadata");
    return new ImmutableTestCaseIndexDto(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTestCaseIndexDto} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTestCaseIndexDto
        && equalsByValue((ImmutableTestCaseIndexDto) another);
  }

  private boolean equalsByValue(ImmutableTestCaseIndexDto another) {
    return metadata.equals(another.metadata);
  }

  /**
   * Computes a hash code from attributes: {@code metadata}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + metadata.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TestCaseIndexDto} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TestCaseIndexDto")
        .omitNullValues()
        .add("metadata", metadata)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "TestCaseIndexDto", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  static final class Json implements TestCaseIndexDto {
    @JsonIgnore @Nullable GwtTestCaseMetadataDto metadata;

    @JsonProperty(value = "metadata", required = true)
    public void setMetadata(GwtTestCaseMetadataDto metadata) {
      this.metadata = metadata;
    }

    @Override
    public GwtTestCaseMetadataDto metadata() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableTestCaseIndexDto fromJson(Json json) {
    ImmutableTestCaseIndexDto.Builder builder = ImmutableTestCaseIndexDto.builder();
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link TestCaseIndexDto} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TestCaseIndexDto instance
   */
  public static ImmutableTestCaseIndexDto copyOf(TestCaseIndexDto instance) {
    if (instance instanceof ImmutableTestCaseIndexDto) {
      return (ImmutableTestCaseIndexDto) instance;
    }
    return ImmutableTestCaseIndexDto.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTestCaseIndexDto ImmutableTestCaseIndexDto}.
   * <pre>
   * ImmutableTestCaseIndexDto.builder()
   *    .metadata(fr.enedis.chutney.scenario.api.raw.dto.GwtTestCaseMetadataDto) // required {@link TestCaseIndexDto#metadata() metadata}
   *    .build();
   * </pre>
   * @return A new ImmutableTestCaseIndexDto builder
   */
  public static ImmutableTestCaseIndexDto.Builder builder() {
    return new ImmutableTestCaseIndexDto.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTestCaseIndexDto ImmutableTestCaseIndexDto}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TestCaseIndexDto", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_METADATA = 0x1L;
    private long initBits = 0x1L;

    private @Nullable GwtTestCaseMetadataDto metadata;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TestCaseIndexDto} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(TestCaseIndexDto instance) {
      Objects.requireNonNull(instance, "instance");
      this.metadata(instance.metadata());
      return this;
    }

    /**
     * Initializes the value for the {@link TestCaseIndexDto#metadata() metadata} attribute.
     * @param metadata The value for metadata 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "metadata", required = true)
    public final Builder metadata(GwtTestCaseMetadataDto metadata) {
      this.metadata = Objects.requireNonNull(metadata, "metadata");
      initBits &= ~INIT_BIT_METADATA;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTestCaseIndexDto ImmutableTestCaseIndexDto}.
     * @return An immutable instance of TestCaseIndexDto
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTestCaseIndexDto build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTestCaseIndexDto(metadata);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_METADATA) != 0) attributes.add("metadata");
      return "Cannot build TestCaseIndexDto, some of required attributes are not set " + attributes;
    }
  }
}
