/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.maven.profiler;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import fr.jcgay.maven.profiler.KnownElapsedTimeTicker;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.aether.artifact.Artifact;

public class ArtifactDescriptor {
    private final Stopwatch totalStopwatch;

    private ArtifactDescriptor(long totalTime) {
        this.totalStopwatch = KnownElapsedTimeTicker.aStopWatchWithElapsedTime(totalTime);
    }

    public static ArtifactDescriptor instance(Map<Artifact, Stopwatch> times) {
        if (times == null || times.isEmpty()) {
            return new ArtifactDescriptor(0L);
        }
        return new ArtifactDescriptor(ArtifactDescriptor.totalTime(times));
    }

    private static long totalTime(Map<Artifact, Stopwatch> times) {
        long totalTime = 0L;
        for (Stopwatch stopwatch : Iterables.filter(times.values(), (Predicate)Predicates.notNull())) {
            totalTime += stopwatch.elapsedTime(TimeUnit.NANOSECONDS);
        }
        return totalTime;
    }

    public Stopwatch getTotalTimeSpentDownloadingArtifacts() {
        return this.totalStopwatch;
    }
}

