/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking;

import fr.marcwrobel.jbanking.Agreement;
import fr.marcwrobel.jbanking.internal.LastVerification;
import fr.marcwrobel.jbanking.internal.Normalizer;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@LastVerification(value="2023-01-07")
public enum IsoCountry {
    AF("AFG", 4),
    AL("ALB", 8),
    DZ("DZA", 12),
    AD("AND", 20),
    AO("AGO", 24),
    AQ("ATA", 10, null),
    AG("ATG", 28),
    AR("ARG", 32),
    AM("ARM", 51),
    AU("AUS", 36),
    CX("CXR", 162, AU),
    CC("CCK", 166, AU),
    HM("HMD", 334, AU),
    NF("NFK", 574, AU),
    AT("AUT", 40),
    AZ("AZE", 31),
    BS("BHS", 44),
    BH("BHR", 48),
    BD("BGD", 50),
    BB("BRB", 52),
    BY("BLR", 112),
    BE("BEL", 56),
    BZ("BLZ", 84),
    BJ("BEN", 204),
    BT("BTN", 64),
    BO("BOL", 68),
    BA("BIH", 70),
    BW("BWA", 72),
    BR("BRA", 76),
    BN("BRN", 96),
    BG("BGR", 100),
    BF("BFA", 854),
    BI("BDI", 108),
    KH("KHM", 116),
    CM("CMR", 120),
    CA("CAN", 124),
    CV("CPV", 132),
    CF("CAF", 140),
    TD("TCD", 148),
    CL("CHL", 152),
    CN("CHN", 156),
    HK("HKG", 344, CN),
    MO("MAC", 446, CN),
    CO("COL", 170),
    KM("COM", 174),
    CG("COG", 178),
    CR("CRI", 188),
    CI("CIV", 384),
    HR("HRV", 191),
    CU("CUB", 192),
    CY("CYP", 196),
    CZ("CZE", 203),
    DK("DNK", 208),
    FO("FRO", 234, DK),
    GL("GRL", 304, DK),
    DJ("DJI", 262),
    DM("DMA", 212),
    DO("DOM", 214),
    EC("ECU", 218),
    EG("EGY", 818),
    SV("SLV", 222),
    GQ("GNQ", 226),
    ER("ERI", 232),
    EE("EST", 233),
    ET("ETH", 231),
    FJ("FJI", 242),
    FI("FIN", 246),
    AX("ALA", 248, FI),
    FR("FRA", 250),
    GF("GUF", 254, FR),
    PF("PYF", 258, FR),
    TF("ATF", 260, FR),
    GP("GLP", 312, FR),
    MQ("MTQ", 474, FR),
    YT("MYT", 175, FR),
    NC("NCL", 540, FR),
    RE("REU", 638, FR),
    BL("BLM", 652, FR),
    MF("MAF", 663, FR),
    PM("SPM", 666, FR),
    WF("WLF", 876, FR),
    GA("GAB", 266),
    GM("GMB", 270),
    GE("GEO", 268),
    DE("DEU", 276),
    GH("GHA", 288),
    GR("GRC", 300),
    GD("GRD", 308),
    GT("GTM", 320),
    GN("GIN", 324),
    GW("GNB", 624),
    GY("GUY", 328),
    HT("HTI", 332),
    HN("HND", 340),
    HU("HUN", 348),
    IS("ISL", 352),
    IN("IND", 356),
    ID("IDN", 360),
    IR("IRN", 364),
    IQ("IRQ", 368),
    IE("IRL", 372),
    IL("ISR", 376),
    IT("ITA", 380),
    JM("JAM", 388),
    JP("JPN", 392),
    JO("JOR", 400),
    KZ("KAZ", 398),
    KE("KEN", 404),
    KI("KIR", 296),
    XK("XKX", null),
    KW("KWT", 414),
    KG("KGZ", 417),
    LA("LAO", 418),
    LV("LVA", 428),
    LB("LBN", 422),
    LS("LSO", 426),
    LR("LBR", 430),
    LY("LBY", 434),
    LI("LIE", 438),
    LT("LTU", 440),
    LU("LUX", 442),
    MK("MKD", 807),
    MG("MDG", 450),
    MW("MWI", 454),
    MY("MYS", 458),
    MV("MDV", 462),
    ML("MLI", 466),
    MT("MLT", 470),
    MH("MHL", 584),
    MR("MRT", 478),
    MU("MUS", 480),
    MX("MEX", 484),
    FM("FSM", 583),
    MD("MDA", 498),
    MC("MCO", 492),
    MN("MNG", 496),
    ME("MNE", 499),
    MA("MAR", 504),
    MZ("MOZ", 508),
    MM("MMR", 104),
    NA("NAM", 516),
    NR("NRU", 520),
    NP("NPL", 524),
    NL("NLD", 528),
    AW("ABW", 533, NL),
    BQ("BES", 535, NL),
    CW("CUW", 531, NL),
    SX("SXM", 534, NL),
    NZ("NZL", 554),
    CK("COK", 184, NZ),
    NU("NIU", 570, NZ),
    TK("TKL", 772, NZ),
    NI("NIC", 558),
    NE("NER", 562),
    NG("NGA", 566),
    KP("PRK", 408),
    NO("NOR", 578),
    BV("BVT", 74, NO),
    SJ("SJM", 744, NO),
    OM("OMN", 512),
    PK("PAK", 586),
    PW("PLW", 585),
    PS("PSE", 275, null),
    PA("PAN", 591),
    PG("PNG", 598),
    PY("PRY", 600),
    PE("PER", 604),
    PH("PHL", 608),
    PL("POL", 616),
    PT("PRT", 620),
    QA("QAT", 634),
    RO("ROU", 642),
    RU("RUS", 643),
    RW("RWA", 646),
    KN("KNA", 659),
    LC("LCA", 662),
    VC("VCT", 670),
    WS("WSM", 882),
    SM("SMR", 674),
    ST("STP", 678),
    SA("SAU", 682),
    SN("SEN", 686),
    RS("SRB", 688),
    SC("SYC", 690),
    SL("SLE", 694),
    SG("SGP", 702),
    SK("SVK", 703),
    SI("SVN", 705),
    SB("SLB", 90),
    SO("SOM", 706),
    ZA("ZAF", 710),
    KR("KOR", 410),
    SS("SSD", 728),
    ES("ESP", 724),
    LK("LKA", 144),
    SD("SDN", 729),
    SR("SUR", 740),
    SZ("SWZ", 748),
    SE("SWE", 752),
    CH("CHE", 756),
    SY("SYR", 760),
    TW("TWN", 158, null),
    TJ("TJK", 762),
    TZ("TZA", 834),
    TH("THA", 764),
    CD("COD", 180),
    TL("TLS", 626),
    TG("TGO", 768),
    TO("TON", 776),
    TT("TTO", 780),
    TN("TUN", 788),
    TR("TUR", 792),
    TM("TKM", 795),
    TV("TUV", 798),
    UG("UGA", 800),
    UA("UKR", 804),
    AE("ARE", 784),
    GB("GBR", 826),
    AI("AIA", 660, GB),
    BM("BMU", 60, GB),
    IO("IOT", 86, GB),
    VG("VGB", 92, GB),
    KY("CYM", 136, GB),
    FK("FLK", 238, GB),
    GI("GIB", 292, GB),
    GG("GGY", 831, GB),
    IM("IMN", 833, GB),
    JE("JEY", 832, GB),
    MS("MSR", 500, GB),
    PN("PCN", 612, GB),
    SH("SHN", 654, GB),
    GS("SGS", 239, GB),
    TC("TCA", 796, GB),
    US("USA", 840),
    AS("ASM", 16, US),
    GU("GUM", 316, US),
    MP("MNP", 580, US),
    PR("PRI", 630, US),
    UM("UMI", 581, US),
    VI("VIR", 850, US),
    UY("URY", 858),
    UZ("UZB", 860),
    VU("VUT", 548),
    VA("VAT", 336),
    VE("VEN", 862),
    VN("VNM", 704),
    EH("ESH", 732, null),
    YE("YEM", 887),
    ZM("ZMB", 894),
    ZW("ZWE", 716);

    private static final Map<String, IsoCountry> byAlpha2Code;
    private static final Map<String, IsoCountry> byAlpha3Code;
    private static final Map<Integer, IsoCountry> byNumericCode;
    private final String alpha3Code;
    private final Integer numericCode;
    private final boolean independent;
    private final IsoCountry dependsOn;

    private IsoCountry(String alpha3Code, Integer numericCode, boolean independent, IsoCountry dependsOn) {
        this.alpha3Code = Objects.requireNonNull(alpha3Code);
        this.numericCode = numericCode;
        this.independent = independent;
        this.dependsOn = dependsOn;
    }

    private IsoCountry(String alpha3Code, Integer numericCode, IsoCountry dependsOn) {
        this(alpha3Code, numericCode, false, dependsOn);
    }

    private IsoCountry(String alpha3Code, Integer numericCode) {
        this(alpha3Code, numericCode, true, null);
    }

    public String getAlpha2Code() {
        return this.name();
    }

    public String getAlpha3Code() {
        return this.alpha3Code;
    }

    public Optional<Integer> getNumericCode() {
        return Optional.ofNullable(this.numericCode);
    }

    public boolean isIndependent() {
        return this.independent;
    }

    public Optional<IsoCountry> getDependency() {
        return Optional.ofNullable(this.dependsOn);
    }

    public boolean isParticipatingTo(Agreement agreement) {
        if (agreement == null) {
            throw new IllegalArgumentException("the agreement argument cannot be null");
        }
        return agreement.getParticipants().contains((Object)this);
    }

    public Set<Agreement> participations() {
        EnumSet<Agreement> agreements = EnumSet.noneOf(Agreement.class);
        for (Agreement agreement : Agreement.values()) {
            if (!this.isParticipatingTo(agreement)) continue;
            agreements.add(agreement);
        }
        return agreements;
    }

    public static Optional<IsoCountry> fromAlpha2Code(String code) {
        return Optional.ofNullable(byAlpha2Code.get(Normalizer.trimUpperCase(code)));
    }

    public static Optional<IsoCountry> fromAlpha3Code(String code) {
        return Optional.ofNullable(byAlpha3Code.get(Normalizer.trimUpperCase(code)));
    }

    public static Optional<IsoCountry> fromNumericCode(int code) {
        return Optional.ofNullable(byNumericCode.get(code));
    }

    static {
        byAlpha2Code = new HashMap<String, IsoCountry>();
        byAlpha3Code = new HashMap<String, IsoCountry>();
        byNumericCode = new HashMap<Integer, IsoCountry>();
        for (IsoCountry country : IsoCountry.values()) {
            byAlpha2Code.put(country.getAlpha2Code(), country);
            byAlpha3Code.put(country.getAlpha3Code(), country);
            if (country.numericCode == null) continue;
            byNumericCode.put(country.numericCode, country);
        }
    }
}

